/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.actions.title;

import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.TitleForm;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.MappingDispatchAction;

public class DeleteTitleAction
extends MappingDispatchAction {
    private static final Logger logger = Logger.getLogger(DeleteTitleAction.class);

    public ActionForward delete(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TitleForm form = (TitleForm)actionform;
        ITitlePersistenceService service = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
        ActionMessages messages = new ActionMessages();
        long titleId = form.getId();
        if (this.canDeleteTitle(titleId)) {
            service.delete((Serializable)Long.valueOf(titleId));
            form.setTitleDeleted(true);
        } else {
            logger.error((Object)(titleId + " is associated with planner(s) or pitch schedule(s). Hence cannot delete it."));
            messages.add("errorMessages", new ActionMessage("title.delete.errors", (Object)"Title is associated with planner(s) or pitch schedule(s)."));
            this.saveErrors(request, messages);
            form.setTitleDeleted(false);
        }
        request.setAttribute("Multiple Titles", (Object)false);
        return mapping.findForward("success");
    }

    private boolean canDeleteTitle(long titleId) {
        ITitlePersistenceService service = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
        Title title = service.get((Serializable)Long.valueOf(titleId));
        for (IAssetList list : title.getTitlelists()) {
            Schedule s = (Schedule)list;
            if (s.getType() != TitleListType.PLANNER && (s.getType() != TitleListType.PITCH || s.getStatus() != ScheduleStatus.APPROVED)) continue;
            return false;
        }
        return true;
    }
}

