/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.formbeans.title;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.TitleActivity;
import com.tandbergtv.watchpoint.pmm.web.formbeans.title.TitleData;
import com.tandbergtv.watchpoint.pmm.web.util.CustomArrayList;
import com.tandbergtv.watchpoint.pmm.web.util.HTMLOption;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import java.util.ArrayList;
import java.util.List;

public class TitleForm
extends BaseForm {
    private static final long serialVersionUID = -3096716673598687070L;
    private long id;
    private String type;
    private String assetDB;
    private String assetDBName;
    private String status;
    private String metadataLocation;
    private String externalKey;
    private String externalRefURL;
    private List<HTMLOption> types = new ArrayList<HTMLOption>();
    private List<HTMLOption> assetDBs = new ArrayList<HTMLOption>();
    private List<HTMLOption> statuses = new ArrayList<HTMLOption>();
    private List<TitleData> titlesData = new CustomArrayList<TitleData>(TitleData.class);
    private List<HTMLOption> unmappedFiles = new ArrayList<HTMLOption>();
    private boolean titleDeleted;
    private Title title;
    private TitleActivity titleActivity;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = this.trim(type);
    }

    public String getAssetDB() {
        return this.assetDB;
    }

    public void setAssetDB(String assetDB) {
        this.assetDB = this.trim(assetDB);
    }

    public boolean getHasAssetDB() {
        return this.assetDB != null && this.assetDB.length() > 0;
    }

    public String getAssetDBName() {
        return this.assetDBName;
    }

    public void setAssetDBName(String assetDBName) {
        this.assetDBName = assetDBName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = this.trim(status);
    }

    public List<HTMLOption> getTypes() {
        return this.types;
    }

    public void setTypes(List<HTMLOption> types) {
        this.types = types;
    }

    public List<HTMLOption> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<HTMLOption> statuses) {
        this.statuses = statuses;
    }

    public List<TitleData> getTitlesData() {
        return this.titlesData;
    }

    public void setTitlesData(List<TitleData> titlesData) {
        this.titlesData = titlesData;
    }

    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    public void setMetadataLocation(String metadataLocation) {
        this.metadataLocation = this.trim(metadataLocation);
    }

    public List<HTMLOption> getUnmappedFiles() {
        return this.unmappedFiles;
    }

    public void setUnmappedFiles(List<HTMLOption> unmappedFiles) {
        this.unmappedFiles = unmappedFiles;
    }

    public List<HTMLOption> getAssetDBs() {
        return this.assetDBs;
    }

    public void setAssetDBs(List<HTMLOption> assetDBs) {
        this.assetDBs = assetDBs;
    }

    public TitleData getTitleData(String name) {
        if (this.titlesData != null) {
            for (TitleData td : this.titlesData) {
                if (!td.getName().equals(name)) continue;
                return td;
            }
        }
        return null;
    }

    public void addTitleData(TitleData td) {
        if (this.titlesData == null) {
            this.titlesData = new ArrayList<TitleData>();
        }
        this.titlesData.add(td);
    }

    public void addType(HTMLOption type) {
        if (this.types == null) {
            this.types = new ArrayList<HTMLOption>();
        }
        this.types.add(type);
    }

    public void addStatus(HTMLOption status) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<HTMLOption>();
        }
        this.statuses.add(status);
    }

    public void addUnmappedFile(String filePath) {
        if (this.unmappedFiles == null) {
            this.unmappedFiles = new ArrayList<HTMLOption>();
        }
        this.unmappedFiles.add(new HTMLOption(filePath));
    }

    public void addAssetDB(HTMLOption assetDB) {
        if (this.assetDBs == null) {
            this.assetDBs = new ArrayList<HTMLOption>();
        }
        this.assetDBs.add(assetDB);
    }

    public boolean isStatusApproved() {
        return this.status != null && this.status.trim().length() > 0 && TitleStatus.valueOf((String)this.status) == TitleStatus.APPROVED;
    }

    public boolean isEditable() {
        return !this.getHasAssetDB() && !this.isStatusApproved();
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String extenalKey) {
        this.externalKey = extenalKey;
    }

    public String getExternalRefURL() {
        return this.externalRefURL;
    }

    public void setExternalRefURL(String externalRefURL) {
        this.externalRefURL = externalRefURL;
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public TitleActivity getTitleActivity() {
        return this.titleActivity;
    }

    public void setTitleActivity(TitleActivity titleActivity) {
        this.titleActivity = titleActivity;
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        String result = s.trim();
        if (result.length() == 0) {
            result = null;
        }
        return result;
    }

    public boolean getTitleDeleted() {
        return this.titleDeleted;
    }

    public void setTitleDeleted(boolean titleDeleted) {
        this.titleDeleted = titleDeleted;
    }
}

