/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.web.schedule.TimelineEntry;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;

public class ScheduleTimeline {
    private String name;
    private Collection<Schedule> schedules = new ArrayList<Schedule>();
    private Date month;
    private Long id;

    protected ScheduleTimeline() {
    }

    public ScheduleTimeline(Long id, String name, Date month) {
        this();
        this.id = id;
        this.name = name;
        this.month = month;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addSchedule(Schedule schedule) {
        this.schedules.add(schedule);
    }

    public Collection<TimelineEntry> getEntries() {
        ArrayList<TimelineEntry> entries = new ArrayList<TimelineEntry>();
        GregorianCalendar calendar = new GregorianCalendar();
        IScheduleNotifier service = (IScheduleNotifier)ServiceRegistry.getDefault().lookup(IScheduleNotifier.class);
        calendar.setTime(this.month);
        int min = ((Calendar)calendar).getActualMinimum(5);
        int max = ((Calendar)calendar).getActualMaximum(5);
        for (int i = min; i <= max; ++i) {
            TimelineEntry entry = null;
            for (Schedule schedule : this.schedules) {
                if (schedule.getDate().compareTo(calendar.getTime()) != 0) continue;
                entry = new TimelineEntry(schedule.getId().toString(), schedule.getType());
                if (service.getNotification(schedule) == null) break;
                entry.setIsAlert(true);
                break;
            }
            if (entry == null) {
                entry = new TimelineEntry();
            }
            entries.add(entry);
            ((Calendar)calendar).roll(5, 1);
        }
        return entries;
    }

    public String toString() {
        return this.name;
    }
}

