/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.web.schedule.PartnerBean;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleRequest;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleTimeline;
import com.tandbergtv.watchpoint.pmm.web.title.PagingForm;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import com.tandbergtv.watchpoint.pmm.web.util.PMMPageConfig;
import com.tandbergtv.watchpoint.pmm.web.util.PMMPageconfigHelper;
import com.tandbergtv.workflow.web.page.Page;
import com.tandbergtv.workflow.web.table.Table;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ScheduleTimetableForm
extends PagingForm {
    private Map<String, ScheduleTimeline> timelines = new TreeMap<String, ScheduleTimeline>();
    private Date next;
    private Date previous;
    private Date current;
    private DateFormat monthDateFormatter = new SimpleDateFormat("dd");
    private DateFormat formatter;
    private String startDate;
    private String month;
    private String year;
    private static final String SEARCH_PAGE = "schedulesearch";
    private static final Logger logger = Logger.getLogger(ScheduleTimetableForm.class);
    private String spec;
    private static final long serialVersionUID = 7492230738451570978L;

    public ScheduleTimetableForm() {
        String format = CommonUtils.getApplicationUIResourceBundle().getString("dateFormat");
        this.formatter = new SimpleDateFormat(format);
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String start) {
        this.startDate = start;
    }

    public Collection<ScheduleTimeline> getTimelines() {
        return this.timelines.values();
    }

    public boolean getHasSchedules() {
        return this.timelines.size() > 0;
    }

    public Date getNext() {
        return this.next;
    }

    public Date getPrevious() {
        return this.previous;
    }

    public Date getCurrent() {
        return this.current;
    }

    public void setCurrent(Date current) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(current);
        calendar.set(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(9, 0);
        this.current = calendar.getTime();
        this.previous = this.getMonth(this.current, -1);
        this.next = this.getMonth(this.current, 1);
    }

    public void addSchedule(Schedule schedule, PartnerBean partner) {
        String key = partner.getName();
        ScheduleTimeline timeline = this.timelines.get(key);
        if (timeline == null) {
            timeline = new ScheduleTimeline(partner.getContextId(), key, this.current);
            this.timelines.put(key, timeline);
        }
        timeline.addSchedule(schedule);
        logger.debug((Object)("Added timeline " + timeline + ", total " + this.timelines.size()));
    }

    public Collection<String> getDaysOfWeek() {
        ArrayList<String> daysOfWeek = new ArrayList<String>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.current);
        int min = ((Calendar)calendar).getActualMinimum(5);
        int max = ((Calendar)calendar).getActualMaximum(5);
        for (int i = min; i <= max; ++i) {
            daysOfWeek.add(this.formatDayOfWeek(calendar.get(7)));
            ((Calendar)calendar).roll(5, true);
        }
        return daysOfWeek;
    }

    private String formatDayOfWeek(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return "Su";
            }
            case 2: {
                return "M";
            }
            case 3: {
                return "T";
            }
            case 4: {
                return "W";
            }
            case 5: {
                return "Th";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "S";
            }
        }
        return "";
    }

    public Collection<String> getDays() {
        ArrayList<String> days = new ArrayList<String>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.current);
        int min = ((Calendar)calendar).getActualMinimum(5);
        int max = ((Calendar)calendar).getActualMaximum(5);
        for (int i = min; i <= max; ++i) {
            days.add(this.monthDateFormatter.format(calendar.getTime()));
            ((Calendar)calendar).roll(5, true);
        }
        return days;
    }

    public Page getSearchPage() {
        String name = SEARCH_PAGE;
        Page page = null;
        try {
            page = PMMPageConfig.getInstance().getPage(name, PMMPageconfigHelper.getPageConfigFile());
        }
        catch (Exception e) {
            throw new RuntimeException("Search page not found: " + name);
        }
        return page;
    }

    @Override
    public String getCurrentUrl() {
        return this.query + ScheduleRequest.STARTDATE.toString() + this.formatter.format(this.getCurrent());
    }

    @Override
    public String getNextUrl() {
        return this.query + ScheduleRequest.STARTDATE.toString() + this.formatter.format(this.getNext());
    }

    @Override
    public String getPreviousUrl() {
        return this.query + ScheduleRequest.STARTDATE.toString() + this.formatter.format(this.getPrevious());
    }

    public Table getTable() {
        throw new UnsupportedOperationException();
    }

    protected void setTable(String tableId, File configFile) {
        throw new UnsupportedOperationException();
    }

    private Date getMonth(Date start, int diff) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(start);
        ((Calendar)calendar).add(2, diff);
        return calendar.getTime();
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getSpec() {
        return this.spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
}

