/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.schedule;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.bind.ScheduleMarshaller;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.util.XMLDocumentUtility;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleForm;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleFormPopulator;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleStatistics;
import com.tandbergtv.watchpoint.pmm.web.util.PMMTableConfigHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.actions.MappingDispatchAction;
import org.apache.struts.config.ForwardConfig;
import org.w3c.dom.Node;

public class ScheduleTitlesAction
extends MappingDispatchAction {
    private ISchedulePersistenceService service = (ISchedulePersistenceService)ServiceRegistry.getDefault().lookup(ISchedulePersistenceService.class);
    private IScheduleSearchService searchservice = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
    private static final String TABLE_ID = "scheduletitles";
    private static final String ACTIVITY_TABLE_ID = "scheduleactivity";
    private static final String PLANNER_TABLE_ID = "planneractivity";
    private static final Logger logger = Logger.getLogger(ScheduleTitlesAction.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    public ActionForward getBasicView(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        String id = form.getScheduleId();
        Schedule schedule = this.service.get((Serializable)Long.valueOf(Long.parseLong(id)));
        logger.debug((Object)("Schedule " + schedule));
        ScheduleFormPopulator.populateScheduleForm(form);
        form.setSchedule(schedule);
        form.setStatistics(this.getScheduleStatistics(schedule));
        form.setTableId(TABLE_ID, PMMTableConfigHelper.getTableConfigFile());
        return mapping.findForward("default");
    }

    public ActionForward getActivityView(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        String id = form.getScheduleId();
        Schedule schedule = this.service.get((Serializable)Long.valueOf(Long.parseLong(id)));
        logger.debug((Object)("Schedule " + schedule));
        ScheduleFormPopulator.populateScheduleForm(form);
        form.setSchedule(schedule);
        form.setStatistics(this.getScheduleStatistics(schedule));
        File configFile = PMMTableConfigHelper.getTableConfigFile();
        if (schedule instanceof Planner) {
            form.setTableId(PLANNER_TABLE_ID, configFile);
        } else {
            form.setTableId(ACTIVITY_TABLE_ID, configFile);
        }
        return mapping.findForward("default");
    }

    public ActionForward deleteTitles(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        String id = form.getScheduleId();
        Schedule schedule = this.service.get((Serializable)Long.valueOf(Long.parseLong(id)));
        logger.debug((Object)("Schedule " + schedule));
        if (form.getSelectedTitles() == null) {
            throw new ScheduleRuntimeException("At least one title must be selected");
        }
        for (String selected : form.getSelectedTitles()) {
            Long titleId = Long.parseLong(selected);
            logger.debug((Object)("Title id " + titleId));
            Title title = schedule.getTitle(titleId);
            if (title == null) continue;
            schedule.removeTitle(title);
        }
        this.service.save(schedule);
        ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("default"));
        redirect.addParameter("scheduleId", (Object)schedule.getId().toString());
        return redirect;
    }

    public ActionForward export(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScheduleForm form = (ScheduleForm)actionform;
        String id = form.getScheduleId();
        logger.debug((Object)("Schedule id " + id));
        Schedule schedule = this.service.get((Serializable)Long.valueOf(Long.parseLong(id)));
        this.addTransientProperties(schedule);
        Node node = ScheduleMarshaller.newInstance().marshal(schedule);
        String xml = XMLDocumentUtility.convertToString((Node)node);
        String exportFileName = this.generateFileName(schedule);
        this.writeHeaders(response, exportFileName);
        this.writeScheduleXml(response, xml);
        return null;
    }

    private String generateFileName(Schedule schedule) {
        String exportFileName = "";
        if (schedule instanceof Planner) {
            Long partnerId = schedule.getSourcePartnerID();
            exportFileName = this.getPartner(partnerId).getName();
        } else if (schedule instanceof DistributionSchedule) {
            exportFileName = ((DistributionSchedule)schedule).getPartner();
        }
        Date scheduleDate = schedule.getDate();
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        exportFileName = exportFileName + "_" + formatter.format(scheduleDate) + ".xml";
        return exportFileName;
    }

    private ScheduleStatistics getScheduleStatistics(Schedule schedule) {
        String bundle = ((Object)((Object)this)).getClass().getPackage().getName() + ".schedule";
        int count = Integer.parseInt(ResourceBundle.getBundle(bundle).getString("history"));
        Collection previous = this.searchservice.getPreviousSchedules(schedule, count);
        ScheduleStatistics stats = new ScheduleStatistics(schedule, previous);
        return stats;
    }

    private void addTransientProperties(Schedule schedule) {
        Long partnerId = schedule.getSourcePartnerID();
        if (partnerId != null) {
            String providerID = this.getPartner(partnerId).getProviderId();
            schedule.setProviderID(providerID);
        }
        Long contextID = schedule.getContextID();
        if (schedule instanceof DistributionSchedule) {
            DistributionSchedule d = (DistributionSchedule)DistributionSchedule.class.cast(schedule);
            String destination = this.getDestination(contextID);
            d.setPartner(destination);
        }
    }

    private void writeHeaders(HttpServletResponse response, String exportFileName) {
        response.setContentType("application/xml");
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Content-Disposition", "attachment; filename=" + exportFileName);
    }

    private Partner getPartner(Long partnerId) {
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");
        for (Serializable key : cache.getKeys()) {
            IContainer container = (IContainer)cache.get(key);
            if (container.getContainerType() != ContainerType.PARTNER) continue;
            Partner partner = (Partner)Partner.class.cast(container);
            if (partnerId.longValue() != partner.getId()) continue;
            return partner;
        }
        throw new RuntimeException("Partner not found: " + partnerId);
    }

    private String getDestination(Long contextID) {
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");
        IContainer container = (IContainer)cache.get((Serializable)contextID);
        return container.getContainerName();
    }

    private void writeScheduleXml(HttpServletResponse response, String xml) throws Exception {
        PrintWriter out = response.getWriter();
        out.write(xml);
        out.println();
        out.close();
    }
}

