/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.search;

import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.web.page.Field;
import com.tandbergtv.workflow.web.page.Page;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;

public abstract class AbstractSearchCriteriaBuilder {
    private static final Logger logger = Logger.getLogger(AbstractSearchCriteriaBuilder.class);

    public SearchCriteria getSearchCriteria() {
        SearchCriteria criteria = this.getDefaultSearchCriteria();
        logger.debug((Object)("Request URL " + this.getRequest().getQueryString()));
        this.addSearchCriteria(criteria);
        return criteria;
    }

    protected void addSearchCriteria(SearchCriteria criteria) {
        HttpServletRequest request = this.getRequest();
        Page page = this.getPage();
        for (Field field : page.getFields()) {
            String[] values = request.getParameterValues(field.getName());
            if (values == null || !field.hasValues(values)) continue;
            logger.debug((Object)("Creating criterion for field " + field.getName()));
            this.addSearchCriteria(criteria, field, values);
        }
    }

    protected void addSearchCriteria(SearchCriteria criteria, Field field, String ... values) {
        Entity e = this.getEntity(criteria);
        SearchParameterBase parameter = this.getCriterion(field, field.getName(), values);
        e.addParameter(parameter);
    }

    protected SearchParameterBase getCriterion(Field field, String name, String ... values) {
        SearchType type = field.getSearchType();
        SearchOperator operator = field.getSearchOperator();
        if (field.getIsValueParameter()) {
            return new ValueParameter(name, type, false, (Object)values[0], operator);
        }
        if (field.getIsListParameter()) {
            ListParameter parameter = new ListParameter(name, type, operator);
            for (String value : values) {
                parameter.addValue((Object)value);
            }
            return parameter;
        }
        if (field.getIsRangeParameter()) {
            RangeParameter range = new RangeParameter(name, type);
            String from = values[0];
            String to = values[1];
            if (from.length() > 0) {
                range.setFrom(from);
            }
            if (to.length() > 0) {
                range.setTo(to);
            }
            return range;
        }
        throw new UnsupportedOperationException("Cannot create search parameter for field " + field.getName());
    }

    protected abstract Page getPage();

    protected abstract SearchCriteria getDefaultSearchCriteria();

    protected abstract Entity getEntity(SearchCriteria var1);

    protected abstract ActionForm getForm();

    protected abstract HttpServletRequest getRequest();
}

