/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title;

import com.tandbergtv.watchpoint.pmm.web.title.TitleRequest;
import com.tandbergtv.workflow.util.SortingOrder;
import com.tandbergtv.workflow.web.formbeans.PaginationAndSortingForm;
import com.tandbergtv.workflow.web.table.Column;

public abstract class PagingForm
extends PaginationAndSortingForm {
    private static final long serialVersionUID = 5044591449569510290L;
    protected String query;
    protected int start;

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getPageUrl(String size) {
        int i = Integer.parseInt(size);
        if (i == this.getPageSize() || this.getPreviousPageSize(size) >= this.getTotalRecords()) {
            return null;
        }
        return this.query + this.getUrl(0, i);
    }

    private int getPreviousPageSize(String size) {
        int previousSize = 0;
        String[] sizes = this.getPageSizes();
        for (int i = 0; i < sizes.length; ++i) {
            if (!sizes[i].equals(size)) continue;
            previousSize = i > 0 ? Integer.parseInt(sizes[i - 1]) : 0;
            break;
        }
        return previousSize;
    }

    public String getCurrentUrl() {
        return this.query + this.getUrl(this.start, this.getPageSize());
    }

    public String getNextUrl() {
        int page = this.getCurrentPageNo();
        if (page < this.getMaximumPageNumber()) {
            int start = page * this.getPageSize();
            int count = this.getPageSize();
            return this.query + this.getUrl(start, count);
        }
        return null;
    }

    public String getPreviousUrl() {
        int page = this.getCurrentPageNo() - 2;
        if (page >= 0) {
            int start = page * this.getPageSize();
            int count = this.getPageSize();
            return this.query + this.getUrl(start, count);
        }
        return null;
    }

    public String getFirstUrl() {
        if (this.getCurrentPageNo() == 1) {
            return null;
        }
        return this.query + this.getUrl(0, this.getPageSize());
    }

    public String getLastUrl() {
        if (this.getCurrentPageNo() == this.getMaximumPageNumber()) {
            return null;
        }
        int start = (this.getMaximumPageNumber() - 1) * this.getPageSize();
        int count = this.getPageSize();
        return this.query + this.getUrl(start, count);
    }

    public String getGotoUrl() {
        if (this.getNumberOfPages() <= 1) {
            return null;
        }
        String url = this.query + this.getUrl(0, this.getPageSize());
        int startIndex = url.indexOf(TitleRequest.START.toString());
        int endIndex = url.indexOf("&", startIndex + TitleRequest.START.toString().length());
        url = url.substring(0, startIndex) + (endIndex != -1 ? url.substring(endIndex) : "");
        return url;
    }

    public String getColumnUrl(String columnName) {
        Column column = this.getTable().getColumn(columnName);
        String name = column.getSortingColumnName();
        if (name.equals(this.getSortingColumnName())) {
            SortingOrder order = SortingOrder.valueOf((String)this.getSortingOrder());
            if (order == SortingOrder.ASCENDING) {
                return this.query + this.getUrl(this.start, this.getPageSize(), name, SortingOrder.DESCENDING.toString());
            }
            return this.query + this.getUrl(this.start, this.getPageSize(), name, SortingOrder.ASCENDING.toString());
        }
        return this.query + this.getUrl(this.start, this.getPageSize(), name, this.getTable().getDefaultSortingOrder());
    }

    protected String getUrl(int start, int count) {
        StringBuilder s = new StringBuilder();
        return s.append((Object)TitleRequest.START).append(start).append((Object)TitleRequest.PAGE_SIZE).append(count).append((Object)TitleRequest.SORT_COLUMN).append(this.getSortingColumnName()).append((Object)TitleRequest.SORT_ORDER).append(this.getSortingOrder()).toString();
    }

    protected String getUrl(int start, int count, String column, String order) {
        StringBuilder s = new StringBuilder();
        return s.append((Object)TitleRequest.START).append(start).append((Object)TitleRequest.PAGE_SIZE).append(count).append((Object)TitleRequest.SORT_COLUMN).append(column).append((Object)TitleRequest.SORT_ORDER).append(order).toString();
    }
}

