/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title;

import java.util.HashMap;
import java.util.Map;

public class TitleExternalKeySerializer {
    private static final char ENTRY_SEPARATOR = ';';
    private static final char VALUE_SEPARATOR = '=';
    private static final char ESCAPE_SEQUENCE = '[';

    private TitleExternalKeySerializer() {
    }

    public static TitleExternalKeySerializer newInstance() {
        return new TitleExternalKeySerializer();
    }

    public String serialize(Map<String, String> externalKey) {
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        for (String key : externalKey.keySet()) {
            String value = externalKey.get(key);
            if (!isFirst) {
                buf.append(';');
            } else {
                isFirst = false;
            }
            buf.append(this.escapeValue(key));
            buf.append('=');
            buf.append(this.escapeValue(value));
        }
        return buf.toString();
    }

    public Map<String, String> deserialize(String externalKey) {
        HashMap<String, String> keys = new HashMap<String, String>();
        if (externalKey == null) {
            return keys;
        }
        String currentKey = null;
        StringBuilder buf = new StringBuilder();
        for (int currentIndex = 0; currentIndex < externalKey.length(); ++currentIndex) {
            char c = externalKey.charAt(currentIndex);
            if (c == '[') {
                buf.append(externalKey.charAt(currentIndex + 1));
                ++currentIndex;
                continue;
            }
            if (c == '=') {
                if (currentKey != null) {
                    String msg = "Failure deserializing title external key:  " + externalKey + ", found unexpected character: " + c + " at index: " + currentIndex + " when expecting character: " + ';';
                    throw new RuntimeException(msg);
                }
                currentKey = buf.toString();
                buf.setLength(0);
                continue;
            }
            if (c == ';') {
                if (currentKey == null) {
                    String msg = "Failure deserializing title external key: " + externalKey + ", found unexpected character: " + c + " at index: " + currentIndex + " when expecting character: " + '=';
                    throw new RuntimeException(msg);
                }
                keys.put(currentKey, buf.toString());
                currentKey = null;
                buf.setLength(0);
                continue;
            }
            buf.append(c);
        }
        if (currentKey != null) {
            keys.put(currentKey, buf.toString());
        } else if (buf.length() > 0) {
            String msg = "Failure deserializing title external key: " + externalKey + ", no value specified for key: " + buf.toString() + " at end external key string.";
            throw new RuntimeException(msg);
        }
        return keys;
    }

    private String escapeValue(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int index = 0; index < value.length(); ++index) {
            char c = value.charAt(index);
            if (c == ';' || c == '=' || c == '[') {
                buf.append('[');
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

