/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleServiceException;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationException;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage;
import com.tandbergtv.watchpoint.pmm.web.title.ExternalTitleForm;
import com.tandbergtv.watchpoint.pmm.web.title.TitleExternalKeySerializer;
import com.tandbergtv.watchpoint.pmm.web.util.TitleFacade;
import com.tandbergtv.watchpoint.pmm.web.util.TitleHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.MappingDispatchAction;

public class TitleImportAction
extends MappingDispatchAction {
    private static final Logger logger = Logger.getLogger(TitleImportAction.class);
    private static final String IMPORT_FAILED_KEY = "error.title.import.failure";
    private static final String SYNC_FAILED_KEY = "error.title.sync.failure";

    public ActionForward importTitles(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExternalTitleForm form = (ExternalTitleForm)actionform;
        String[] selectedTitles = form.getSelectedTitles();
        if (selectedTitles == null || selectedTitles.length == 0) {
            throw new RuntimeException("No titles selected for import.");
        }
        ArrayList<Title> importedTitles = new ArrayList<Title>();
        LinkedHashMap<String, String> failedTitles = new LinkedHashMap<String, String>();
        ActionMessages messages = new ActionMessages();
        for (String selectedTitle : selectedTitles) {
            try {
                importedTitles.add(this.importTitle(form, selectedTitle));
            }
            catch (Exception e) {
                this.handleFailure(e, selectedTitle, messages, request, true);
                failedTitles.put(selectedTitle, this.describeTitleExternalKey(selectedTitle));
            }
        }
        form.setSuccessfulTitles(importedTitles);
        form.setFailedTitles(failedTitles);
        this.setExternalSourceName(form);
        form.setOperationName("imported");
        if (!messages.isEmpty()) {
            this.saveMessages(request, messages);
        }
        return mapping.findForward("default");
    }

    public ActionForward importTitle(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExternalTitleForm form = (ExternalTitleForm)actionform;
        String titleKey = form.getExternalKey();
        try {
            Title importedTitle = this.importTitle(form, titleKey);
            form.setTitle(importedTitle);
        }
        catch (Exception e) {
            ActionMessages messages = new ActionMessages();
            this.handleFailure(e, titleKey, messages, request, true);
            HashMap<String, String> failedTitles = new HashMap<String, String>();
            failedTitles.put(titleKey, this.describeTitleExternalKey(titleKey));
            form.setFailedTitles(failedTitles);
            this.saveMessages(request, messages);
        }
        form.setOperationName("imported");
        this.setExternalSourceName(form);
        return mapping.findForward("default");
    }

    public ActionForward synchronizeTitles(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExternalTitleForm form = (ExternalTitleForm)actionform;
        String[] selectedTitles = form.getSelectedTitles();
        if (selectedTitles == null || selectedTitles.length == 0) {
            throw new RuntimeException("No titles selected for sync.");
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleService titleService = (ITitleService)registry.lookup(ITitleService.class);
        ActionMessages messages = new ActionMessages();
        ArrayList<Title> successfulTitles = new ArrayList<Title>();
        LinkedHashMap<String, Title> failedTitles = new LinkedHashMap<String, Title>();
        for (String selectedTitle : selectedTitles) {
            Title title = null;
            try {
                title = TitleFacade.findTitle(Long.parseLong(selectedTitle));
                title = titleService.syncTitle(title);
                successfulTitles.add(title);
            }
            catch (Exception e) {
                this.handleFailure(e, selectedTitle, messages, request, false);
                failedTitles.put(selectedTitle, title);
            }
        }
        if (!messages.isEmpty()) {
            this.saveMessages(request, messages);
        }
        form.setSuccessfulTitles(successfulTitles);
        form.setFailedTitles(failedTitles);
        form.setOperationName("synchronized");
        return mapping.findForward("default");
    }

    public ActionForward synchronizeTitle(ActionMapping mapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExternalTitleForm form = (ExternalTitleForm)actionform;
        Title title = null;
        try {
            title = TitleFacade.findTitle(form.getId());
            String externalLocationId = title.getExternalLocation();
            if (externalLocationId == null || externalLocationId.trim().length() == 0) {
                title.setExternalLocation(form.getAssetDB());
                TitleHelper.copyMetadata(form.getTitlesData(), title);
            }
            ServiceRegistry registry = ServiceRegistry.getDefault();
            ITitleService titleService = (ITitleService)registry.lookup(ITitleService.class);
            title = titleService.syncTitle(title);
            form.setTitle(title);
        }
        catch (Exception e) {
            ActionMessages messages = new ActionMessages();
            String key = Long.toString(form.getId());
            this.handleFailure(e, key, messages, request, false);
            HashMap<String, Title> failedTitles = new HashMap<String, Title>();
            failedTitles.put(key, title);
            form.setFailedTitles(failedTitles);
            this.saveMessages(request, messages);
        }
        form.setOperationName("synchronized");
        this.setExternalSourceName(form);
        return mapping.findForward("default");
    }

    private Title importTitle(ExternalTitleForm form, String titleExternalKey) {
        String specName = form.getType();
        String externalSourceId = form.getAssetDB();
        TitleExternalKeySerializer serializer = TitleExternalKeySerializer.newInstance();
        Map<String, String> keys = serializer.deserialize(titleExternalKey);
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITitleService titleService = (ITitleService)registry.lookup(ITitleService.class);
        Title title = titleService.getExternalTitle(specName, externalSourceId, keys);
        return titleService.importTitle(title);
    }

    private void handleFailure(Exception exception, String titleKey, ActionMessages actionMessages, HttpServletRequest request, boolean isImport) {
        String actionName = isImport ? "import" : "sync";
        String msg = "Failure during title " + actionName + ", failed Title key[" + titleKey + "].";
        logger.error((Object)msg, (Throwable)exception);
        if (exception instanceof ValidationException) {
            ValidationException ve = (ValidationException)((Object)exception);
            List messages = ve.getValidationMessages();
            this.addActionMessages(actionMessages, request, titleKey, messages);
        } else if (exception instanceof TitleServiceException) {
            TitleServiceException tse = (TitleServiceException)((Object)exception);
            this.addActionMessages(actionMessages, request, titleKey, tse.getFailureMessage());
        } else {
            String messageKey = isImport ? IMPORT_FAILED_KEY : SYNC_FAILED_KEY;
            actionMessages.add(titleKey, new ActionMessage(messageKey, true));
        }
    }

    private String describeTitleExternalKey(String externalKey) {
        try {
            TitleExternalKeySerializer serializer = TitleExternalKeySerializer.newInstance();
            Map<String, String> externalKeys = serializer.deserialize(externalKey);
            StringBuilder buf = new StringBuilder();
            boolean isFirst = true;
            for (String key : externalKeys.keySet()) {
                String value = externalKeys.get(key);
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append(": ");
                buf.append(value);
            }
            return buf.toString();
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to parse the Title external key: " + externalKey + " when creating displayable key."), (Throwable)e);
            return externalKey;
        }
    }

    private void setExternalSourceName(ExternalTitleForm form) {
        ServiceRegistry serviceRegistry;
        ITitleProviderRegistry registry;
        ITitleProvider externalProvider;
        String externalSourceId = form.getAssetDB();
        String name = "";
        if (externalSourceId != null && externalSourceId.trim().length() > 0 && (name = (externalProvider = (registry = (ITitleProviderRegistry)(serviceRegistry = ServiceRegistry.getDefault()).lookup(ITitleProviderRegistry.class)).getProviderForTitle(externalSourceId)).getProviderInstance(externalSourceId).getName()) == null) {
            name = "";
        }
        form.setAssetDBName(name);
    }

    private void addActionMessages(ActionMessages actionMessages, HttpServletRequest request, String messageKey, List<ValidationMessage> validationMessages) {
        for (ValidationMessage message : validationMessages) {
            this.addActionMessages(actionMessages, request, messageKey, message);
        }
    }

    private void addActionMessages(ActionMessages actionMessages, HttpServletRequest request, String messageKey, ValidationMessage validationMessage) {
        String key = validationMessage.getCode();
        Object[] values = validationMessage.getProperties().toArray();
        ActionMessage actionMessage = new ActionMessage(key, values);
        actionMessages.add(messageKey, actionMessage);
    }
}

