/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title;

import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.web.schedule.PartnerBean;
import com.tandbergtv.watchpoint.pmm.web.title.ScheduleData;
import com.tandbergtv.watchpoint.pmm.web.title.TitleBean;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class TitleProgressBean
extends TitleBean
implements Comparable<TitleProgressBean> {
    protected Collection<ProgressItem> progressItems;
    private static final String PROGRESS = "progress";
    protected ScheduleData source;
    protected Collection<ScheduleData> destinations;

    public TitleProgressBean(Title title, Collection<ProgressItem> progressItems) {
        super(title);
        this.progressItems = progressItems;
        this.destinations = new LinkedList<ScheduleData>();
    }

    public boolean getIsProgress(String parameter) {
        return parameter.startsWith(PROGRESS);
    }

    public boolean getIsMetadata(String parameter) {
        return !parameter.startsWith(PROGRESS);
    }

    public Long getSourceId() {
        if (this.source != null) {
            return this.source.getId();
        }
        return null;
    }

    public String getSourceName() {
        if (this.source != null) {
            return this.source.partner.getName();
        }
        return null;
    }

    public String getPlannerId() {
        if (this.source != null) {
            return this.source.schedule.getId().toString();
        }
        return null;
    }

    public String getArrivalDate() {
        if (this.source == null) {
            return null;
        }
        return CommonUtils.formatDate(this.source.schedule.getDate());
    }

    public Collection<ScheduleData> getDestinations() {
        return this.destinations;
    }

    public void addPlanner(Schedule planner, PartnerBean sourcePartner) {
        if (planner.getType() != TitleListType.PLANNER) {
            throw new ScheduleRuntimeException(planner + " is not a planner?");
        }
        ArrayList<ProgressItem> progressItems = new ArrayList<ProgressItem>();
        for (ProgressItem progress : this.title.getProgressItems()) {
            if (!planner.getId().equals(progress.getAssetListId())) continue;
            progressItems.add(progress);
        }
        this.source = new ScheduleData(planner, sourcePartner, progressItems);
    }

    public String getPlannerDescription() {
        return this.source != null ? this.getSourceName() + " : " + this.getArrivalDate() : null;
    }

    public void addPitch(Schedule pitch, PartnerBean destination) {
        if (pitch.getType() != TitleListType.PITCH) {
            throw new ScheduleRuntimeException(pitch + " is not a pitch?");
        }
        ArrayList<ProgressItem> progressItems = new ArrayList<ProgressItem>();
        for (ProgressItem progress : this.title.getProgressItems()) {
            if (!pitch.getId().equals(progress.getAssetListId())) continue;
            progressItems.add(progress);
        }
        this.destinations.add(new ScheduleData(pitch, destination, progressItems));
    }

    public String getPids() {
        if (this.getProcessIds().size() > 0) {
            return "view";
        }
        return null;
    }

    public String getPidUrl() {
        String pids = "";
        for (Long id : this.getProcessIds()) {
            if (pids.length() > 0) {
                pids = pids + ",";
            }
            pids = pids + id.toString();
        }
        return pids;
    }

    private Collection<Long> getProcessIds() {
        HashSet<Long> ids = new HashSet<Long>();
        for (ProgressItem progress : this.progressItems) {
            Long id = this.getProcessId(progress);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    private Long getProcessId(ProgressItem progress) {
        StringTokenizer tokenizer;
        if (progress.getSourceEntityName() != null && progress.getSourceEntityName().contains("Workflow") && (tokenizer = new StringTokenizer(progress.getSourceId().trim(), "|")).countTokens() > 1) {
            Long id = Long.parseLong(tokenizer.nextToken());
            return id;
        }
        return null;
    }

    public String getParamValue(String parameter) {
        return this.getParameter(parameter, null);
    }

    public String getParameter(String parameter, String sectionName) {
        if (this.getIsMetadata(parameter)) {
            return super.getTitleMetadata(parameter, sectionName);
        }
        String name = parameter.substring(PROGRESS.length());
        ProgressItem progress = this.getProgressItem(name);
        if (progress == null) {
            return "";
        }
        if (progress.getIsSuccess().booleanValue()) {
            return "OK";
        }
        return "X";
    }

    public String getParameter(String parameter, int index) {
        String name = parameter.substring(PROGRESS.length());
        ProgressItem progress = this.getProgressItem(name, index);
        if (progress == null) {
            return "&nbsp;";
        }
        if (progress.getIsSuccess().booleanValue()) {
            return "OK";
        }
        return "X";
    }

    public String getUrlValue(String parameter) {
        Long id;
        if (this.getIsMetadata(parameter)) {
            return null;
        }
        String name = parameter.substring(PROGRESS.length());
        ProgressItem progress = this.getProgressItem(name);
        if (progress != null && (id = this.getProcessId(progress)) != null) {
            return id.toString();
        }
        return null;
    }

    public String getUrlValue(String parameter, int index) {
        Long id;
        String name = parameter.substring(PROGRESS.length());
        ProgressItem progress = this.getProgressItem(name, index);
        if (progress != null && (id = this.getProcessId(progress)) != null) {
            return id.toString();
        }
        return null;
    }

    public String getHoverText(String parameter) {
        if (this.getIsMetadata(parameter)) {
            return "";
        }
        String name = parameter.substring(PROGRESS.length());
        ProgressItem progress = this.getProgressItem(name);
        if (progress != null) {
            return CommonUtils.formatTime(progress.getTimestamp());
        }
        return "";
    }

    public String getHoverText(String parameter, int index) {
        String name = parameter.substring(PROGRESS.length());
        ProgressItem progress = this.getProgressItem(name, index);
        if (progress != null) {
            return CommonUtils.formatTime(progress.getTimestamp());
        }
        return "";
    }

    private ProgressItem getProgressItem(String name) {
        for (ProgressItem progress : this.progressItems) {
            if (!progress.getName().equalsIgnoreCase(name)) continue;
            return progress;
        }
        return null;
    }

    private ProgressItem getProgressItem(String name, int index) {
        int i = 0;
        for (ScheduleData data : this.destinations) {
            if (i == index) {
                for (ProgressItem progress : data.getProgressItems()) {
                    if (!name.equalsIgnoreCase(progress.getName())) continue;
                    return progress;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public int compareTo(TitleProgressBean titleProgress) {
        int lastCmp = titleProgress.getId().compareTo(this.getId());
        return lastCmp;
    }
}

