/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.title.search;

import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderInstance;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.pmm.web.title.TitleSearchType;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.web.page.Field;
import com.tandbergtv.workflow.web.page.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TitleSearchPageBuilder {
    private static final String INTERNAL_SEARCH_PAGE = "titlesearch";
    private static final String EXTERNAL_SEARCH_PAGE = "titlesearch.external";

    private TitleSearchPageBuilder() {
    }

    public static TitleSearchPageBuilder newInstance() {
        return new TitleSearchPageBuilder();
    }

    public Page buildSearchPage(TitleSearchType searchType, String specificationName) throws Exception {
        Page searchPage = this.buildDefaultSearchPage(searchType);
        Specification specification = this.getSpecification(specificationName);
        if (specification == null) {
            return searchPage;
        }
        ArrayList searchVariables = null;
        if (searchType == TitleSearchType.EXTERNAL) {
            searchVariables = new ArrayList();
            this.updateExternalTitleProviderInstances(searchPage, specification);
        } else {
            searchVariables = new ArrayList();
        }
        if (searchVariables != null) {
            for (Variable searchVariable : searchVariables) {
                Field searchField = this.buildSearchField(searchType, searchVariable);
                searchPage.getFields().add(searchField);
            }
        }
        return searchPage;
    }

    public Page buildDefaultSearchPage(TitleSearchType searchType) throws Exception {
        boolean isExternal = searchType == TitleSearchType.EXTERNAL;
        String searchPageName = isExternal ? EXTERNAL_SEARCH_PAGE : INTERNAL_SEARCH_PAGE;
        return null;
    }

    private Specification getSpecification(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager specManager = (ISpecificationManager)registry.lookup(ISpecificationManager.class);
        return specManager.getSpecificationByName(name);
    }

    private Field buildSearchField(TitleSearchType searchType, Variable searchVariable) {
        Field searchField = new Field();
        Map fieldAttributes = searchField.getAttributesMap();
        String column = searchType == TitleSearchType.EXTERNAL ? "1" : "2";
        String dataType = "STRING";
        String type = "textbox";
        String paramType = "value";
        String operator = "LIKE";
        if (Datatype.DATE.toString().equals("")) {
            type = "dateRange";
            paramType = "range";
            operator = null;
        }
        fieldAttributes.put("name", searchVariable.getName());
        fieldAttributes.put("label", searchVariable.getDisplayName());
        fieldAttributes.put("dataType", dataType);
        fieldAttributes.put("type", type);
        fieldAttributes.put("paramType", paramType);
        fieldAttributes.put("column", column);
        fieldAttributes.put("operator", operator);
        fieldAttributes.put("entity", "metadata");
        return searchField;
    }

    private void updateExternalTitleProviderInstances(Page searchPage, Specification specification) {
        String fieldName = TitleSearchKey.TITLE_EXTERNAL_LOCATION.toString();
        Field field = (Field)searchPage.getFieldsMap().get(fieldName);
        if (field == null) {
            return;
        }
        LinkedHashMap<String, String> instanceNames = new LinkedHashMap<String, String>();
        field.setValuesMap(instanceNames);
        ArrayList allInstances = new ArrayList();
        ServiceRegistry serviceRegistry = ServiceRegistry.getDefault();
        ITitleProviderRegistry registry = (ITitleProviderRegistry)serviceRegistry.lookup(ITitleProviderRegistry.class);
        Collection providers = registry.getProviders(specification.getName());
        for (ITitleProvider provider : providers) {
            Collection instances = provider.getProviderInstances();
            if (instances == null) continue;
            allInstances.addAll(instances);
        }
        Collections.sort(allInstances, new Comparator<ITitleProviderInstance>(){

            @Override
            public int compare(ITitleProviderInstance o1, ITitleProviderInstance o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (ITitleProviderInstance instance : allInstances) {
            instanceNames.put(instance.getKey(), instance.getName());
        }
    }
}

