/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.util;

import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

public class GUISearchHelper {
    private static final int FIVE_RECORDS = 5;

    public static Collection<Schedule> getCurrentPitchSchedules(Long contextId) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("pitch", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        Date today = new Date();
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, new SimpleDateFormat("yyyy-MM-dd").format(today));
        e.addParameter((SearchParameterBase)range);
        e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.ASCENDING));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setRecordsCount(5);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Collection lsSchedules = searchService.search(criteria);
        return lsSchedules;
    }

    public static Collection<Schedule> getCurrentPlanners(Long partnerId) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter("sourcePartnerID", SearchType.NUMERIC, (Object)partnerId));
        Date today = new Date();
        RangeParameter range = new RangeParameter("date", SearchType.DATE, new SimpleDateFormat("yyyy-MM-dd").format(today));
        e.addParameter((SearchParameterBase)range);
        e.addParameter((SearchParameterBase)new SortParameter("date", SortingOrder.ASCENDING));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setRecordsCount(5);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Collection lsSchedules = searchService.search(criteria);
        return lsSchedules;
    }
}

