/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.validators;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.web.formbeans.partner.PartnerForm;
import com.tandbergtv.watchpoint.pmm.web.util.PartnerFormPopulator;
import com.tandbergtv.watchpoint.pmm.web.validators.ValidatorProperties;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class PartnerValidator {
    private static final int MAX_LENGTH_25 = 25;
    private static final Logger logger = Logger.getLogger(PartnerValidator.class);
    private static final int MAX_LENGTH_50 = 50;
    private static final int MAX_LENGTH_500 = 500;
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    public static boolean validatePartnerField(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        IContainer container;
        ICacheService containerCache;
        String errorMessage;
        String specialCharacterPattern;
        if (!request.getQueryString().equals("method=createPartner") && !request.getQueryString().equals("method=updatePartner")) {
            return true;
        }
        boolean isValid = true;
        PartnerForm partnerForm = (PartnerForm)((Object)obj);
        String specialCharacterList = ValidatorProperties.getProperty("forbiddenSpecialCharacters");
        if (field.getKey().equalsIgnoreCase("partnerName")) {
            logger.debug((Object)("partnerForm.getName()=" + partnerForm.getName() + "."));
            logger.debug((Object)("partnerForm.getId()=" + partnerForm.getId()));
            if (partnerForm.getName() == null || partnerForm.getName().trim().length() == 0) {
                msgs.add(field.getKey(), new ActionMessage("Partner name is required.", false));
                logger.warn((Object)"Partner name is required.");
                isValid = false;
            } else {
                if (partnerForm.getName().trim().length() > 25) {
                    msgs.add(field.getKey(), new ActionMessage("Partner name cannot exceed 25 characters.", false));
                    logger.warn((Object)"Partner name cannot exceed 25 characters.");
                    isValid = false;
                }
                if (partnerForm.getName().trim().length() > 0 && specialCharacterList != null && !specialCharacterList.equals("")) {
                    specialCharacterPattern = ".*[" + specialCharacterList + "].*";
                    logger.debug((Object)("specialCharacterPattern=" + specialCharacterPattern));
                    if (Pattern.matches(specialCharacterPattern, partnerForm.getName().trim())) {
                        errorMessage = "Partner name cannot contain any of the following characters:" + specialCharacterList;
                        msgs.add(field.getKey(), new ActionMessage(errorMessage, false));
                        logger.warn((Object)errorMessage);
                        isValid = false;
                    }
                }
                if (isValid) {
                    containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
                    for (Serializable key : containerCache.getKeys()) {
                        container = (IContainer)containerCache.get(key);
                        logger.debug((Object)("container.getContainerName()=" + container.getContainerName()));
                        if (container.getContainerType() != ContainerType.PARTNER || !container.getContainerName().trim().equals(partnerForm.getName().trim()) || !partnerForm.getId().equals("") && container.getContainerId() == Long.parseLong(partnerForm.getId())) continue;
                        msgs.add(field.getKey(), new ActionMessage("Partner with the same name already exists.", false));
                        logger.warn((Object)"Partner with the same name already exists.");
                        isValid = false;
                        break;
                    }
                }
            }
        }
        if (field.getKey().equalsIgnoreCase("providerId")) {
            if (partnerForm.getProviderId() == null || partnerForm.getProviderId().trim().length() == 0) {
                msgs.add(field.getKey(), new ActionMessage("Provider Id is required.", false));
                logger.warn((Object)"Provider Id is required.");
                isValid = false;
            } else {
                if (partnerForm.getProviderId().trim().length() > 25) {
                    msgs.add(field.getKey(), new ActionMessage("Provider Id cannot exceed 25 characters.", false));
                    logger.warn((Object)"Provider Id cannot exceed 25 characters.");
                    isValid = false;
                }
                if (partnerForm.getProviderId().trim().length() > 0 && specialCharacterList != null && !specialCharacterList.equals("")) {
                    specialCharacterPattern = ".*[" + specialCharacterList + "].*";
                    logger.debug((Object)("specialCharacterPattern=" + specialCharacterPattern));
                    if (Pattern.matches(specialCharacterPattern, partnerForm.getProviderId().trim())) {
                        errorMessage = "Provider Id cannot contain any of the following characters:" + specialCharacterList;
                        msgs.add(field.getKey(), new ActionMessage(errorMessage, false));
                        logger.warn((Object)errorMessage);
                        isValid = false;
                    }
                }
                if (isValid) {
                    containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
                    for (Serializable key : containerCache.getKeys()) {
                        String providerId;
                        container = (IContainer)containerCache.get(key);
                        if (container.getContainerType() != ContainerType.PARTNER || !(providerId = ((Partner)container).getProviderId()).trim().equals(partnerForm.getProviderId().trim()) || !partnerForm.getId().equals("") && container.getContainerId() == Long.parseLong(partnerForm.getId())) continue;
                        msgs.add(field.getKey(), new ActionMessage("Partner with the same Provider Id already exists.", false));
                        logger.warn((Object)"Partner with the same Provider Id already exists.");
                        isValid = false;
                        break;
                    }
                }
            }
        }
        if (field.getKey().equalsIgnoreCase("firstName")) {
            if (partnerForm.getFirstName() != null && partnerForm.getFirstName().trim().length() > 25) {
                msgs.add(field.getKey(), new ActionMessage("The contact's first name cannot exceed 25 characters.", false));
                logger.warn((Object)"The contact's first name cannot exceed 25 characters.");
                isValid = false;
            } else if (partnerForm.getFirstName().trim().length() > 0 && Pattern.matches(".*\\d.*", partnerForm.getFirstName().trim())) {
                msgs.add(field.getKey(), new ActionMessage("The contact's first name cannot contain numerical characters.", false));
                logger.warn((Object)"The contact's first name cannot contain numerical characters.");
                isValid = false;
            }
        }
        if (field.getKey().equalsIgnoreCase("lastName")) {
            if (partnerForm.getLastName() != null && partnerForm.getLastName().trim().length() > 25) {
                msgs.add(field.getKey(), new ActionMessage("The contact's last name cannot exceed 25 characters.", false));
                logger.warn((Object)"The contact's last name cannot exceed 25 characters.");
                isValid = false;
            } else if (partnerForm.getLastName().trim().length() > 0 && Pattern.matches(".*\\d.*", partnerForm.getLastName().trim())) {
                msgs.add(field.getKey(), new ActionMessage("The contact's last name cannot contain numerical characters.", false));
                logger.warn((Object)"The contact's last name cannot contain numerical characters.");
                isValid = false;
            }
        }
        if (field.getKey().equalsIgnoreCase("email")) {
            String email = partnerForm.getEmail();
            if (email == null || email.trim().length() == 0) {
                msgs.add(field.getKey(), new ActionMessage("The contact's email is required.", false));
                logger.warn((Object)"The contact's email is required.");
                isValid = false;
            } else {
                if (email.trim().length() > 50) {
                    msgs.add(field.getKey(), new ActionMessage("The contact's email cannot exceed 50 characters.", false));
                    logger.warn((Object)"The contact's email cannot exceed 50 characters.");
                    isValid = false;
                }
                try {
                    new InternetAddress(email, true);
                }
                catch (Exception ex) {
                    msgs.add(field.getKey(), new ActionMessage("The contact's email is invalid.", false));
                    logger.warn((Object)"The contact's email is invalid.");
                    isValid = false;
                }
            }
        }
        if (field.getKey().equalsIgnoreCase("defaultPitchFreqWeeks") && partnerForm.getDefaultPitchFreqWeeks() != null && !partnerForm.getDefaultPitchFreqWeeks().trim().equals("")) {
            try {
                int weeks = new Integer(partnerForm.getDefaultPitchFreqWeeks());
                if (weeks < 1 || weeks > 52) {
                    msgs.add(field.getKey(), new ActionMessage("The 'weeks' value for the default pitch frequency should be between 1 and 52.", false));
                    logger.warn((Object)"The 'weeks' value for the default pitch frequency should be between 1 and 52.");
                    isValid = false;
                }
            }
            catch (Exception ex) {
                msgs.add(field.getKey(), new ActionMessage("The 'weeks' value for the default pitch frequency is not a number.", false));
                logger.warn((Object)"The 'weeks' value for the default pitch frequency is not a number.");
                isValid = false;
            }
        }
        if (field.getKey().equalsIgnoreCase("notes") && partnerForm.getNotes() != null && partnerForm.getNotes().length() > 500) {
            msgs.add(field.getKey(), new ActionMessage("The Notes field cannot exceed 500 characters.", false));
            logger.warn((Object)"The Notes field cannot exceed 500 characters.");
            isValid = false;
        }
        if (field.getKey().equalsIgnoreCase("lookupKey")) {
            logger.debug((Object)("partnerForm.getLookupKey()=" + partnerForm.getLookupKey() + "."));
            if (partnerForm.getLookupKey() != null && !partnerForm.getLookupKey().equals("")) {
                if (partnerForm.getLookupKey().length() > 25) {
                    msgs.add(field.getKey(), new ActionMessage("The Lookup Key field cannot exceed 25 characters.", false));
                    logger.warn((Object)"The Lookup Key field cannot exceed 25 characters.");
                    isValid = false;
                } else {
                    ICacheService containerCache2 = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
                    logger.debug((Object)("containerCache.count()=" + containerCache2.count()));
                    for (Serializable key : containerCache2.getKeys()) {
                        container = (IContainer)containerCache2.get(key);
                        logger.debug((Object)("container.getContainerLookupKey()=" + container.getContainerLookupKey() + "."));
                        if (container.getContainerLookupKey() == null || !container.getContainerLookupKey().trim().equals(partnerForm.getLookupKey().trim()) || !partnerForm.getId().equals("") && container.getContainerId() == Long.parseLong(partnerForm.getId())) continue;
                        String errorMessage2 = container.getContainerType() + " with the same lookup key already exists.";
                        logger.warn((Object)errorMessage2);
                        msgs.add(field.getKey(), new ActionMessage(errorMessage2, false));
                        isValid = false;
                        break;
                    }
                }
            }
        }
        PartnerFormPopulator.setRequiredInfoInForm(request, partnerForm);
        return isValid;
    }
}

