/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.validators;

import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleValidationCode;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.conf.IRightsManager;
import com.tandbergtv.watchpoint.pmm.title.conf.specs.RightsManagerFactory;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationException;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleForm;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleFormPopulator;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class ScheduleValidator {
    private static final String DATE_FIELD = "date";
    private static final Logger logger = Logger.getLogger(ScheduleValidator.class);
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    public static boolean validatePitchDate(Object obj, ValidatorAction action, Field field, ActionMessages msgs, Validator validator, HttpServletRequest request) {
        if (!request.getRequestURI().endsWith("saveschedule.do") && !request.getRequestURI().endsWith("modifyschedule.do")) {
            return true;
        }
        ScheduleForm form = (ScheduleForm)((Object)obj);
        if (form.getIsPlanner()) {
            return true;
        }
        long contextId = Long.parseLong(form.getContextId());
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)Long.valueOf(contextId));
        if (!field.getKey().equalsIgnoreCase(DATE_FIELD)) {
            return true;
        }
        if (form.getDate() == null || form.getDate().trim().length() == 0) {
            String errorMsg = "Pitch date is required for a Distribution Schedule.";
            msgs.add(field.getKey(), new ActionMessage(errorMsg, false));
            logger.debug((Object)errorMsg);
            ScheduleFormPopulator.repopulateFormFields(form);
            return false;
        }
        if (!ScheduleValidator.isValidDate(form.getDate())) {
            String errorMsg = "Schedule pitch date should be a valid date in the correct format(" + CommonUtils.getDateFormat() + ").";
            msgs.add(field.getKey(), new ActionMessage(errorMsg, false));
            logger.debug((Object)errorMsg);
            ScheduleFormPopulator.repopulateFormFields(form);
            return false;
        }
        if (ScheduleValidator.isDateInPast(form.getDate(), CommonUtils.getDateFormat())) {
            String errorMsg = "Schedule pitch date should be current or in the future.";
            msgs.add(field.getKey(), new ActionMessage(errorMsg, false));
            logger.debug((Object)errorMsg);
            ScheduleFormPopulator.repopulateFormFields(form);
            return false;
        }
        Date pitchDate = null;
        try {
            long scheduleId;
            pitchDate = CommonUtils.getDate(form.getDate());
            long l = scheduleId = form.getScheduleId() == null || form.getScheduleId().trim().length() == 0 ? 0L : Long.parseLong(form.getScheduleId());
            if (ScheduleValidator.schedulePresent(scheduleId, contextId, pitchDate)) {
                String errorMsg = container.getContainerName() + " already has pitch schedules for " + form.getDate() + ". Only one pitch schedule can be associated with a destination on a particular day.";
                msgs.add(field.getKey(), new ActionMessage(errorMsg, false));
                logger.debug((Object)errorMsg);
                ScheduleFormPopulator.repopulateFormFields(form);
                return false;
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            ScheduleValidator.validateTitleLicense(form, pitchDate);
        }
        catch (ValidationException ve) {
            List validationMessages = ve.getValidationMessages();
            for (ValidationMessage message : validationMessages) {
                String key = message.getCode();
                Object[] values = message.getProperties().toArray();
                ActionMessage actionMessage = new ActionMessage(key, values);
                msgs.add("Schedule Validation", actionMessage);
            }
            ScheduleFormPopulator.repopulateFormFields(form);
            return false;
        }
        ScheduleFormPopulator.repopulateFormFields(form);
        return true;
    }

    private static void validateTitleLicense(ScheduleForm form, Date pitchDate) {
        if (form.getScheduleId() == null || form.getScheduleId().trim().length() == 0) {
            return;
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISchedulePersistenceService service = (ISchedulePersistenceService)registry.lookup(ISchedulePersistenceService.class);
        DistributionSchedule schedule = (DistributionSchedule)service.get((Serializable)Long.valueOf(Long.parseLong(form.getScheduleId())));
        IRightsManager rm = RightsManagerFactory.getRightsManager();
        for (Title title : schedule.getTitles()) {
            if (rm == null || rm.isLicensed(title, pitchDate)) continue;
            ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(title.getId().toString());
            messages.add(new ValidationMessage(ScheduleValidationCode.LICENSE_EXPIRES.toString(), ids));
            throw new ValidationException("Title is not licensed", messages);
        }
    }

    private static boolean schedulePresent(long scheduleId, long contextId, Date pitchDate) {
        Iterator iter;
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Collection pitchSchedules = searchService.getPitchSchedulesByPitchDate(Long.valueOf(contextId), pitchDate);
        if (scheduleId == 0L && pitchSchedules.size() > 0) {
            return true;
        }
        return scheduleId != 0L && pitchSchedules.size() > 0 && (iter = pitchSchedules.iterator()).hasNext() && ((DistributionSchedule)iter.next()).getId() != scheduleId;
    }

    private static boolean isValidDate(String date) {
        try {
            String format = CommonUtils.getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat(format);
            df.setLenient(false);
            df.parse(date);
            return date.trim().length() == format.length();
        }
        catch (ParseException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static boolean isDateInPast(String date, String format) {
        try {
            SimpleDateFormat timefomat = new SimpleDateFormat(format);
            timefomat.setLenient(false);
            Date d = timefomat.parse(date);
            Calendar dateCalendar = Calendar.getInstance();
            dateCalendar.setTime(d);
            dateCalendar = ScheduleValidator.resetTime(dateCalendar);
            Calendar currCalendar = Calendar.getInstance();
            currCalendar.setTime(new Date());
            currCalendar = ScheduleValidator.resetTime(currCalendar);
            return dateCalendar.before(currCalendar);
        }
        catch (ParseException e) {
            logger.error((Object)"Parsing error while determining if the date in current or in the future: ", (Throwable)e);
            return true;
        }
    }

    private static Calendar resetTime(Calendar c) {
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.set(9, 0);
        return c;
    }
}

