/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.TitleProperty;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class TitlePropertyManager {
    private static Logger logger = Logger.getLogger(TitlePropertyManager.class);

    public static TitlePropertyManager getInstance() {
        return new TitlePropertyManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitleProperty retrieve(String name, long titleId, Long assetListId, Long contextId) {
        Session session = null;
        try {
            session = this.getSession();
            TitleProperty titleProperty = this.retrieve(session, name, titleId, assetListId, contextId);
            return titleProperty;
        }
        finally {
            this.closeSession(session);
        }
    }

    private TitleProperty retrieve(Session session, String name, long titleId, Long assetListId, Long contextId) {
        StringBuffer querySB = new StringBuffer();
        querySB.append("from TitleProperty p where p.name = :name and p.titleId = :titleId and ");
        if (assetListId != null) {
            querySB.append("assetListId = :assetListId and ");
        } else {
            querySB.append("assetListId is null and ");
        }
        if (contextId != null) {
            querySB.append("contextId = :contextId");
        } else {
            querySB.append("contextId is null");
        }
        Query query = session.createQuery(querySB.toString());
        query.setParameter("name", (Object)name);
        query.setParameter("titleId", (Object)titleId);
        if (assetListId != null) {
            query.setParameter("assetListId", (Object)assetListId);
        }
        if (contextId != null) {
            query.setParameter("contextId", (Object)contextId);
        }
        return (TitleProperty)query.uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitleProperty store(TitleProperty property) {
        if (property.getName() == null || property.getName().trim().length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        if (property.getTitleId() == null) {
            throw new IllegalArgumentException("titleId cannot be null");
        }
        Session session = this.getSession();
        try {
            TitleProperty propertyInDB = this.retrieve(session, property.getName(), property.getTitleId(), property.getAssetListId(), property.getContextId());
            if (propertyInDB != null) {
                propertyInDB.setValue(property.getValue());
                this.save(session, propertyInDB);
                TitleProperty titleProperty = propertyInDB;
                return titleProperty;
            }
            property.setId(null);
            this.save(session, property);
            TitleProperty titleProperty = property;
            return titleProperty;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void save(Session session, TitleProperty property) {
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)property);
            tx.commit();
            logger.debug((Object)("Saved TitleProperty " + property));
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.warn((Object)"Transaction rollback failed", (Throwable)he);
                }
            }
            throw new RuntimeException("Failed to save " + property, e);
        }
    }

    private Session getSession() {
        return HibernateContext.getContext().openSession();
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }
}

