/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.callback;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.job.execution.WorkOrderCreationConstants;
import com.tandbergtv.watchpoint.pmm.job.execution.WorkOrderCreator;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallbackHelper {
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    public static void createWorkOrder(String templateName, String priority, List<JobParameter> parameters) {
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        for (int i = 0; i < parameters.size(); ++i) {
            JobParameter jp = parameters.get(i);
            templateParameters.put(jp.getName(), jp.getValue());
        }
        HashMap<String, Object> workOrderCreationInfo = new HashMap<String, Object>();
        workOrderCreationInfo.put(WorkOrderCreationConstants.TEMPLATE_NAME, templateName);
        workOrderCreationInfo.put(WorkOrderCreationConstants.TEMPLATE_PARAMTERS, templateParameters);
        workOrderCreationInfo.put(WorkOrderCreationConstants.WORK_ORDER_PRIORITY, priority);
        WorkOrderCreator jobExecutor = new WorkOrderCreator();
        jobExecutor.execute(workOrderCreationInfo);
    }

    public static IContainer getContainer(Map<String, Object> callbackInfo) {
        Long contextId = (Long)callbackInfo.get(JobScheduleInfoConstants.CONTEXTID);
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        return (IContainer)containerCache.get((Serializable)contextId);
    }

    public static Map<String, Object> clone(Map<String, Object> callbackInfo) {
        HashMap<String, Object> clonedMap = new HashMap<String, Object>(callbackInfo);
        ArrayList<JobParameter> jobParamList = new ArrayList<JobParameter>();
        List callbackJobParams = (List)callbackInfo.get(JobScheduleInfoConstants.JOB_PARAMETERS);
        for (JobParameter parameter : callbackJobParams) {
            JobParameter p = new JobParameter();
            p.setId(parameter.getId());
            p.setJob(parameter.getJob());
            p.setName(parameter.getName());
            p.setValue(parameter.getValue());
            jobParamList.add(p);
        }
        clonedMap.put(JobScheduleInfoConstants.JOB_PARAMETERS, jobParamList);
        return clonedMap;
    }
}

