/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.callback;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.handler.TitleAssociatedHandler;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TitleCallback
implements IJobCallback,
Job {
    private Logger logger = Logger.getLogger(TitleCallback.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TitleAssociatedHandler titleHandler = new TitleAssociatedHandler();
        JobDataMap callbackInfo = context.getJobDetail().getJobDataMap();
        try {
            titleHandler.executeJob((Map<String, Object>)callbackInfo, new Date());
        }
        catch (RuntimeException e) {
            IContainer container = CallbackHelper.getContainer((Map<String, Object>)callbackInfo);
            String errorMsg = "Job execution failed for: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]";
            this.logger.error((Object)errorMsg, (Throwable)e);
            throw new JobExecutionException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public void executeJob(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        this.logger.debug((Object)("Executing job that was missed at: " + jobExecutionDate.toString()));
        TitleAssociatedHandler titleHandler = new TitleAssociatedHandler();
        try {
            titleHandler.executeJob(callbackInfo, jobExecutionDate);
        }
        catch (RuntimeException e) {
            IContainer container = CallbackHelper.getContainer(callbackInfo);
            String errorMsg = "Job execution failed for missed job: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]";
            this.logger.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }
}

