/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.handler;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.handler.IJobHandler;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.JobData;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluatorChain;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractTitleAssociatedHandler
implements IJobHandler {
    private Logger logger = Logger.getLogger(this.getClass());
    private static String NDAYS_FROM_METADATA = "NDaysFromMetadata";
    private static String BEFORE = "before";
    private static String AFTER = "after";
    private static int INVALID_INDEX = -1;
    private static int NUMBER_DAYS_INDEX = 0;
    private static int TIMEFRAME_INDEX = 1;

    @Override
    public void executeJob(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        String ruleName = (String)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
        List ruleParameters = (List)callbackInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
        int index = this.getParameterReferenceFieldIndex(ruleName);
        if (index != INVALID_INDEX) {
            RuleParameter parameterReference = (RuleParameter)ruleParameters.get(index);
            ReferenceEvaluatorChain evaluatorChain = ReferenceEvaluatorChain.getInstance();
            JobData jobData = new JobData(jobExecutionDate);
            evaluatorChain.evaluate(jobData, callbackInfo);
            ParameterReferencePath path = evaluatorChain.getPath(parameterReference.getValue());
            if (path != null) {
                Collection<?> items = this.search(path, callbackInfo, jobExecutionDate);
                if (items != null) {
                    this.processItems(items, callbackInfo);
                }
            } else {
                IContainer container = CallbackHelper.getContainer(callbackInfo);
                this.logger.warn((Object)("Property: " + parameterReference.getValue() + " in job: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " for " + container.getContainerType() + " : " + container.getContainerName() + " could not be resolved by any evaluator."));
            }
        }
    }

    protected Collection<?> search(ParameterReferencePath path, Map<String, Object> callbackInfo, Date jobExecutionDate) {
        return null;
    }

    protected void processItems(Collection<?> items, Map<String, Object> callbackInfo) {
    }

    protected Date getSearchDate(String ruleTypeName, List<RuleParameter> ruleParameters, Date jobExecutionDate) {
        if (ruleTypeName.equalsIgnoreCase(NDAYS_FROM_METADATA)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(jobExecutionDate);
            int numberOfDays = Integer.parseInt(ruleParameters.get(NUMBER_DAYS_INDEX).getValue());
            String timeframe = ruleParameters.get(TIMEFRAME_INDEX).getValue();
            if (timeframe.equalsIgnoreCase(AFTER)) {
                calendar.add(5, -numberOfDays);
            } else if (timeframe.equalsIgnoreCase(BEFORE)) {
                calendar.add(5, numberOfDays);
            }
            return calendar.getTime();
        }
        return null;
    }

    private int getParameterReferenceFieldIndex(String ruleName) {
        IJobManager jobMgr = JobManager.getInstance();
        RuleType ruleType = jobMgr.getRuleType(ruleName);
        List ruleTypeParams = ruleType.getParams();
        for (RuleTypeParameter ruleTypeParam : ruleTypeParams) {
            if (ruleTypeParam.getType() != RuleParameterDataType.PARAMETERREF) continue;
            int order = ruleTypeParam.getOrder();
            return order > 0 ? order - 1 : order;
        }
        return INVALID_INDEX;
    }
}

