/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.handler;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.handler.AbstractTitleAssociatedHandler;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.watchpoint.pmm.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TitleAssociatedHandler
extends AbstractTitleAssociatedHandler {
    private static String DATE_FORMAT = "yyyy-MM-dd";
    private Logger logger = Logger.getLogger(TitleAssociatedHandler.class);

    private SearchCriteria buildSearchCriteria(ParameterReferencePath path, Map<String, Object> searchInfo, Date jobExecutionDate) {
        try {
            String ruleName = (String)searchInfo.get(JobScheduleInfoConstants.JOB_RULE_NAME);
            List ruleParameters = (List)searchInfo.get(JobScheduleInfoConstants.JOB_RULE_PARAMETERS);
            Date searchDate = this.getSearchDate(ruleName, ruleParameters, jobExecutionDate);
            SearchCriteria criteria = new SearchCriteria();
            Entity title = new Entity("title", Title.class, "t");
            title.addParameter((SearchParameterBase)new ValueParameter("name", SearchType.STRING, (Object)path.getName()));
            title.addParameter((SearchParameterBase)new ValueParameter("isActive", SearchType.NUMERIC, (Object)1));
            criteria.addParameter((SearchParameterBase)title);
            Entity metadata = new Entity("metadata", TitleSearchKey.METADATA.toString(), "m");
            metadata.addParameter((SearchParameterBase)new ValueParameter("name", SearchType.STRING, (Object)path.getPropertyField()));
            metadata.addParameter((SearchParameterBase)new ValueParameter("value", SearchType.STRING, false, (Object)this.formatSearchDate(searchDate), SearchOperator.LIKE));
            title.addParameter((SearchParameterBase)metadata);
            return criteria;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("Error while building search criteria for job: " + searchInfo.get(JobScheduleInfoConstants.JOB_NAME)), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Collection<?> search(ParameterReferencePath path, Map<String, Object> searchInfo, Date jobExecutionDate) {
        SearchCriteria criteria = this.buildSearchCriteria(path, searchInfo, jobExecutionDate);
        if (criteria != null) {
            try {
                ITitleSearchService searchService = (ITitleSearchService)ServiceRegistry.getDefault().lookup(ITitleSearchService.class);
                Collection titles = searchService.search(criteria);
                this.logger.debug((Object)("Search resulted in " + titles.size() + " titles."));
                return titles;
            }
            catch (RuntimeException e) {
                IContainer container = CallbackHelper.getContainer(searchInfo);
                String errorMsg = "Job execution failed for job: " + searchInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]" + " Error while searching for titles.";
                this.logger.error((Object)errorMsg, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    protected void processItems(Collection<?> items, Map<String, Object> callbackInfo) {
    }

    private String formatSearchDate(Date searchDate) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        df.setLenient(false);
        return df.format(searchDate);
    }
}

