/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.referenceEvaluator;

import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScheduleReferenceEvaluator
extends ReferenceEvaluator {
    private Logger logger = Logger.getLogger(ScheduleReferenceEvaluator.class);
    private static String SCHEDULE_PARAMETER_REFERENCE_GROUP = "Schedule";
    private static String PLANNER_PARAMETER_REFERENCE_GROUP = "Planner";
    private static String SCHEDULE_ID = "Id";
    private static String SCHEDULE_PITCHDATE = "Date";
    private static String PLANNER_DATE = "Date";
    private static String SCHEDULE_PITCHDATE_FIELD = "pitchDate";
    private static String PLANNER_DATE_FIELD = "plannerDate";
    private static String SCHEDULE_DATE_FORMAT = "yyyy-MM-dd";

    @Override
    public void evaluate(Object entity, Map<String, Object> info) {
        this.logger.debug((Object)"Evaluating Schedule parameter references");
        if (entity != null && (entity.getClass().equals(DistributionSchedule.class) || entity.getClass().equals(Planner.class))) {
            Schedule schedule = (Schedule)entity;
            List paramters = (List)info.get(JobScheduleInfoConstants.JOB_PARAMETERS);
            for (JobParameter parameter : paramters) {
                try {
                    String parameterReference = parameter.getValue();
                    if (!ParameterReferenceHelper.isParameterReference(parameterReference)) continue;
                    String groupName = ParameterReferenceHelper.getGroupName(parameterReference);
                    String propertyName = ParameterReferenceHelper.getPropertyName(parameterReference);
                    if (groupName.startsWith(SCHEDULE_PARAMETER_REFERENCE_GROUP)) {
                        if (schedule.getClass() == DistributionSchedule.class) {
                            this.substituteScheduleValues((DistributionSchedule)schedule, parameter, propertyName);
                            continue;
                        }
                        this.logger.warn((Object)("Property: " + parameterReference + " can be evaluated only for (Pitch) Schedules, not for Planners."));
                        continue;
                    }
                    if (!groupName.startsWith(PLANNER_PARAMETER_REFERENCE_GROUP)) continue;
                    if (schedule.getClass() == Planner.class) {
                        this.substitutePlannerValues((Planner)schedule, parameter, propertyName);
                        continue;
                    }
                    this.logger.warn((Object)("Property: " + parameterReference + " can be evaluated only for Planners, not for (Pitch) Schedules."));
                }
                catch (RuntimeException e) {
                    IContainer container = CallbackHelper.getContainer(info);
                    String errorMsg = "Job execution failed for job: " + info.get(JobScheduleInfoConstants.JOB_NAME) + " [" + container.getContainerType() + ":" + container.getContainerName() + "]" + " Error while trying to evaluate schedule reference";
                    this.logger.warn((Object)errorMsg, (Throwable)e);
                }
            }
        }
        if (this.successor != null) {
            this.successor.evaluate(entity, info);
        }
    }

    private void substituteScheduleValues(DistributionSchedule schedule, JobParameter parameter, String propertyName) {
        if (propertyName.equalsIgnoreCase(SCHEDULE_ID)) {
            parameter.setValue(Long.valueOf(schedule.getId()).toString());
        } else if (propertyName.equalsIgnoreCase(SCHEDULE_PITCHDATE)) {
            String pitchDate = this.formatDate(schedule.getDate(), SCHEDULE_DATE_FORMAT);
            parameter.setValue(pitchDate);
        } else {
            throw new RuntimeException("Property:" + propertyName + " not avaiable for substitution.");
        }
    }

    private void substitutePlannerValues(Planner planner, JobParameter parameter, String propertyName) {
        if (propertyName.equalsIgnoreCase(SCHEDULE_ID)) {
            parameter.setValue(Long.valueOf(planner.getId()).toString());
        } else if (propertyName.equalsIgnoreCase(PLANNER_DATE)) {
            String plannerDate = this.formatDate(planner.getDate(), SCHEDULE_DATE_FORMAT);
            parameter.setValue(plannerDate);
        } else {
            throw new RuntimeException("Property:" + propertyName + " not avaiable for substitution.");
        }
    }

    @Override
    public ParameterReferencePath getPath(String property) {
        try {
            if (ParameterReferenceHelper.isParameterReference(property)) {
                String groupName = ParameterReferenceHelper.getGroupName(property);
                String propertyName = ParameterReferenceHelper.getPropertyName(property);
                ParameterReferencePath path = new ParameterReferencePath();
                path.setParameterReference(property);
                path.setMetadata(false);
                path.setName("");
                if (groupName.startsWith(SCHEDULE_PARAMETER_REFERENCE_GROUP)) {
                    if (propertyName.equalsIgnoreCase(SCHEDULE_PITCHDATE)) {
                        path.setPropertyName(SCHEDULE_PITCHDATE_FIELD);
                    }
                    return path;
                }
                if (groupName.startsWith(PLANNER_PARAMETER_REFERENCE_GROUP)) {
                    if (propertyName.equalsIgnoreCase(PLANNER_DATE)) {
                        path.setPropertyName(PLANNER_DATE_FIELD);
                    }
                    return path;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting path for property: " + property, e);
        }
        if (this.successor != null) {
            return this.successor.getPath(property);
        }
        return null;
    }

    private String formatDate(Date dateToFormat, String toFormat) {
        if (dateToFormat == null) {
            throw new RuntimeException("Date is null.");
        }
        SimpleDateFormat from = new SimpleDateFormat();
        Calendar c = Calendar.getInstance();
        c.setTime(dateToFormat);
        from.setCalendar(c);
        SimpleDateFormat to = new SimpleDateFormat(toFormat);
        return to.format(dateToFormat);
    }
}

