/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.scheduling;

import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.job.scheduling.IJobScheduleManager;
import com.tandbergtv.watchpoint.pmm.job.scheduling.MissedTriggerListener;
import com.tandbergtv.watchpoint.pmm.job.timers.ITimeRepresentation;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerResult;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzScheduleManager
implements IJobScheduleManager {
    private static IJobScheduleManager instance;
    private Scheduler scheduler;
    private static String SERVICE_NAME;
    public static String JOB_GROUP_NAME;
    private static String TRIGGER_PREFIX;
    private static String TRIGGER_JOBID_DELIMETER;
    private static int THREAD_FACTORY_THREAD_COUNT;
    private static String JOB_PROPERTIES_FILENAME;
    private static final Logger logger;

    public static synchronized IJobScheduleManager getInstance() {
        if (instance == null) {
            instance = new QuartzScheduleManager();
        }
        return instance;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public synchronized void addSchedule(Job job) {
        String jobName = Long.toString(job.getId());
        Date jobEndDate = job.getRule().getEndDate();
        try {
            SimpleTrigger trigger;
            Class<?> callbackClass = Class.forName(job.getRule().getCallbackClass());
            JobDetail jobDetail = new JobDetail(jobName, JOB_GROUP_NAME, callbackClass);
            jobDetail.setDurability(true);
            jobDetail.setRequestsRecovery(true);
            jobDetail.setVolatility(true);
            jobDetail.setJobDataMap(this.buildJobDataMap(job));
            String triggerName = TRIGGER_PREFIX + TRIGGER_JOBID_DELIMETER + job.getId();
            Class<?> timerClass = Class.forName(job.getRule().getTimeClass());
            ITimeRepresentation timer = (ITimeRepresentation)timerClass.newInstance();
            TimerResult result = (TimerResult)timer.getTime(job.getRule().getType().getParams(), job.getRule().getParams(), job.getRule().getStartDate());
            if (result == null) {
                String errorMsg = "Error while getting time from timer class. Result is null.";
                throw new RuntimeException(errorMsg);
            }
            if (result.getIsPeriodic()) {
                logger.info((Object)("Setting a periodic job starting at: " + result.getStartDate() + " every " + result.getRepeatInterval() + " msec."));
                trigger = new SimpleTrigger(triggerName, JOB_GROUP_NAME, jobName, JOB_GROUP_NAME, result.getStartDate(), jobEndDate, SimpleTrigger.REPEAT_INDEFINITELY, result.getRepeatInterval());
            } else {
                logger.info((Object)("Setting a one time job for date: " + result.getStartDate()));
                trigger = new SimpleTrigger(triggerName, JOB_GROUP_NAME, result.getStartDate());
                trigger.setJobName(jobName);
                trigger.setJobGroup(JOB_GROUP_NAME);
            }
            trigger.setMisfireInstruction(4);
            trigger.setVolatility(true);
            trigger.addTriggerListener(MissedTriggerListener.NAME);
            this.scheduler.addJob(jobDetail, true);
            this.scheduler.scheduleJob((Trigger)trigger);
            logger.info((Object)("Done scheduling job: " + jobDetail.getName()));
        }
        catch (SchedulerException se) {
            String errorMsg = "Error while scheduling job: " + se.toString();
            throw new RuntimeException(errorMsg, se);
        }
        catch (InstantiationException e1) {
            String errorMsg = "Error while instantiating timer class: " + e1.toString();
            throw new RuntimeException(errorMsg, e1);
        }
        catch (IllegalAccessException e2) {
            String errorMsg = "Error while accessing timer class: " + e2.toString();
            throw new RuntimeException(errorMsg, e2);
        }
        catch (ClassNotFoundException e3) {
            String errorMsg = "Error while loading timer class: " + e3.toString();
            throw new RuntimeException(errorMsg, e3);
        }
        catch (IllegalArgumentException e4) {
            String errorMsg = "Error while passing arguments for job/trigger: " + e4.toString();
            throw new RuntimeException(errorMsg, e4);
        }
    }

    @Override
    public synchronized void deleteSchedules(Job job) {
        try {
            String jobName = Long.toString(job.getId());
            if (this.scheduler.getJobDetail(jobName, JOB_GROUP_NAME) == null) {
                String errorMsg = "Scheduler did not find job: " + jobName + " hence cannot delete it.";
                throw new RuntimeException(errorMsg);
            }
            this.scheduler.deleteJob(jobName, JOB_GROUP_NAME);
        }
        catch (SchedulerException e) {
            String errorMsg = "Error while deleting job: " + job.getId() + ":" + e.toString();
            throw new RuntimeException(errorMsg, e);
        }
    }

    @Override
    public synchronized void updateSchedule(Job job) {
        String jobName = Long.toString(job.getId());
        JobDetail detail = null;
        Trigger trigger = null;
        try {
            detail = this.scheduler.getJobDetail(jobName, JOB_GROUP_NAME);
            Trigger[] triggers = this.scheduler.getTriggersOfJob(jobName, JOB_GROUP_NAME);
            Trigger trigger2 = trigger = triggers != null && triggers.length == 1 ? triggers[0] : null;
            if (detail == null) {
                String errorMsg = "Job: " + jobName + " does not exist.";
                throw new RuntimeException(errorMsg);
            }
            this.deleteSchedules(job);
            this.addSchedule(job);
        }
        catch (Exception e) {
            try {
                if (this.scheduler.getJobDetail(jobName, JOB_GROUP_NAME) == null) {
                    this.scheduler.addJob(detail, true);
                    if (trigger != null) {
                        this.scheduler.scheduleJob(trigger);
                    }
                }
                String errorMsg = "Error while updating job schedule: " + e.toString();
                throw new RuntimeException(errorMsg, e);
            }
            catch (SchedulerException e1) {
                String errorMsg = "Error while updating job schedule: " + e.toString();
                throw new RuntimeException(errorMsg, e);
            }
        }
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        try {
            StdSchedulerFactory sf = new StdSchedulerFactory(JOB_PROPERTIES_FILENAME);
            this.scheduler = sf.getScheduler();
            if (this.scheduler == null) {
                String errorMsg = "Could not get scheduler from quartz scheduler factory.";
                throw new RuntimeException(errorMsg);
            }
            logger.debug((Object)"Will start the scheduler");
            Callable<Scheduler> starterThread = new Callable<Scheduler>(){

                @Override
                public Scheduler call() throws Exception {
                    if (QuartzScheduleManager.this.scheduler.getTriggerListener(MissedTriggerListener.NAME) == null) {
                        MissedTriggerListener triggerListener = new MissedTriggerListener();
                        QuartzScheduleManager.this.scheduler.addTriggerListener((TriggerListener)triggerListener);
                    }
                    QuartzScheduleManager.this.scheduler.start();
                    logger.debug((Object)"There you go. Started the Quartz standard scheduler.");
                    return QuartzScheduleManager.this.scheduler;
                }
            };
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(THREAD_FACTORY_THREAD_COUNT);
            executor.schedule(starterThread, 0L, TimeUnit.MILLISECONDS);
        }
        catch (SchedulerException e) {
            String errorMsg = "Error while getting/starting scheduler: " + e.toString();
            throw new RuntimeException(errorMsg, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public void stop() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            String errorMsg = "Error while stopping scheduler: " + e.toString();
            throw new RuntimeException(errorMsg, e);
        }
    }

    public String[] getAllScheduledJobNames() {
        try {
            return this.scheduler.getJobNames(JOB_GROUP_NAME);
        }
        catch (SchedulerException e) {
            logger.error((Object)("Error while getting scheduled job names: " + e.toString()), (Throwable)e);
            return null;
        }
    }

    public int getExecutedJobCount() {
        try {
            return this.scheduler.getMetaData().numJobsExecuted();
        }
        catch (SchedulerException e) {
            logger.error((Object)("Error while getting executed job count: " + e.toString()), (Throwable)e);
            return 0;
        }
    }

    private JobDataMap buildJobDataMap(Job job) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(JobScheduleInfoConstants.JOB_NAME, job.getName());
        jobDataMap.put(JobScheduleInfoConstants.CONTEXTID, job.getContext().getId());
        List<JobParameter> jobParams = this.cloneJobParams(job.getJobParams());
        jobDataMap.put((Object)JobScheduleInfoConstants.JOB_PARAMETERS, jobParams);
        jobDataMap.put(JobScheduleInfoConstants.JOB_PRIORITY, job.getPriority().toString());
        jobDataMap.put(JobScheduleInfoConstants.JOB_SELECTED_TEMPLATE_NAME, job.getTemplateName());
        jobDataMap.put(JobScheduleInfoConstants.JOB_RULE_NAME, job.getRule().getType().getName());
        List<RuleParameter> ruleParams = this.cloneRuleParams(job.getRule().getParams());
        jobDataMap.put((Object)JobScheduleInfoConstants.JOB_RULE_PARAMETERS, ruleParams);
        return jobDataMap;
    }

    private List<RuleParameter> cloneRuleParams(List<RuleParameter> params) {
        ArrayList<RuleParameter> clonedParams = new ArrayList<RuleParameter>();
        for (RuleParameter p : params) {
            RuleParameter param = new RuleParameter();
            param.setId(p.getId());
            param.setOrder(p.getOrder());
            param.setValue(p.getValue());
            clonedParams.add(param);
        }
        return clonedParams;
    }

    private List<JobParameter> cloneJobParams(List<JobParameter> jobParams) {
        ArrayList<JobParameter> clonedParams = new ArrayList<JobParameter>();
        for (JobParameter p : jobParams) {
            JobParameter param = new JobParameter();
            param.setId(p.getId());
            param.setName(p.getName());
            param.setValue(p.getValue());
            clonedParams.add(param);
        }
        return clonedParams;
    }

    static {
        SERVICE_NAME = "Job Scheduling service";
        JOB_GROUP_NAME = "Workflow PMM Jobs";
        TRIGGER_PREFIX = "TRIGGER";
        TRIGGER_JOBID_DELIMETER = "_";
        THREAD_FACTORY_THREAD_COUNT = 1;
        JOB_PROPERTIES_FILENAME = "com/tandbergtv/watchpoint/pmm/job/scheduling/job.quartz.properties";
        logger = Logger.getLogger(QuartzScheduleManager.class);
    }
}

