/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.util;

import com.tandbergtv.watchpoint.pmm.entities.EntityType;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.conf.ParameterReferenceFileParser;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import java.util.List;
import org.apache.log4j.Logger;

public class RuleCallbackClassFinder {
    private static String DEFAULT_CALLBACK_CLASS = "com.tandbergtv.watchpoint.pmm.job.callback.DefaultCallback";
    private static final Logger logger = Logger.getLogger(RuleCallbackClassFinder.class);

    public String getCallbackClass(boolean isAssociatedWithTitles, EntityType type, List<RuleParameter> ruleParams, List<RuleTypeParameter> ruleTypeParams) {
        try {
            if (!isAssociatedWithTitles) {
                return DEFAULT_CALLBACK_CLASS;
            }
            int order = this.getParameterRefOrder(ruleTypeParams);
            if (order != -1) {
                RuleParameter ruleParameter = this.getRuleParameter(ruleParams, order);
                String groupName = ParameterReferenceHelper.getGroupName(ruleParameter.getValue());
                String parentGroup = ParameterReferenceHelper.getParentGroup(groupName);
                ParameterReferenceFileParser helper = ParameterReferenceFileParser.getInstance();
                return helper.getCallback(type, parentGroup);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting callback class for type: " + type + e.toString()));
        }
        return new String();
    }

    private int getParameterRefOrder(List<RuleTypeParameter> ruleTypeParams) {
        for (RuleTypeParameter parameter : ruleTypeParams) {
            if (parameter.getType() != RuleParameterDataType.PARAMETERREF) continue;
            return parameter.getOrder();
        }
        return -1;
    }

    private RuleParameter getRuleParameter(List<RuleParameter> ruleParams, int order) {
        for (RuleParameter param : ruleParams) {
            if (param.getOrder() != order) continue;
            return param;
        }
        return null;
    }
}

