/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractNotificationGenerator
implements INotificationGenerator {
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String PMM_CONFIG_DIR = "pmm";
    private static final Logger logger = Logger.getLogger(AbstractNotificationGenerator.class);

    @Override
    public Notification getNotification(Schedule schedule) {
        Notification notification = null;
        for (NotificationSetting setting : this.getSettings()) {
            int delta = setting.offset;
            String status = setting.status;
            Date deadline = this.diff(schedule.getDate(), delta);
            logger.debug((Object)("Deadline " + deadline));
            if (deadline.after(this.getToday())) {
                logger.debug((Object)(schedule + ", is after cutoff date for status " + status));
                continue;
            }
            boolean warn = false;
            HashSet<Title> titles = new HashSet<Title>();
            for (Title title : schedule.getTitles()) {
                if (!this.isTitleDelayed(title, schedule, status)) continue;
                if (notification == null) {
                    notification = new Notification(schedule);
                }
                notification.addTitle(title);
                titles.add(title);
                warn = true;
            }
            if (!warn) continue;
            this.addMessage(notification, status, titles);
        }
        return notification;
    }

    @Deprecated
    protected String constructMessage(String status, Collection<Title> titles) {
        return null;
    }

    protected abstract void addMessage(Notification var1, String var2, Collection<Title> var3);

    protected abstract String getType();

    protected Date getToday() {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected Date diff(Date date, int days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    protected Collection<NotificationSetting> getSettings() {
        ArrayList<NotificationSetting> settings = new ArrayList<NotificationSetting>();
        try {
            Document document = this.getConfiguration();
            XPath xpath = XPathFactory.newInstance().newXPath();
            String path = "//schedule[@type='" + this.getType() + "']/status";
            logger.debug((Object)("Path " + path));
            NodeList nodes = (NodeList)xpath.evaluate(path, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String status = (String)xpath.evaluate("name", node, XPathConstants.STRING);
                String s = (String)xpath.evaluate("offset", node, XPathConstants.STRING);
                Integer offset = Integer.parseInt(s);
                logger.debug((Object)("Progress name " + status + " offset " + offset));
                settings.add(new NotificationSetting(status, offset));
            }
        }
        catch (Exception e) {
            throw new ScheduleRuntimeException("Unable to read progress item name", (Throwable)e);
        }
        return settings;
    }

    protected String getTitleMetadataName(String name) {
        String variable = null;
        String path = "//specification[@name='" + name + "']/variable";
        try {
            Document document = this.getConfiguration();
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xpath.evaluate(path, document, XPathConstants.NODE);
            if (node != null) {
                variable = node.getTextContent();
                logger.debug((Object)("Variable " + variable));
            }
        }
        catch (Exception e) {
            throw new ScheduleRuntimeException("Unable to read metadata field name", (Throwable)e);
        }
        return variable;
    }

    protected Document getConfiguration() throws Exception {
        String dir = System.getProperty(PRODUCT_DIR) + File.separator + "conf";
        String path = dir + File.separator + PMM_CONFIG_DIR + File.separator + "progress.xml";
        File file = new File(path);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        return document;
    }

    protected abstract boolean isTitleDelayed(Title var1, Schedule var2, String var3);
}

