/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.title.DefaultTitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.TitleService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.specs.RightsManagerFactory;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.DefaultTitleSearchStrategy;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.TitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.TitleProviderFactory;
import com.tandbergtv.watchpoint.pmm.title.provider.internal.TitleProviderRegistry;
import com.tandbergtv.watchpoint.pmm.title.search.ITitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchService;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.template.TitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.validation.ITitleValidationService;
import com.tandbergtv.watchpoint.pmm.title.validation.TitleValidationService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginRegistry;
import org.springframework.context.ApplicationContext;

public class TitleActivator {
    private PluginManager pluginManager;
    private ApplicationContext context;
    private static final String PROVIDER_NAME = "Default";
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final Logger logger = Logger.getLogger(TitleActivator.class);

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public void start() {
        HibernateContext.getContext().initializeContext();
        this.addService((Service)new DefaultTitlePersistenceService());
        this.addService((Service)new TitleSearchService());
        this.addService(new TitleProviderRegistry());
        this.addService((Service)SpecificationManager.newInstance());
        this.addService(new TitleValidationService());
        this.addService((Service)TitleService.getInstance());
        this.addService(new TitleTemplateProvider());
        this.addDefaultTitleProvider();
        this.addMetadataFormatSpecifications();
        this.addTitleProviders();
        this.loadRightsManager();
        logger.debug((Object)"Title services started");
    }

    private void loadRightsManager() {
        PluginRegistry registry = this.pluginManager.getRegistry();
        ExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, "rightsManager");
        RightsManagerFactory.createRightsManager(this.pluginManager, point);
    }

    public void stop() {
        this.removeTitleProviders();
        this.removeService(ITitleTemplateProvider.class);
        this.removeService(ITitleService.class);
        this.removeService(ITitleValidationService.class);
        this.removeService(ISpecificationManager.class);
        this.removeService(ITitleProviderRegistry.class);
        this.removeService(ITitleSearchService.class);
        this.removeService(ITitlePersistenceService.class);
        HibernateContext.getContext().closeContext();
        logger.debug((Object)"Title services stopped");
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void addTitleProviders() {
        ITitleProviderRegistry registry = (ITitleProviderRegistry)ServiceRegistry.getDefault().lookup(ITitleProviderRegistry.class);
        for (ITitleProvider provider : this.loadTitleProviders()) {
            registry.addProvider(provider);
        }
    }

    private void addDefaultTitleProvider() {
        ITitleProviderRegistry registry = (ITitleProviderRegistry)ServiceRegistry.getDefault().lookup(ITitleProviderRegistry.class);
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        HashSet<String> names = new HashSet<String>();
        DefaultTitleSearchStrategy strategy = new DefaultTitleSearchStrategy();
        for (Specification spec : sm.getAllSpecifications()) {
            names.add(spec.getName());
        }
        TitleProvider provider = new TitleProvider(TitleSearchKey.DEFAULT_SYSTEM_ID.toString(), PROVIDER_NAME, strategy, names);
        strategy.setTitleProvider(provider);
        registry.addProvider(provider);
    }

    private void removeTitleProviders() {
    }

    private Collection<ITitleProvider> loadTitleProviders() {
        HashSet<ITitleProvider> providers = new HashSet<ITitleProvider>();
        PluginRegistry registry = this.pluginManager.getRegistry();
        ExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, "titleprovider");
        TitleProviderFactory factory = TitleProviderFactory.newInstance();
        for (Extension extension : point.getAvailableExtensions()) {
            try {
                ITitleProvider provider = factory.createProvider(this.pluginManager, extension);
                providers.add(provider);
            }
            catch (Exception e) {
                String id = extension.getDeclaringPluginDescriptor().getId();
                id = id + ":" + extension.getId();
                logger.error((Object)("Failed to load Title Provider for extension[" + id + "], error: " + e.getMessage()), (Throwable)e);
            }
        }
        return providers;
    }

    private void addMetadataFormatSpecifications() {
        new com.tandbergtv.metadatamanager.conf.SpecificationBuilder(this.pluginManager, this.context).buildSpecifications();
        ISpecificationManager sm = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        SpecificationBuilder builder = SpecificationBuilder.createInstance(this.pluginManager, SpecHandlerFactory.getHandlers());
        for (Specification specification : builder.buildSpecifications()) {
            sm.addSpecification(specification);
        }
    }
}

