/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationValidationException;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ComplexVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ParamListType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ParamType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

class SpecificationReader {
    SpecificationReader() {
    }

    public com.tandbergtv.watchpoint.pmm.title.conf.Specification unmarshal(String filePath) throws SpecificationValidationException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(SpecificationReader.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Specification jaxbSpec = (Specification)unmarshaller.unmarshal(new File(filePath));
            return this.convertToSpecification(jaxbSpec);
        }
        catch (JAXBException e) {
            throw new SpecificationValidationException((Throwable)e);
        }
    }

    public com.tandbergtv.watchpoint.pmm.title.conf.Specification unmarshal(InputStream stream) throws SpecificationValidationException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(SpecificationReader.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Specification jaxbSpec = (Specification)unmarshaller.unmarshal(stream);
            return this.convertToSpecification(jaxbSpec);
        }
        catch (JAXBException e) {
            throw new SpecificationValidationException((Throwable)e);
        }
    }

    private com.tandbergtv.watchpoint.pmm.title.conf.Specification convertToSpecification(Specification jaxbSpec) throws SpecificationValidationException {
        List<TitleType> titleList;
        List<ParamType> jpmOptionsList;
        ParamListType jpmOptionsListType;
        List<ParamType> jrmOptionsList;
        com.tandbergtv.watchpoint.pmm.title.conf.Specification s = new com.tandbergtv.watchpoint.pmm.title.conf.Specification();
        s.setName(jaxbSpec.getName());
        s.setConverterClass(jaxbSpec.getConverterClass());
        ParamListType jrmOptionsListType = jaxbSpec.getJobRuleMenuOptions();
        if (jrmOptionsListType != null && (jrmOptionsList = jrmOptionsListType.getParam()) != null) {
            for (ParamType jrmOption : jrmOptionsList) {
                String name = jrmOption.getName();
                String value = jrmOption.getValue();
                if (this.isNullOrEmpty(name) || this.isNullOrEmpty(value)) {
                    throw new SpecificationValidationException("Job Rule Menu Options Name or Value cannot be null, empty or blank");
                }
                s.addJobRuleMenuOption(name, value);
            }
        }
        if ((jpmOptionsListType = jaxbSpec.getJobParameterMenuOptions()) != null && (jpmOptionsList = jpmOptionsListType.getParam()) != null) {
            for (ParamType jpmOption : jpmOptionsList) {
                String name = jpmOption.getName();
                String value = jpmOption.getValue();
                if (this.isNullOrEmpty(name) || this.isNullOrEmpty(value)) {
                    throw new SpecificationValidationException("Job Parameter Menu Options Name or Value cannot be null, empty or blank");
                }
                s.addJobParameterMenuOption(name, value);
            }
        }
        if ((titleList = jaxbSpec.getTitle()) != null) {
            for (TitleType title : titleList) {
                s.addRootTitleConf(this.convertToTitleConf(s, title));
            }
        }
        return s;
    }

    private TitleConf convertToTitleConf(com.tandbergtv.watchpoint.pmm.title.conf.Specification specification, TitleType t) throws SpecificationValidationException {
        List<VariableType> variables;
        TitleConf tc = new TitleConf(specification);
        tc.setName(this.trim(t.getName()));
        tc.setAlias(t.getAlias());
        tc.setHasAsset(t.isHasAsset());
        tc.setMin(t.getMin());
        tc.setMax(t.getMax());
        TitleType.Metadata m = t.getMetadata();
        if (m != null && (variables = m.getVariable()) != null) {
            for (VariableType var : variables) {
                Variable variable = this.convertToVariable(tc, var);
                if (variable == null) continue;
                tc.addMetadata(variable);
            }
        }
        if (t.getChildTitles() != null && t.getChildTitles().getTitle() != null) {
            for (TitleType childTitle : t.getChildTitles().getTitle()) {
                TitleConf child = this.convertToTitleConf(specification, childTitle);
                tc.addChild(child);
            }
        }
        return tc;
    }

    private Variable convertToVariable(TitleConf tc, VariableType vt) throws SpecificationValidationException {
        SimpleVariable v = null;
        if (SimpleVariableType.class.equals(vt.getClass())) {
            v = this.convertToSimpleVariable(tc, (SimpleVariableType)SimpleVariableType.class.cast(vt));
        } else if (ComplexVariableType.class.equals(vt.getClass())) {
            v = this.convertToComplexVariable(tc, (ComplexVariableType)ComplexVariableType.class.cast(vt));
        } else {
            String msg = "Failed to convert variable type of class: " + vt.getClass();
            throw new SpecificationValidationException(msg);
        }
        return v;
    }

    private SimpleVariable convertToSimpleVariable(TitleConf tc, SimpleVariableType vt) throws SpecificationValidationException {
        SimpleVariable v = new SimpleVariable(tc);
        this.buildVariable(vt, (Variable)v);
        v.setDataType(vt.getDatatype());
        v.setRequired(vt.isRequired());
        v.setFilePath(vt.isFilePath());
        v.setKey(vt.isKey());
        v.setSearchField(vt.isSearchField());
        v.setExternalSearchField(vt.isExternalSearchField());
        v.setAttribute(vt.isAttribute());
        SimpleVariableType.SearchInfo si = vt.getSearchInfo();
        if (si != null) {
            v.setSearchFieldDataProvider(this.trim(si.getDataProvider()));
            List<ParamType> constantsList = si.getConstant();
            if (constantsList != null) {
                for (ParamType constant : constantsList) {
                    String name = constant.getName();
                    String value = constant.getValue();
                    if (this.isNullOrEmpty(name) || this.isNullOrEmpty(value)) {
                        throw new SpecificationValidationException("Search Field Constant Name or Value cannot be null, blank or empty");
                    }
                    v.addSearchFieldValue(this.trim(name), this.trim(value));
                }
            }
        }
        return v;
    }

    private ComplexVariable convertToComplexVariable(TitleConf tc, ComplexVariableType vt) throws SpecificationValidationException {
        ComplexVariable v = new ComplexVariable(tc);
        this.buildVariable(vt, (Variable)v);
        v.setShowCollapsed(vt.isShowCollapsed());
        List<VariableType> childTypes = vt.getVariable();
        if (childTypes != null) {
            for (VariableType childType : childTypes) {
                Variable child = this.convertToVariable(tc, childType);
                v.addChild(child);
            }
        }
        return v;
    }

    private void buildVariable(VariableType vt, Variable v) {
        v.setName(vt.getName());
        v.setDisplayName(vt.getDisplayName());
        v.setXPath(vt.getXpath());
        v.setMax(vt.getMax());
        v.setMin(vt.getMin());
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private String trim(String s) {
        return s != null ? s.trim() : null;
    }
}

