/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util.unitTests;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.util.ContainerCacheActivator;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import junit.framework.TestCase;

public class ContainerCacheTests
extends TestCase {
    private ContainerCacheActivator activator;

    protected void setUp() throws Exception {
        try {
            HibernateContext.getContext().initializeContext();
            this.activator = new ContainerCacheActivator();
            this.activator.start();
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage());
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        try {
            HibernateContext.getContext().closeContext();
            this.activator.stop();
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage());
        }
        super.tearDown();
    }

    public void testGettingContainer() {
        try {
            ICacheService cc = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");
            long contextId = 1L;
            Thread.sleep(10000L);
            IContainer container = (IContainer)cc.get((Serializable)Long.valueOf(contextId));
            this.printContainer(container);
            Partner p = new Partner();
            p.setId(4L);
            p.setName("some partner");
            p.setType(PartnerType.DISTRIBUTION);
            cc.add((Serializable)Long.valueOf(4L), (Object)p);
            container = (IContainer)cc.get((Serializable)Long.valueOf(4L));
            this.printContainer(container);
            p.setName("Modified name");
            cc.add((Serializable)Long.valueOf(4L), (Object)p);
            this.printContainer(container);
            cc.remove((Serializable)Long.valueOf(4L));
            System.out.println("Current cache contextIds:");
            for (Serializable id : cc.getKeys()) {
                System.out.println(id);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void printContainer(IContainer container) {
        System.out.println("Container Id: " + container.getContainerId());
        System.out.println("Container Name: " + container.getContainerName());
        System.out.println("Container Type: " + container.getContainerType().toString());
    }
}

