/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.message.MessageRejectedEvent;
import com.tandbergtv.workflow.driver.service.IMessageQueueService;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class MessageQueueService
implements IMessageQueueService,
IColleague {
    private Map<Token, BlockingQueue<WorkflowMessage>> queues = new HashMap<Token, BlockingQueue<WorkflowMessage>>();
    private static final Lock lock = new ReentrantLock();
    private static final String SERVICE_NAME = "Message Queue";
    private static final Logger logger = Logger.getLogger(MessageQueueService.class);

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        mediator.register((IColleague)this);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        lock.lock();
        try {
            Iterator<Map.Entry<Token, BlockingQueue<WorkflowMessage>>> i = this.queues.entrySet().iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }
        finally {
            lock.unlock();
        }
        mediator.unregister((IColleague)this);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
    }

    @Override
    public void addMessage(Token token, WorkflowMessage message) {
        IMessageUID uid = message.getMessageUID();
        BlockingQueue<WorkflowMessage> queue = this.getQueue(token);
        if (queue == null) {
            logger.warn((Object)(token + ", message queue unavailable, rejecting " + uid));
            return;
        }
        if (queue.size() > 0) {
            logger.warn((Object)(token + ", queue size is " + queue.size()));
        }
        logger.debug((Object)(token + ", adding message " + uid));
        queue.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockingQueue<WorkflowMessage> getQueue(Token token) {
        BlockingQueue<WorkflowMessage> queue = null;
        lock.lock();
        try {
            queue = this.queues.get(token);
        }
        finally {
            lock.unlock();
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<WorkflowMessage> createQueue(Token token) {
        LinkedBlockingQueue<WorkflowMessage> queue = new LinkedBlockingQueue<WorkflowMessage>();
        lock.lock();
        try {
            this.queues.put(token, queue);
        }
        finally {
            lock.unlock();
        }
        logger.debug((Object)(token + ", created message queue"));
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeQueue(Token t) {
        BlockingQueue<WorkflowMessage> queue = null;
        lock.lock();
        try {
            queue = this.queues.remove(t);
        }
        finally {
            lock.unlock();
        }
        if (queue != null) {
            queue.clear();
            logger.debug((Object)(t + ", removed message queue"));
        }
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        MessageRejectedEvent e;
        boolean removed;
        if (event instanceof WorkflowProcessEvent) {
            WorkflowProcessEvent e2 = (WorkflowProcessEvent)event;
            Token token = e2.getToken();
            switch (e2.getType()) {
                case CREATED: 
                case RESUMED: 
                case JOINED: 
                case CACHE_INITED: {
                    this.createQueue(token);
                    break;
                }
                case BRANCHED: 
                case PAUSED: 
                case FAILED: 
                case CANCELLED: 
                case STOPPED: {
                    this.removeQueue(token);
                    break;
                }
            }
        } else if (event instanceof MessageRejectedEvent && (removed = this.getQueue((e = (MessageRejectedEvent)event).getToken()).remove(e.getMessage()))) {
            logger.warn((Object)(e.getToken() + ", removed message [" + e.getMessage().getMessageUID() + "] from queue"));
        }
    }
}

