/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;

public abstract class Plugin {
    protected final Log log = LogFactory.getLog(this.getClass());
    private PluginManager manager;
    private PluginDescriptor descriptor;
    private boolean started;

    public final PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    final void setDescriptor(PluginDescriptor pluginDescriptor) {
        this.descriptor = pluginDescriptor;
    }

    public final PluginManager getManager() {
        return this.manager;
    }

    final void setManager(PluginManager pluginManager) {
        this.manager = pluginManager;
    }

    final void start() throws Exception {
        if (!this.started) {
            this.doStart();
            this.started = true;
        }
    }

    final void stop() throws Exception {
        if (this.started) {
            this.doStop();
            this.started = false;
        }
    }

    public final boolean isActive() {
        return this.started;
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    public String toString() {
        return "{" + this.getClass().getName() + ": manager=" + this.manager + ", descriptor=" + this.descriptor + "}";
    }
}

