/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin;

import java.net.URL;
import java.util.Map;
import org.java.plugin.JpfException;
import org.java.plugin.PathResolver;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginManager {
    public static PluginManager lookup(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Plugin) {
            return ((Plugin)object).getManager();
        }
        ClassLoader classLoader = object instanceof Class ? ((Class)object).getClassLoader() : (object instanceof ClassLoader ? (ClassLoader)object : object.getClass().getClassLoader());
        if (!(classLoader instanceof PluginClassLoader)) {
            return PluginManager.lookup(classLoader.getParent());
        }
        return ((PluginClassLoader)classLoader).getPluginManager();
    }

    public abstract PluginRegistry getRegistry();

    public abstract PathResolver getPathResolver();

    public abstract Map<String, Identity> publishPlugins(PluginLocation[] var1) throws JpfException;

    public abstract Plugin getPlugin(String var1) throws PluginLifecycleException;

    public abstract void activatePlugin(String var1) throws PluginLifecycleException;

    public abstract Plugin getPluginFor(Object var1);

    public abstract boolean isPluginActivated(PluginDescriptor var1);

    public abstract boolean isBadPlugin(PluginDescriptor var1);

    public abstract boolean isPluginActivating(PluginDescriptor var1);

    public abstract PluginClassLoader getPluginClassLoader(PluginDescriptor var1);

    public abstract void shutdown();

    public abstract void deactivatePlugin(String var1);

    public abstract PluginDescriptor[] disablePlugin(PluginDescriptor var1);

    public abstract PluginDescriptor[] enablePlugin(PluginDescriptor var1, boolean var2);

    public abstract boolean isPluginEnabled(PluginDescriptor var1);

    public abstract void registerListener(EventListener var1);

    public abstract void unregisterListener(EventListener var1);

    protected final void initPlugin(Plugin plugin, PluginDescriptor pluginDescriptor) {
        plugin.setManager(this);
        plugin.setDescriptor(pluginDescriptor);
    }

    protected final void startPlugin(Plugin plugin) throws Exception {
        plugin.start();
    }

    protected final void stopPlugin(Plugin plugin) throws Exception {
        plugin.stop();
    }

    protected final void disposeClassLoader(PluginClassLoader pluginClassLoader) {
        pluginClassLoader.dispose();
    }

    protected final void notifyClassLoader(PluginClassLoader pluginClassLoader) {
        pluginClassLoader.pluginsSetChanged();
    }

    public static interface PluginLocation {
        public URL getManifestLocation();

        public URL getContextLocation();
    }

    public static abstract class EventListenerAdapter
    implements EventListener {
        public void pluginActivated(Plugin plugin) {
        }

        public void pluginDeactivated(Plugin plugin) {
        }

        public void pluginDisabled(PluginDescriptor pluginDescriptor) {
        }

        public void pluginEnabled(PluginDescriptor pluginDescriptor) {
        }
    }

    public static interface EventListener {
        public void pluginActivated(Plugin var1);

        public void pluginDeactivated(Plugin var1);

        public void pluginDisabled(PluginDescriptor var1);

        public void pluginEnabled(PluginDescriptor var1);
    }
}

