/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.standard.ShadingUtil;
import org.java.plugin.util.IoUtil;

final class ShadowDataController {
    private static final String META_FILE_NAME = ".meta";
    private final Log log = LogFactory.getLog(ShadowDataController.class);
    private final File shadowFolder;
    private final URL shadowFolderUrl;
    private final Properties metaData;
    private final DateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final FileFilter fileFilter;

    static ShadowDataController init(File file, FileFilter fileFilter) throws IOException {
        ShadowDataController shadowDataController = new ShadowDataController(file, fileFilter);
        shadowDataController.quickCheck();
        shadowDataController.save();
        return shadowDataController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShadowDataController(File file, FileFilter fileFilter) throws IOException {
        this.shadowFolder = file;
        this.fileFilter = fileFilter;
        this.shadowFolderUrl = IoUtil.file2url(file);
        File file2 = new File(this.shadowFolder, META_FILE_NAME);
        this.metaData = new Properties();
        if (file2.isFile()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                try {
                    this.metaData.load(fileInputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("meta-data loaded from file " + file2));
                }
            }
            catch (IOException iOException) {
                this.log.warn((Object)("failed loading meta-data from file " + file2), (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        File file = new File(this.shadowFolder, META_FILE_NAME);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            try {
                this.metaData.store(fileOutputStream, "This is automatically generated file.");
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("meta-data saved to file " + file));
            }
        }
        catch (IOException iOException) {
            this.log.warn((Object)("failed saving meta-data to file " + file), (Throwable)iOException);
        }
    }

    private void quickCheck() {
        File[] fileArray = this.shadowFolder.listFiles(new ShadowFileFilter());
        for (File object : fileArray) {
            if (this.metaData.containsValue(object.getName())) continue;
            if (ShadingUtil.deleteFile(object)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("deleted shadow file " + object));
                continue;
            }
            this.log.warn((Object)("can't delete shadow file " + object));
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry<Object, Object> entry : this.metaData.entrySet()) {
            String string = (String)entry.getKey();
            if (!string.startsWith("uid:")) continue;
            hashSet.add(entry.getValue());
        }
        Iterator<Map.Entry<Object, Object>> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            this.quickCheck((String)((Object)entry));
        }
    }

    private void quickCheck(String string) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("quick check of UID " + string));
        }
        String string2 = this.metaData.getProperty("source:" + string, null);
        String string3 = this.metaData.getProperty("file:" + string, null);
        String string4 = this.metaData.getProperty("modified:" + string, null);
        if (string2 == null || string3 == null || string4 == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("meta-data incomplete, UID=" + string));
            }
            this.remove(string);
            return;
        }
        try {
            if (!this.dtf.parse(string4).equals(ShadingUtil.getLastModified(ShadingUtil.buildURL(this.shadowFolderUrl, string2)))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("source modification detected, UID=" + string + ", source=" + string2));
                }
                this.remove(string);
            }
        }
        catch (IOException iOException) {
            this.log.warn((Object)"quick check failed", (Throwable)iOException);
            this.remove(string);
        }
        catch (ParseException parseException) {
            this.log.warn((Object)"quick check failed", (Throwable)parseException);
            this.remove(string);
        }
    }

    private void remove(String string) {
        String string2 = this.metaData.getProperty("file:" + string, null);
        if (string2 != null) {
            File file = new File(this.shadowFolder, string2);
            if (ShadingUtil.deleteFile(file)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("deleted lost file " + string2));
                }
            } else {
                this.log.warn((Object)("can't delete lost file " + string2));
            }
        }
        boolean bl = this.metaData.remove("uid:" + string) != null;
        bl |= this.metaData.remove("source:" + string) != null;
        bl |= this.metaData.remove("file:" + string) != null;
        if ((bl |= this.metaData.remove("modified:" + string) != null) && this.log.isDebugEnabled()) {
            this.log.debug((Object)("removed meta-data, UID=" + string));
        }
    }

    private URL add(String string, URL uRL, File file, Date date) throws IOException {
        URL uRL2 = IoUtil.file2url(file);
        this.metaData.setProperty("uid:" + string, string);
        String string2 = ShadingUtil.getRelativeUrl(this.shadowFolder, uRL);
        this.metaData.setProperty("source:" + string, string2);
        this.metaData.setProperty("file:" + string, file.getName());
        this.metaData.setProperty("modified:" + string, this.dtf.format(date));
        this.save();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("shading done, UID=" + string + ", source=" + string2 + ", file=" + uRL2 + ", modified=" + this.dtf.format(date)));
        }
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL shadowResource(URL uRL, String string, boolean bl) {
        Serializable serializable;
        block45: {
            URL uRL2;
            block48: {
                try {
                    serializable = this.deepCheck(uRL, string);
                    if (serializable != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("got actual shaded resource, UID=" + string + ", source=" + uRL + ", file=" + serializable));
                        }
                        return serializable;
                    }
                }
                catch (Exception exception) {
                    this.log.warn((Object)("deep check failed, UID=" + string + ", URL=" + uRL), (Throwable)exception);
                    this.remove(string);
                }
                try {
                    serializable = ShadingUtil.getLastModified(uRL);
                }
                catch (IOException iOException) {
                    this.log.error((Object)("shading failed, can't get modification date for " + uRL), (Throwable)iOException);
                    return uRL;
                }
                File file = IoUtil.url2file(uRL);
                if (file != null && file.isDirectory()) {
                    try {
                        File file2 = new File(this.shadowFolder, string);
                        IoUtil.copyFolder(file, file2, true, true, this.fileFilter);
                        return this.add(string, uRL, file2, (Date)serializable);
                    }
                    catch (IOException iOException) {
                        this.log.error((Object)("failed shading local folder " + file), (Throwable)iOException);
                        return uRL;
                    }
                }
                if (!"jar".equalsIgnoreCase(uRL.getProtocol())) break block45;
                String string2 = uRL.toExternalForm();
                int n = string2.indexOf("!/");
                if (n == -1) {
                    n = string2.length();
                }
                URL uRL3 = new URL(string2.substring(4, n));
                if (!bl) {
                    String string3 = ShadingUtil.getExtension(uRL3.getFile());
                    if (string3 == null) {
                        string3 = "jar";
                    }
                    File file3 = new File(this.shadowFolder, string + '.' + string3);
                    File file4 = IoUtil.url2file(uRL3);
                    InputStream inputStream = file4 != null ? new BufferedInputStream(new FileInputStream(file4)) : uRL3.openStream();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file3, false);
                        try {
                            IoUtil.copyStream(inputStream, fileOutputStream, 1024);
                        }
                        finally {
                            ((OutputStream)fileOutputStream).close();
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    return this.add(string, uRL, file3, (Date)serializable);
                }
                URLConnection uRLConnection = null;
                try {
                    ZipFile zipFile;
                    File file5 = IoUtil.url2file(uRL3);
                    if (file5 != null) {
                        zipFile = new ZipFile(file5);
                    } else {
                        uRLConnection = uRL.openConnection();
                        uRLConnection.setUseCaches(false);
                        zipFile = ((JarURLConnection)uRLConnection).getJarFile();
                    }
                    File file6 = new File(this.shadowFolder, string);
                    try {
                        ShadingUtil.unpack(zipFile, file6);
                    }
                    finally {
                        zipFile.close();
                    }
                    uRL2 = this.add(string, uRL, file6, (Date)serializable);
                    if (uRLConnection == null) break block48;
                }
                catch (Throwable throwable) {
                    try {
                        if (uRLConnection != null) {
                            uRLConnection.getInputStream().close();
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        this.log.error((Object)("failed shading URL connection " + uRL), (Throwable)iOException);
                        return uRL;
                    }
                }
                uRLConnection.getInputStream().close();
            }
            return uRL2;
        }
        String string4 = uRL.getFile();
        if (string4 == null) {
            this.log.warn((Object)("can't get file name from resource " + uRL + ", shading failed"));
            return uRL;
        }
        String string5 = ShadingUtil.getExtension(string4);
        if (string5 == null) {
            this.log.warn((Object)("can't get file name extension for resource " + uRL + ", shading failed"));
            return uRL;
        }
        if (bl && ("jar".equalsIgnoreCase(string5) || "zip".equalsIgnoreCase(string5))) {
            try {
                InputStream inputStream = uRL.openStream();
                File file = new File(this.shadowFolder, string);
                try {
                    ShadingUtil.unpack(inputStream, file);
                }
                finally {
                    inputStream.close();
                }
                return this.add(string, uRL, file, (Date)serializable);
            }
            catch (IOException iOException) {
                this.log.error((Object)("failed shading packed resource " + uRL), (Throwable)iOException);
                return uRL;
            }
        }
        try {
            File file = new File(this.shadowFolder, string + '.' + string5);
            InputStream inputStream = uRL.openStream();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file, false);
                try {
                    IoUtil.copyStream(inputStream, fileOutputStream, 1024);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            finally {
                inputStream.close();
            }
            return this.add(string, uRL, file, (Date)serializable);
        }
        catch (IOException iOException) {
            this.log.error((Object)("failed shading resource file " + uRL), (Throwable)iOException);
            return uRL;
        }
    }

    private URL deepCheck(URL uRL, String string) throws Exception {
        URL uRL2;
        String string2 = this.metaData.getProperty("source:" + string, null);
        if (string2 == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("URL not found in meta-data, UID=" + string));
            }
            this.remove(string);
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("URL found in meta-data, UID=" + string + ", source=" + uRL + ", storedURL=" + string2));
        }
        if (!(uRL2 = ShadingUtil.buildURL(this.shadowFolderUrl, string2)).equals(uRL)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("inconsistent URL found in meta-data, UID=" + string + ", source=" + uRL + ", storedSource=" + uRL2));
            }
            this.remove(string);
            return null;
        }
        String string3 = this.metaData.getProperty("modified:" + string, null);
        if (string3 == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("modification info not found in meta-data, UID=" + string));
            }
            this.remove(string);
            return null;
        }
        if (!ShadingUtil.getLastModified(uRL).equals(this.dtf.parse(string3))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("source modification detected, UID=" + string + ", source=" + uRL));
            }
            this.remove(string);
            return null;
        }
        String string4 = this.metaData.getProperty("file:" + string, null);
        if (string4 == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("file info not found in meta-data, UID=" + string));
            }
            this.remove(string);
            return null;
        }
        File file = new File(this.shadowFolder, string4);
        if (!file.exists()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("shadow file not found, UID=" + string + ", source=" + uRL + ", file=" + file));
            }
            this.remove(string);
            return null;
        }
        File file2 = IoUtil.url2file(uRL);
        if (file2 != null && file2.isDirectory()) {
            IoUtil.synchronizeFolders(file2, file, this.fileFilter);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("folders synchronized, UID=" + string + ", srcFile=" + file2 + ", destFile=" + file));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("source " + uRL + " (file is " + file2 + ") is not local folder, " + "skipping synchronization, UID=" + string));
        }
        return IoUtil.file2url(file);
    }

    static class ShadowFileFilter
    implements FileFilter {
        ShadowFileFilter() {
        }

        public boolean accept(File file) {
            return !ShadowDataController.META_FILE_NAME.equals(file.getName());
        }
    }
}

