/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.java.plugin.PluginManager;
import org.java.plugin.util.IoUtil;

public class StandardPluginLocation
implements PluginManager.PluginLocation {
    private final URL context;
    private final URL manifest;

    public static PluginManager.PluginLocation create(File file) throws MalformedURLException {
        if (file.isDirectory()) {
            URL uRL = StandardPluginLocation.getManifestUrl(file);
            return uRL == null ? null : new StandardPluginLocation(IoUtil.file2url(file), uRL);
        }
        String string = file.getName().toLowerCase(Locale.getDefault());
        if (!string.endsWith(".jar") && !string.endsWith(".zip")) {
            return null;
        }
        URL uRL = StandardPluginLocation.getManifestUrl(file);
        return uRL == null ? null : new StandardPluginLocation(new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/"), uRL);
    }

    private static URL getManifestUrl(File file) throws MalformedURLException {
        if (file.isDirectory()) {
            File file2 = new File(file, "plugin.xml");
            if (file2.isFile()) {
                return IoUtil.file2url(file2);
            }
            file2 = new File(file, "plugin-fragment.xml");
            if (file2.isFile()) {
                return IoUtil.file2url(file2);
            }
            file2 = new File(file, "META-INF" + File.separator + "plugin.xml");
            if (file2.isFile()) {
                return IoUtil.file2url(file2);
            }
            file2 = new File(file, "META-INF" + File.separator + "plugin-fragment.xml");
            if (file2.isFile()) {
                return IoUtil.file2url(file2);
            }
            return null;
        }
        if (!file.isFile()) {
            return null;
        }
        URL uRL = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/plugin.xml");
        if (IoUtil.isResourceExists(uRL)) {
            return uRL;
        }
        uRL = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/plugin-fragment.xml");
        if (IoUtil.isResourceExists(uRL)) {
            return uRL;
        }
        uRL = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/META-INF/plugin.xml");
        if (IoUtil.isResourceExists(uRL)) {
            return uRL;
        }
        uRL = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/META-INF/plugin-fragment.xml");
        if (IoUtil.isResourceExists(uRL)) {
            return uRL;
        }
        return null;
    }

    public StandardPluginLocation(URL uRL, URL uRL2) {
        if (uRL == null) {
            throw new NullPointerException("context");
        }
        if (uRL2 == null) {
            throw new NullPointerException("manifest");
        }
        this.context = uRL;
        this.manifest = uRL2;
    }

    public StandardPluginLocation(File file, String string) throws MalformedURLException {
        this.context = file.isDirectory() ? IoUtil.file2url(file) : new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/");
        this.manifest = new URL(this.context, string.startsWith("/") ? string.substring(1) : string);
    }

    public URL getManifestLocation() {
        return this.manifest;
    }

    public URL getContextLocation() {
        return this.context;
    }

    public String toString() {
        return this.context.toString();
    }
}

