/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.util.DateParser;

public abstract class FieldBase
implements IField {
    protected String ttvXPath;
    protected String value;
    protected String largeValue;
    protected List<Integer> indices;
    protected Asset root;
    protected long id;
    protected String dataType;
    protected Asset parentAsset;

    public FieldBase() {
        this.indices = new ArrayList<Integer>();
    }

    public FieldBase(String ttvXPath, String value) {
        this();
        this.setTtvXPath(ttvXPath);
        this.value = value;
    }

    public FieldBase(IField copyFromField) {
        this.setTtvXPath(copyFromField.getTtvXPath());
        if (copyFromField.getDataType() != null) {
            this.dataType = copyFromField.getDataType();
        }
        this.setValue(copyFromField.getValue());
        this.setIndices(copyFromField.getIndices());
        if (copyFromField.getRoot() != null) {
            this.setRoot(copyFromField.getRoot());
        }
        if (copyFromField.getParentAsset() != null) {
            this.setParentAsset(copyFromField.getParentAsset());
        }
    }

    @Override
    public String getTtvXPath() {
        return this.ttvXPath;
    }

    @Override
    public void setTtvXPath(String ttvXPath) {
        this.ttvXPath = ttvXPath;
        this.checkAndSetDataType();
    }

    @Override
    public String getValue() {
        if (this.largeValue != null && !this.largeValue.equals("")) {
            return this.largeValue;
        }
        return this.value;
    }

    @Override
    public Object getTypedValue() {
        if (this.value == null) {
            return null;
        }
        try {
            if (this.dataType.equals("string")) {
                return this.value;
            }
            if (this.dataType.equals("integer")) {
                return Integer.parseInt(this.value);
            }
            if (this.dataType.equals("boolean")) {
                return Boolean.parseBoolean(this.value);
            }
            if (this.dataType.equals("float")) {
                return Float.valueOf(Float.parseFloat(this.value));
            }
            if (this.dataType.equals("time")) {
                return this.value;
            }
            if (this.dataType.equals("date")) {
                return DateParser.parse(this.value);
            }
        }
        catch (Exception e) {
            return null;
        }
        throw new Error();
    }

    @Override
    public void setValue(String value) {
        if (value != null && value.length() > 2000) {
            this.largeValue = value;
            this.value = value.substring(0, 2000);
        } else {
            this.largeValue = "";
            this.value = value;
        }
    }

    @Override
    public List<Integer> getIndices() {
        return this.indices;
    }

    @Override
    public void setIndices(List<Integer> indices) {
        this.indices = indices;
    }

    @Override
    public Asset getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Asset root) {
        this.root = root;
    }

    @Override
    public String getStoredIndices() {
        StringBuilder sb = new StringBuilder();
        for (Integer index : this.indices) {
            sb.append("#");
            try {
                sb.append(index);
            }
            catch (Exception e) {}
        }
        return sb.toString();
    }

    private void setStoredIndices(String indices) {
        String[] split = indices.split("#");
        boolean first = true;
        for (String index : split) {
            if (first) {
                first = false;
                continue;
            }
            try {
                this.indices.add(Integer.parseInt(index));
            }
            catch (Exception e) {
                this.indices.add(null);
            }
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
        this.checkAndSetDataType();
    }

    protected void checkAndSetDataType() {
        DataTypeMappingReader reader = DataTypeMappingReader.getInstance(null);
        Map<String, String> map = reader.getDataTypeXpathMap();
        String type = "";
        if (map.containsKey(this.ttvXPath)) {
            type = map.get(this.ttvXPath);
        }
        if (type.equals("")) {
            if (this.dataType == null || this.dataType.equals("")) {
                this.dataType = "string";
            }
        } else {
            this.dataType = type;
        }
    }

    @Override
    public Asset getParentAsset() {
        return this.parentAsset;
    }

    @Override
    public void setParentAsset(Asset parentAsset) {
        this.parentAsset = parentAsset;
    }

    @Override
    public String toString() {
        return "[" + this.id + "] " + this.getTtvXPath() + ", " + this.getValue() + " " + this.getStoredIndices();
    }

    private String getLargeValue() {
        return this.largeValue;
    }

    private void setLargeValue(String largeValue) {
        this.largeValue = largeValue;
    }
}

