/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.SearchDataTypeHelper;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.Map;

public class CriteriaBuilder {
    protected static final String IFIELD_COLLECTION_NAME_FIELDS = "fields";
    protected static final String IFIELD_ENTITY_NAME_FIELD = "field";
    protected static final String IFIELD_COLLECTION_NAME_FIELD_REVISIONS = "fieldRevisions";
    protected static final String IFIELD_ENTITY_NAME_FIELD_REVISION = "fieldRevision";

    public static SearchCriteria baseBuildIFieldSearchCriteria(com.tandbergtv.metadatamanager.model.SearchCriteria criteria, String iFieldEntityName, String iFieldCollectionName) {
        if (criteria.entrySet().size() == 0) {
            return new SearchCriteria();
        }
        SearchCriteria crit = new SearchCriteria();
        Entity assetEntity = new Entity("asset", Asset.class, "a");
        for (Map.Entry entry : criteria.entrySet()) {
            String xpath = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (xpath.equals("rootlevel")) {
                assetEntity.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.ASSET_ROOT.toString(), SearchType.NUMERIC, (Object)null));
                continue;
            }
            Entity field = new Entity(iFieldEntityName, iFieldCollectionName, "f");
            field.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.TTV_XPATH.toString(), SearchType.STRING, (Object)xpath, SearchOperator.EQUAL));
            SearchType st = SearchDataTypeHelper.getSearchType(xpath);
            field.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.FIELD_VALUE.toString(), st, (Object)value));
            assetEntity.addParameter((SearchParameterBase)field);
        }
        assetEntity.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.ASSET_STATE.toString(), SearchType.NUMERIC, (Object)AssetState.ACTIVE.ordinal()));
        crit.addParameter((SearchParameterBase)assetEntity);
        crit.setRecordsCount(Integer.MAX_VALUE);
        return crit;
    }

    public static SearchCriteria buildSearchCriteria(com.tandbergtv.metadatamanager.model.SearchCriteria criteria) {
        SearchCriteria crit = new SearchCriteria();
        Entity assetEntity = new Entity("asset", Asset.class, "a");
        for (Map.Entry entry : criteria.entrySet()) {
            SearchType st = SearchDataTypeHelper.getAssetSearchType((String)entry.getKey());
            assetEntity.addParameter((SearchParameterBase)new ValueParameter((String)entry.getKey(), st, entry.getValue(), SearchOperator.EQUAL));
        }
        assetEntity.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.ASSET_STATE.toString(), SearchType.NUMERIC, (Object)AssetState.ACTIVE.ordinal()));
        crit.addParameter((SearchParameterBase)assetEntity);
        crit.setRecordsCount(Integer.MAX_VALUE);
        return crit;
    }

    public static SearchCriteria buildFieldSearchCriteria(com.tandbergtv.metadatamanager.model.SearchCriteria criteria) {
        return CriteriaBuilder.baseBuildIFieldSearchCriteria(criteria, IFIELD_ENTITY_NAME_FIELD, IFIELD_COLLECTION_NAME_FIELDS);
    }

    public static SearchCriteria buildFieldRevisionSearchCriteria(com.tandbergtv.metadatamanager.model.SearchCriteria criteria) {
        return CriteriaBuilder.baseBuildIFieldSearchCriteria(criteria, IFIELD_ENTITY_NAME_FIELD_REVISION, IFIELD_COLLECTION_NAME_FIELD_REVISIONS);
    }
}

