/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMPTZ;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLFormat;
import oracle.xml.binxml.BinXMLInfosetWriter;
import oracle.xml.binxml.BinXMLNamespaceToken;
import oracle.xml.binxml.BinXMLOpcode;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLQNameToken;
import oracle.xml.binxml.BinXMLSchLocTag;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLSchemaResolver;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLToken;
import oracle.xml.binxml.BinXMLTokenList;
import oracle.xml.binxml.BinXMLTokenManager;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabularyManager;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

class BinXMLEncoderImpl
implements BinXMLEncoder,
ContentHandler,
ErrorHandler,
DTDHandler,
DeclHandler,
LexicalHandler,
BinXMLConstants {
    boolean schemaAware = false;
    boolean inlineTokenDefs = true;
    boolean implicitSchemaReg = false;
    boolean saveSchemaValidationInfo = false;
    boolean midTierOpt = false;
    String schemaURL;
    BinXMLTokenManager tokenManager;
    BinXMLVocabularyManager vocabManager;
    BinXMLProcessorImpl binXMLProcessor;
    BinXMLStreamImpl binStream;
    BinXMLSectionState secState;
    BinXMLPageWriter writer;
    BinXMLSchemaResolver schemaResolver;
    XSDValidator validator;
    char[] charBuffer;
    int charLen = 0;
    Stack elementStack;
    byte[] docId = null;
    Locator locator = null;
    byte[] page;
    boolean dtd = false;
    boolean xdbMode = false;
    int pfxsufix = 0;
    HashMap spcTable;
    String xmlVersion = null;
    String standalone = null;
    String encoding = null;
    PrintWriter debugWriter;
    XMLError validatorErr = new XMLError();
    int depth;
    int cdataDepth;
    BinXMLElement currentElem;
    BinXMLEncBuffer buffer;
    oracle.xml.util.XMLError err;
    byte prev_event = 0;
    byte curr_event = 0;
    static final byte NO_EVENT = 0;
    static final byte START_ELEM_EVENT = 1;
    static final byte END_ELEM_EVENT = 2;
    static final byte CHARS_EVENT = 3;
    static final byte DTD_EVENT = 4;
    static final byte OTHER_EVENT = 5;
    static final byte BUFSTATE_NONE = 1;
    static final byte BUFSTATE_GOTSTART = 2;
    static final byte BUFSTATE_GOTFIRSTTEXT = 3;
    static final byte BUFSTATE_GOTEND = 4;
    static final byte BUFSTATE_LAST = 5;
    static final byte SIMPLENODE_QNAMEID = 1;
    static final byte SIMPLENODE_ARRAY = 2;
    static final byte SIMPLENODE_DATAONLY = 3;
    static final byte SIMPLENODE_KIDNUM = 4;
    static final byte SIMPLENODE_SCHEMASEQ = 5;
    static final int CHAR_SIZE = 4096;

    public void setProperty(int n, boolean bl) throws BinXMLException {
        switch (n) {
            case 1: {
                this.schemaAware = bl;
                if (!this.schemaAware) break;
                this.inlineTokenDefs = true;
                break;
            }
            case 2: {
                this.saveSchemaValidationInfo = bl;
                break;
            }
            case 3: {
                this.implicitSchemaReg = bl;
                break;
            }
            case 4: {
                if (this.schemaAware) {
                    this.inlineTokenDefs = true;
                    break;
                }
                this.inlineTokenDefs = bl;
                break;
            }
            case 5: {
                this.midTierOpt = bl;
                break;
            }
            case 6: {
                this.xdbMode = bl;
            }
        }
    }

    public void setSchema(String string) throws BinXMLException {
        this.schemaURL = string;
    }

    public void setChunkMode(boolean bl) {
        this.writer.setChunkMode(bl);
    }

    public void setChunkBufSize(int n) {
        this.writer.setChunkBufSize(n);
    }

    public ContentHandler getContentHandler() throws BinXMLException {
        if (this.schemaAware || this.saveSchemaValidationInfo) {
            try {
                this.validator = new XSDValidator();
                this.validator.addContentHandler(this);
                this.schemaResolver = new BinXMLSchemaResolver(this.vocabManager);
                this.schemaResolver.setXMLError(this.err);
                this.validator.setProperty("SCHEMA_RESOLVER", this.schemaResolver);
                this.validatorErr.reset();
                this.validator.setError(this.validatorErr);
                if (this.schemaURL != null) {
                    BinXMLSchema binXMLSchema;
                    if (this.vocabManager.getMetadataProvider() instanceof DBBinXMLMetadataProviderImpl) {
                        binXMLSchema = this.schemaResolver.getSchema(this.schemaURL);
                    } else {
                        URL uRL = this.schemaResolver.createURL(this.schemaURL);
                        binXMLSchema = this.schemaResolver.getSchema(uRL);
                    }
                    this.validator.setXMLSchema(binXMLSchema.getXMLSchema());
                    binXMLSchema.setValidator(this.validator);
                }
                return this.validator;
            }
            catch (XSDException xSDException) {
                throw new BinXMLException(xSDException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new BinXMLException(sAXException.getMessage());
            }
        }
        return this;
    }

    public ErrorHandler getErrorHandler() throws BinXMLException {
        return this;
    }

    public DTDHandler getDTDHandler() throws BinXMLException {
        return this;
    }

    public DeclHandler getDeclHandler() throws BinXMLException {
        return this;
    }

    public LexicalHandler getLexicalHandler() throws BinXMLException {
        return this;
    }

    public InfosetWriter createInfosetWriter() throws BinXMLException {
        return new BinXMLInfosetWriter(this);
    }

    XSDValidator getValidator() {
        return this.validator;
    }

    private void validate() throws BinXMLException {
        if (this.validatorErr.getNumMessages() > 0) {
            int n = this.validatorErr.getFirstError();
            throw new BinXMLException(this.validatorErr.getMessage(n));
        }
    }

    BinXMLEncoderImpl(BinXMLStream binXMLStream) {
        this.charBuffer = new char[4096];
        this.elementStack = new Stack();
        this.binStream = (BinXMLStreamImpl)binXMLStream;
        this.page = this.binStream.getWriteBuffer();
        this.writer = new BinXMLPageWriter(this.page, this.binStream);
        this.binXMLProcessor = (BinXMLProcessorImpl)this.binStream.getBinXMLProcessor();
        this.tokenManager = this.binXMLProcessor.getTokenManager();
        this.vocabManager = this.binXMLProcessor.getVocabularyManager();
        this.initSpaceTable();
        if (this.binXMLProcessor.getDebugMode()) {
            File file = new File("encoder.log");
            try {
                this.debugWriter = new PrintWriter(new FileWriter(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            this.secState = new BinXMLSectionState(this.binStream);
            this.secState.encodeSectionHeader();
            if (this.locator != null && this.locator instanceof Locator2) {
                this.xmlVersion = ((Locator2)this.locator).getXMLVersion();
                if (this.locator instanceof XMLLocator) {
                    if (this.encoding == null) {
                        this.encoding = ((XMLLocator)this.locator).getDeclEncoding();
                    }
                    if (this.standalone == null) {
                        this.standalone = ((XMLLocator)this.locator).getStandalone();
                    }
                }
            }
            int n = 0;
            int n2 = 0;
            byte[] byArray = null;
            if (this.xmlVersion != null) {
                n = (short)(n | 2);
                if (this.standalone != null && this.standalone.equalsIgnoreCase("yes")) {
                    n = (short)(n | 1);
                    n = (short)(n | 0x10);
                }
                if (this.xmlVersion == "1.1") {
                    n = (short)(n | 0x1100);
                    n = (short)(n | 8);
                }
                if (this.encoding != null) {
                    n = (short)(n | 4);
                    byArray = this.encoding.getBytes("UTF-8");
                    n2 = byArray.length;
                }
            }
            this.writer.writeOpcode((short)158, true);
            this.writer.writeByte((byte)n2, true);
            this.writer.writeShort(n, true);
            if (n2 != 0) {
                this.writer.writeByteArray(byArray, true);
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.secState.encodeSectionEnd();
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.charLen > 0) {
            if (!this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        try {
            short s;
            long l;
            Object object;
            String string4;
            String string5;
            String string6;
            String string7;
            int n;
            Object object2;
            long l2;
            this.validate();
            this.prev_event = this.curr_event;
            this.curr_event = 1;
            boolean bl = false;
            BinXMLElement binXMLElement = null;
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
            this.currentElem = new BinXMLElement();
            if (this.schemaAware) {
                this.currentElem.binSchema = this.schemaResolver.getCurrentSchema();
            }
            ++this.depth;
            if (this.depth > 1) {
                binXMLElement = (BinXMLElement)this.elementStack.peek();
            } else if (this.schemaAware) {
                this.writeSchemaScopeStart(this.currentElem.binSchema);
            }
            this.elementStack.push(this.currentElem);
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            long l3 = 0L;
            if (string.length() > 0) {
                if (this.tokenManager.namespaceURITokens.get(string) == null) {
                    bl2 = false;
                }
                if (this.secState.addNamespaceId(new Long(l2 = this.tokenManager.getNamespaceTokenId(string)))) {
                    this.encodeNamespace(l2, string);
                }
            } else {
                l2 = 7L;
            }
            if (this.schemaAware) {
                this.currentElem.prop = this.currentElem.binSchema.getCurrentProperty();
                if (this.currentElem.prop == null) {
                    this.currentElem.any = true;
                } else {
                    this.currentElem.kidNum = binXMLElement == null ? (short)-1 : ((object2 = binXMLElement.prop) != null ? this.currentElem.prop.getKidNum((BinXMLProperty)object2) : (short)-1);
                    if (this.currentElem.prop.isAnyElement() || this.currentElem.kidNum == -1) {
                        this.currentElem.any = true;
                    }
                }
            }
            if (!this.schemaAware) {
                object2 = this.tokenManager.getElementToken(string2, l2, string);
                if (object2 == null) {
                    object2 = this.tokenManager.putElement(string2, l2);
                    if (this.tokenManager.metaProvider != null || this.inlineTokenDefs) {
                        this.encodeToken((BinXMLQNameToken)object2, false);
                    }
                }
                this.currentElem.qnameId = ((BinXMLToken)object2).getTokenId();
            }
            int n2 = attributes.getLength();
            short s2 = 0;
            boolean bl6 = false;
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                string7 = attributes.getLocalName(n);
                string6 = attributes.getURI(n);
                string5 = attributes.getValue(n);
                string4 = XMLUtil.getPrefix(attributes.getQName(n));
                if (this.schemaAware && string6.equals("http://www.w3.org/2001/XMLSchema-instance") && (string7.equals("schemaLocation") || string7.equals("noNamespaceSchemaLocation"))) {
                    boolean bl7 = false;
                    if (string7.equals("schemaLocation")) {
                        bl7 = true;
                    }
                    try {
                        object = this.schemaResolver.getCurrentSchema(string5, bl7, this);
                        if (object != null) {
                            if (object != this.currentElem.binSchema) {
                                this.writeSchemaScopeStart((BinXMLSchema)object);
                            }
                            this.currentElem.binSchema = object;
                        } else {
                            this.currentElem.binSchema = this.schemaResolver.getCurrentSchema();
                        }
                        BinXMLSchLocTag binXMLSchLocTag = new BinXMLSchLocTag(string, string2, string3, this.depth);
                        binXMLSchLocTag.setValidator(this.currentElem.binSchema.getValidator());
                        this.schemaResolver.pushSchLocTag(binXMLSchLocTag);
                        continue;
                    }
                    catch (XSDException xSDException) {
                        throw new BinXMLException(xSDException.getMessage());
                    }
                }
                if (this.schemaAware && this.currentElem.binSchema != null && string6.equals("http://www.w3.org/2001/XMLSchema-instance") && string7.equals("type")) {
                    bl6 = true;
                    this.currentElem.propId = this.currentElem.prop.getPropId();
                    this.currentElem.prop = this.currentElem.binSchema.getCurrentTypeProperty();
                    n3 = this.currentElem.prop.getTypeId();
                    continue;
                }
                if (!string4.equals("xmlns") && (string4.length() != 0 || !string7.equals("xmlns"))) continue;
                if (string7.length() > 255) {
                    throw new BinXMLException(this.err.getMessage0(35003));
                }
                l = this.tokenManager.getNamespaceTokenId(string5);
                if (l == l2) {
                    bl3 = true;
                }
                this.secState.addNamespaceId(new Long(l));
                if (string4.length() > 0) {
                    String string8 = XMLUtil.getPrefix(string3);
                    if (string7.equals(string8) && !string5.equals(string)) {
                        bl2 = true;
                    }
                    s2 = this.secState.insertPrefix(string7, string5);
                } else {
                    bl4 = true;
                    s2 = this.secState.insertPrefix("", string5);
                }
                if (!this.inlineTokenDefs) continue;
                this.encodeNamespace(l, string5);
            }
            if (!bl3 && !bl2 && this.inlineTokenDefs) {
                bl5 = true;
                this.encodeNamespace(l2, string);
                String string9 = XMLUtil.getPrefix(string3);
                if (string9.length() > 0) {
                    l3 = this.secState.insertPrefix(string9, string);
                } else {
                    String string10 = "";
                    l3 = bl4 ? -1L : (long)this.secState.insertPrefix(string10, string);
                }
            }
            if (this.currentElem.prop != null && this.currentElem.prop.isSequential()) {
                this.currentElem.schemaSeqMode = true;
                this.currentElem.maxKidNum = this.currentElem.prop.getMaxKidNum();
            }
            if (!this.schemaAware || this.currentElem.prop == null || this.depth == 1 || this.currentElem.any || this.currentElem.prop.isSubstitutionGroupMember()) {
                if (this.currentElem.prop != null) {
                    n = bl6 ? this.currentElem.propId : this.currentElem.prop.getPropId();
                    this.currentElem.qnameId = 0xFFFFFFFFFFFFFFFFL & (long)(-n);
                } else {
                    BinXMLQNameToken binXMLQNameToken = this.tokenManager.getElementToken(string2, l2, string);
                    if (binXMLQNameToken == null) {
                        binXMLQNameToken = this.tokenManager.putElement(string2, l2);
                        if (this.tokenManager.metaProvider != null || this.inlineTokenDefs) {
                            this.encodeToken(binXMLQNameToken, false);
                        }
                    }
                    this.currentElem.qnameId = binXMLQNameToken.getTokenId();
                }
            }
            short s3 = 0;
            boolean bl8 = false;
            if (string.length() > 0 && (s3 = this.secState.getPfxId((String)(object = XMLUtil.getPrefix(string3)), l2, false)) >= 0) {
                bl8 = true;
            }
            byte by = 0;
            if (bl8) {
                by = (byte)(by | 8);
            }
            if (bl6) {
                by = (byte)(by | 2);
            }
            if (this.currentElem.schemaSeqMode) {
                by = (byte)(by | 1);
            }
            if (binXMLElement != null) {
                if (binXMLElement.firstChild) {
                    binXMLElement.firstChild = false;
                    binXMLElement.kidNum = 0;
                } else if (!this.currentElem.any && this.currentElem.prop != null && binXMLElement.prevChildProp != null && this.currentElem.prop.getQName().equals(binXMLElement.prevChildProp.getQName()) || this.currentElem.prop == null && this.currentElem.qnameId == binXMLElement.prevChildQnameId && by == binXMLElement.prevChildFlag && (!bl8 || s3 == binXMLElement.prevChildPfxId) && n3 == binXMLElement.prevChildTypeId) {
                    bl = true;
                    if (!binXMLElement.arrayMode) {
                        this.writer.writeOpcode((short)215, false);
                        binXMLElement.arrayMode = true;
                    }
                } else if (binXMLElement.arrayMode) {
                    this.writer.writeOpcode((short)216, false);
                    binXMLElement.arrayMode = false;
                }
                if (!binXMLElement.arrayMode) {
                    binXMLElement.prevChildQnameId = this.currentElem.qnameId;
                    binXMLElement.prevChildProp = this.currentElem.prop;
                    binXMLElement.prevChildFlag = by;
                    binXMLElement.prevChildPfxId = s3;
                    binXMLElement.prevChildTypeId = n3;
                }
            }
            if (!bl5 && n2 == 0 && by == 0) {
                this.buffer = new BinXMLEncBuffer(this.currentElem.qnameId, bl8, bl, s3, by, bl6, n3);
                return;
            }
            boolean bl9 = false;
            if (bl) {
                this.writeELMST();
                bl9 = true;
            } else if (binXMLElement != null && binXMLElement.schemaSeqMode) {
                s = binXMLElement.maxKidNum;
                if (!(this.currentElem.any || this.currentElem.prop == null || this.currentElem.kidNum <= binXMLElement.kidNum || this.currentElem.kidNum > s || bl8 || bl6 || this.currentElem.prop.isSubstitutionGroupMember())) {
                    for (int i = 1; i < this.currentElem.kidNum - binXMLElement.kidNum; ++i) {
                        this.writer.writeOpcode((short)144, false);
                    }
                    this.writeELMST();
                    bl9 = true;
                    binXMLElement.kidNum = this.currentElem.kidNum;
                } else {
                    this.writer.writeOpcode((short)218, false);
                }
            }
            if (!bl9) {
                if (this.currentElem.prop != null && this.depth != 1 && !this.currentElem.any && !this.currentElem.prop.isSubstitutionGroupMember()) {
                    this.writeNodeStartKidnum(this.currentElem.kidNum, by, bl8, s3, bl6, n3);
                } else {
                    this.writeElementAttrStart(this.currentElem.qnameId, bl8, by, s3, bl6, n3);
                }
            }
            s = 0;
            BinXMLProperty binXMLProperty = null;
            if (bl5 && l3 >= 0L) {
                this.writer.writeOpcode((short)221, false);
                this.writer.writeShort((short)l3, false);
            }
            for (int i = 0; i < n2; ++i) {
                string7 = attributes.getLocalName(i);
                string6 = attributes.getURI(i);
                string5 = attributes.getValue(i);
                string4 = XMLUtil.getPrefix(attributes.getQName(i));
                if (string4.equals("xmlns") || string4.length() == 0 && string7.equals("xmlns")) {
                    l = string5 != null && string5.length() == 0 ? 7L : this.tokenManager.getNamespaceTokenId(string5);
                    s2 = string4.length() > 0 ? this.secState.getPfxId(string7, l, true) : this.secState.getPfxId("", l, true);
                    if (s2 < 0) continue;
                    this.writer.writeOpcode((short)221, false);
                    this.writer.writeShort(s2, false);
                    continue;
                }
                if (this.schemaAware) {
                    binXMLProperty = this.currentElem.binSchema.getAttrProperty(string6, string7);
                }
                if (string6.length() > 0) {
                    l = this.tokenManager.getNamespaceTokenId(string6);
                    this.secState.addNamespaceId(new Long(l));
                    s2 = this.secState.getPfxId(string4, l, false);
                    s = s2 >= 0;
                } else {
                    l = 7L;
                    s = 0;
                }
                if (this.currentElem.schemaSeqMode) {
                    this.writer.writeOpcode((short)218, false);
                }
                short s4 = -1;
                BinXMLProperty binXMLProperty2 = this.currentElem.prop;
                if (binXMLProperty != null && binXMLProperty2 != null) {
                    s4 = binXMLProperty.getKidNum(binXMLProperty2);
                } else if (binXMLProperty != null) {
                    s4 = binXMLProperty.getKidNum();
                }
                if (binXMLProperty != null && !binXMLProperty.isAnyAttr()) {
                    this.writeNodeKidnum(s != 0, s2, false, 0, s4, (byte)0, this.currentElem.prop, binXMLProperty, string5);
                    continue;
                }
                BinXMLQNameToken binXMLQNameToken = this.tokenManager.getAttrToken(string7, l, string6);
                if (binXMLQNameToken == null) {
                    binXMLQNameToken = this.tokenManager.putAttr(string7, l);
                    if (this.tokenManager.metaProvider != null || this.inlineTokenDefs) {
                        this.encodeToken(binXMLQNameToken, true);
                    }
                }
                if (binXMLQNameToken.getTokenId() == 18L) {
                    this.writeSimpleNode(binXMLQNameToken.getTokenId(), null, null, (short)0, string5, (byte)1);
                    continue;
                }
                this.writeElementAttr(binXMLQNameToken.getTokenId(), s != 0, s2, string5, false, 0);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (BinXMLException binXMLException) {
            throw new SAXException(binXMLException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        if (this.validator != null) {
            object = this.validator.getLexicalValue();
            if (this.charLen > 0 && object != null && ((String)object).length() <= this.charLen) {
                this.chars(((String)object).toCharArray(), 0, ((String)object).length());
                this.charLen = 0;
            }
        }
        if (this.charLen > 0) {
            if (this.prev_event == 1 || !this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        this.prev_event = this.curr_event;
        this.curr_event = (byte)2;
        try {
            this.validate();
            if (this.buffer != null && (this.buffer.state == 2 || this.buffer.state == 3)) {
                this.buffer.state = (byte)4;
                this.buffer.flush();
            } else {
                if (this.currentElem.arrayMode) {
                    this.writer.writeOpcode((short)216, false);
                }
                this.writer.writeOpcode((short)217, false);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (BinXMLException binXMLException) {
            throw new SAXException(binXMLException);
        }
        --this.depth;
        if (this.schemaAware && (object = this.schemaResolver.popSchLocTag(string, string2, string3, this.depth, this.validator)) != this.validator) {
            try {
                this.writer.writeOpcode((short)148, false);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.validator = object;
        }
        this.currentElem = (BinXMLElement)this.elementStack.pop();
        this.currentElem = this.depth > 0 ? (BinXMLElement)this.elementStack.peek() : null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.cdataDepth > 0) {
            this.chars(cArray, n, n2);
        } else {
            if (this.charLen > 0 && n2 + this.charLen > 4096) {
                this.chars(this.charBuffer, 0, this.charLen);
                this.charLen = 0;
            }
            if (n2 > 4096) {
                this.chars(cArray, n, n2);
            } else {
                System.arraycopy(cArray, n, this.charBuffer, this.charLen, n2);
                this.charLen += n2;
            }
        }
    }

    void chars(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.validate();
            if (this.cdataDepth > 0) {
                if (this.buffer != null && this.buffer.state != 1) {
                    this.buffer.flush();
                }
                this.writeCDATA(new String(cArray, n, n2));
                return;
            }
            if (this.buffer != null && this.buffer.state == 2) {
                if (n2 <= 16383) {
                    this.buffer.state = (byte)3;
                    this.buffer.textdata = new String(cArray, n, n2);
                } else {
                    this.buffer.flush();
                    this.writeText(new String(cArray, n, n2));
                }
                return;
            }
            if (this.buffer != null && this.buffer.state == 3) {
                if (n2 + this.buffer.textdata.length() > 16383) {
                    this.buffer.flush();
                } else {
                    this.buffer.textdata = this.buffer.textdata.concat(new String(cArray, n, n2));
                    return;
                }
            }
            if (this.currentElem.arrayMode || this.currentElem.schemaSeqMode) {
                if (BinXMLUtil.isPureWhiteSpace(cArray, n, n2)) {
                    if (this.currentElem.kidNum < 1 || this.isValidLocation4WS()) {
                        this.writeWhiteSpace(cArray, n, n2);
                    } else {
                        this.writeText(new String(cArray, n, n2));
                    }
                } else {
                    this.writeText(new String(cArray, n, n2));
                }
            } else {
                if (this.buffer != null && this.buffer.state == 1) {
                    this.buffer.flush();
                }
                if (BinXMLUtil.isPureWhiteSpace(cArray, n, n2)) {
                    this.writeWhiteSpace(cArray, n, n2);
                } else {
                    this.writeSimpleNode(0L, null, null, (short)0, new String(cArray, n, n2), (byte)3);
                }
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException(binXMLException);
        }
    }

    private boolean isValidLocation4WS() {
        if (this.prev_event == 1 && this.curr_event == 1) {
            return true;
        }
        if (this.prev_event == 1 && this.curr_event == 2) {
            return true;
        }
        if (this.prev_event == 2 && this.curr_event == 1) {
            return true;
        }
        return this.prev_event == 2 && this.curr_event == 2;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.charLen > 0) {
            if (!this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        try {
            String string3;
            byte[] byArray;
            int n;
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
            if ((n = (byArray = this.convTextToCSXString(string3 = string.concat(string2))).length) <= 255) {
                this.writer.writeOpcode((short)169, false);
                this.writer.writeByte((byte)n, false);
                this.writer.writeByte((byte)string.length(), false);
            } else {
                this.writer.writeOpcode((short)170, false);
                this.writer.writeInt(n, false);
                this.writer.writeShort(string.length(), false);
            }
            this.writer.writeByteArray(byArray, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException(binXMLException);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        try {
            this.writer.writeOpcode((short)154, false);
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            if (string3 != null) {
                byArray3 = string3.getBytes("UTF-8");
                n3 = byArray3.length;
            }
            this.writer.writeShort(n + n2 + n3, false);
            this.writeShortByteArray(n, byArray, false);
            this.writeShortByteArray(n2, byArray2, false);
            this.writeShortByteArray(n3, byArray3, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        try {
            this.writer.writeOpcode((short)152, false);
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            if (string3 != null) {
                byArray3 = string3.getBytes("UTF-8");
                n3 = byArray3.length;
            }
            if (string4 != null) {
                byArray4 = string4.getBytes("UTF-8");
                n4 = byArray4.length;
            }
            this.writer.writeShort(n + n2 + n3 + n4, false);
            this.writeShortByteArray(n, byArray, false);
            this.writer.writeShort(0, false);
            this.writeShortByteArray(n2, byArray2, false);
            this.writeShortByteArray(n3, byArray3, false);
            this.writeShortByteArray(n4, byArray4, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        try {
            this.writer.writeOpcode((short)151, false);
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            byte[] byArray5 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            if (string3 != null) {
                byArray3 = string3.getBytes("UTF-8");
                n3 = byArray3.length;
            }
            if (string4 != null) {
                byArray4 = string4.getBytes("UTF-8");
                n4 = byArray4.length;
            }
            if (string5 != null) {
                byArray5 = string5.getBytes("UTF-8");
                n5 = byArray5.length;
            }
            this.writer.writeShort(n + n2 + n3 + n4 + n5, false);
            this.writeShortByteArray(n, byArray, false);
            this.writeShortByteArray(n2, byArray2, false);
            this.writeShortByteArray(n3, byArray3, false);
            this.writeShortByteArray(n4, byArray4, false);
            this.writeShortByteArray(n5, byArray5, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
        try {
            this.writer.writeOpcode((short)150, false);
            byte[] byArray = null;
            byte[] byArray2 = null;
            int n = 0;
            int n2 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            this.writer.writeShort(n + n2, false);
            this.writeShortByteArray(n, byArray, false);
            this.writeShortByteArray(n2, byArray2, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        try {
            this.writer.writeOpcode((short)152, false);
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            if (string3 != null) {
                byArray3 = string3.getBytes("UTF-8");
                n3 = byArray3.length;
            }
            this.writer.writeShort(n + n2 + n3, false);
            this.writeShortByteArray(n, byArray, false);
            this.writer.writeShort(0, false);
            this.writeShortByteArray(n2, byArray2, false);
            this.writeShortByteArray(n3, byArray3, false);
            this.writer.writeShort(0, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        try {
            this.writer.writeOpcode((short)152, false);
            byte[] byArray = null;
            byte[] byArray2 = null;
            int n = 0;
            int n2 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            this.writer.writeShort(n + n2, false);
            this.writeShortByteArray(n, byArray, false);
            this.writeShortByteArray(n2, byArray2, false);
            this.writer.writeShort(0, false);
            this.writer.writeShort(0, false);
            this.writer.writeShort(0, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.charLen > 0) {
            if (!this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        try {
            String string;
            byte[] byArray;
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
            if ((byArray = (string = new String(cArray, n, n2)).getBytes("UTF-8")).length <= 255) {
                this.writer.writeOpcode((short)171, false);
                this.writer.writeByte((byte)byArray.length, false);
            } else if (byArray.length <= 65535) {
                this.writer.writeOpcode((short)172, false);
                this.writer.writeShort(byArray.length, false);
            } else {
                this.writer.writeOpcode((short)173, false);
                this.writer.writeLong8(byArray.length, false);
            }
            if (byArray.length > 0) {
                this.writer.writeByteArray(byArray, false);
            }
        }
        catch (Exception exception) {
            new SAXException(exception.getMessage(), exception);
        }
    }

    public void endCDATA() throws SAXException {
        --this.cdataDepth;
    }

    public void endDTD() throws SAXException {
        try {
            this.writer.writeOpcode((short)155, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (this.cdataDepth == 0 && this.charLen > 0) {
            if (!this.xdbMode || !BinXMLUtil.isPureWhiteSpace(this.charBuffer, 0, this.charLen)) {
                this.chars(this.charBuffer, 0, this.charLen);
            }
            this.charLen = 0;
        }
        try {
            this.validate();
            if (this.buffer != null && this.buffer.state != 1) {
                this.buffer.flush();
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException.getMessage(), iOException);
        }
        catch (BinXMLException binXMLException) {
            new SAXException(binXMLException.getMessage(), binXMLException);
        }
        ++this.cdataDepth;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        try {
            this.dtd = true;
            this.writer.writeOpcode((short)149, false);
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (string != null) {
                byArray = string.getBytes("UTF-8");
                n = byArray.length;
            }
            if (string2 != null) {
                byArray2 = string2.getBytes("UTF-8");
                n2 = byArray2.length;
            }
            if (string3 != null) {
                byArray3 = string3.getBytes("UTF-8");
                n3 = byArray3.length;
            }
            this.writer.writeShort(n + n2 + n3, false);
            this.writeShortByteArray(n, byArray, false);
            this.writeShortByteArray(n2, byArray2, false);
            this.writeShortByteArray(n3, byArray3, false);
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    public void startEntity(String string) throws SAXException {
    }

    private void writeWhiteSpace(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        char c = ' ';
        boolean bl = true;
        for (int i = n; i < n + n2; ++i) {
            if (bl) {
                switch (cArray[i]) {
                    case '\t': {
                        c = '\t';
                        break;
                    }
                    case ' ': {
                        c = ' ';
                        break;
                    }
                    case '\r': {
                        c = '\r';
                        break;
                    }
                    case '\n': {
                        c = '\n';
                    }
                }
            }
            while (i < n + n2 && cArray[i] == c) {
                ++n3;
                bl = false;
                ++i;
            }
            if (i >= n + n2) continue;
            this.writeSPACEx(n3, c);
            n3 = 0;
            --i;
            bl = true;
        }
        this.writeSPACEx(n3, c);
    }

    void writeSPACEx(int n, char c) throws IOException {
        int n2 = 1;
        if (n > 32 && n < 8192) {
            n2 = 2;
        } else if (n > 8192) {
            n2 = 8;
        }
        int n3 = 0;
        switch (c) {
            case ' ': {
                break;
            }
            case '\t': {
                n3 = 1;
                break;
            }
            case '\n': {
                n3 = 2;
                break;
            }
            case '\r': {
                n3 = 3;
            }
        }
        switch (n2) {
            case 1: {
                byte by = (byte)((n3 << 5 & 0xFF) + (n >>> 0 & 0xFF));
                this.writer.writeOpcode((short)234, false);
                this.writer.writeByte(by, false);
                break;
            }
            case 2: {
                byte[] byArray = new byte[]{(byte)((n3 << 5 & 0xFF) + (n >>> 8 & 0xFF)), (byte)(n >>> 0 & 0xFF)};
                this.writer.writeOpcode((short)235, false);
                this.writer.writeByteArray(byArray, false);
                break;
            }
            case 8: {
                byte[] byArray = new byte[]{(byte)(n3 << 5 & 0xFF), 0, 0, 0, (byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
                this.writer.writeOpcode((short)236, false);
                this.writer.writeByteArray(byArray, false);
            }
        }
    }

    void writeELMST() throws IOException {
        if (this.currentElem.schemaSeqMode) {
            this.writer.writeOpcode((short)214, false);
        } else {
            this.writer.writeOpcode((short)213, false);
        }
    }

    void writeElementAttrStart(long l, boolean bl, int n, short s, boolean bl2, int n2) throws IOException {
        if (n == 0) {
            if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)201, false);
                this.writer.writeLong4(l, false);
            } else {
                this.writer.writeOpcode((short)202, false);
                this.writer.writeLong8(l, false);
            }
        } else if (!bl && !bl2) {
            if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)206, false);
                this.writer.writeLong4(l, false);
            } else {
                this.writer.writeOpcode((short)207, false);
                this.writer.writeLong8(l, false);
            }
            this.writer.writeByte(n, false);
        } else {
            int n3 = 0;
            if (bl) {
                n3 = (byte)(n3 + 2);
            }
            if (bl2) {
                n3 = (byte)(n3 + 4);
            }
            if (l <= 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)211, false);
                this.writer.writeByte(n3, false);
                this.writer.writeLong4(l, false);
            } else {
                this.writer.writeOpcode((short)212, false);
                this.writer.writeByte(n3, false);
                this.writer.writeLong8(l, false);
            }
            this.writer.writeByte(n, false);
            if (bl2) {
                this.writer.writeInt(n2, false);
            }
            if (bl) {
                this.writer.writeShort(s, false);
            }
        }
    }

    void writeElementAttr(long l, boolean bl, short s, String string, boolean bl2, int n) throws IOException, BinXMLException {
        long l2 = string.length();
        if (!bl && l2 <= 65535L) {
            this.writeSimpleNode(l, null, null, (short)0, string, (byte)1);
            return;
        }
        this.writeElementAttrStart(l, bl, bl ? 8 : 0, s, bl2, n);
        this.writeSimpleNode(0L, null, null, (short)0, string, (byte)3);
        this.writer.writeOpcode((short)217, false);
    }

    void writeNodeKidnum(boolean bl, short s, boolean bl2, int n, short s2, byte by, BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2, String string) throws IOException, BinXMLException {
        long l = string.length();
        if (!bl && !bl2 && l <= 65535L) {
            this.writeSimpleNode(0L, binXMLProperty, binXMLProperty2, s2, string, (byte)4);
            return;
        }
        if (bl) {
            by = (byte)(by | 8);
        }
        if (bl2) {
            by = (byte)(by | 2);
        }
        this.writeNodeStartKidnum(s2, by, bl, s, bl2, n);
        this.writeSimpleNode(0L, binXMLProperty, binXMLProperty2, s2, string, (byte)3);
        this.writer.writeOpcode((short)217, false);
    }

    void writeNodeStartKidnum(short s, byte by, boolean bl, short s2, boolean bl2, int n) throws IOException {
        if (by == 0) {
            if (s <= 255) {
                this.writer.writeOpcode((short)198, false);
                this.writer.writeByte((byte)s, false);
            } else {
                this.writer.writeOpcode((short)199, false);
                this.writer.writeShort(s, false);
            }
        } else if (!bl && !bl2) {
            if (s <= 255) {
                this.writer.writeOpcode((short)203, false);
                this.writer.writeByte((byte)s, false);
                this.writer.writeByte(by, false);
            } else {
                this.writer.writeOpcode((short)204, false);
                this.writer.writeShort(s, false);
                this.writer.writeByte(by, false);
            }
        } else {
            int n2 = 0;
            if (bl) {
                n2 = (byte)(n2 + 2);
            }
            if (bl2) {
                n2 = (byte)(n2 + 4);
            }
            if (s <= 255) {
                this.writer.writeOpcode((short)208, false);
                this.writer.writeByte(n2, false);
                this.writer.writeByte((byte)s, false);
                this.writer.writeByte(by, false);
                if (bl2) {
                    this.writer.writeInt(n, false);
                }
                if (bl) {
                    this.writer.writeShort(s2, false);
                }
            } else {
                this.writer.writeOpcode((short)209, false);
                this.writer.writeByte(n2, false);
                this.writer.writeShort(s, false);
                this.writer.writeByte(by, false);
                if (bl2) {
                    this.writer.writeInt(n, false);
                }
                if (bl) {
                    this.writer.writeShort(s2, false);
                }
            }
        }
    }

    static int bindXMLTypeToEncodingType(int n) {
        switch (n) {
            case 18: {
                return 13;
            }
        }
        return 1;
    }

    void writeSimpleNode(long l, BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2, short s, String string, byte by) throws IOException, BinXMLException {
        byte[] byArray = null;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (binXMLProperty2 != null) {
            n2 = binXMLProperty2.getTypeId();
        }
        if (string != null && binXMLProperty2 != null && (n3 = BinXMLEncoderImpl.bindXMLTypeToEncodingType(n2)) != 1) {
            if (n2 != n3) {
                byArray = n3 == 13 ? this.convTextToQName(string, binXMLProperty2, this.secState) : this.convTextToCSX(string, n2, n3, binXMLProperty2);
            }
            l2 = byArray.length;
        } else if (this.validator != null && l == 18L) {
            n3 = 13;
            byArray = this.convTextToQName(string, null, this.secState);
            l2 = byArray.length;
        } else {
            n3 = 1;
            if (string != null) {
                byArray = this.convTextToCSXString(string);
                l2 = byArray.length;
            }
        }
        n = n3 == 2 && l2 <= 32L || n3 != 2 && l2 <= 64L ? 1 : (l2 <= 16383L ? 2 : 8);
        switch (by) {
            case 2: 
            case 3: 
            case 5: {
                if (n == 1) break;
                if (n == 2) {
                    this.writer.writeOpcode((short)138, false);
                    break;
                }
                this.writer.writeOpcode((short)139, false);
                break;
            }
            case 4: {
                if (s <= 255) {
                    if (n == 1) {
                        this.writer.writeOpcode((short)188, false);
                        break;
                    }
                    if (n != 2) break;
                    this.writer.writeOpcode((short)189, false);
                    break;
                }
                if (n == 1) {
                    this.writer.writeOpcode((short)190, false);
                    break;
                }
                if (n != 2) break;
                this.writer.writeOpcode((short)191, false);
                break;
            }
            case 1: {
                if (l <= 0xFFFFFFFFL) {
                    if (n == 1) {
                        this.writer.writeOpcode((short)194, false);
                        break;
                    }
                    if (n != 2) break;
                    this.writer.writeOpcode((short)195, false);
                    break;
                }
                if (n == 1) {
                    this.writer.writeOpcode((short)196, false);
                    break;
                }
                if (n != 2) break;
                this.writer.writeOpcode((short)197, false);
                break;
            }
        }
        if (n == 1) {
            int n4 = 0;
            if (l2 == 0L) {
                n4 = 143;
            } else {
                block5 : switch (n3) {
                    case 12: {
                        if (l2 == 1L) {
                            n4 = 136;
                            break;
                        }
                        n4 = 137;
                        break;
                    }
                    case 1: {
                        n4 = (short)(0L + l2 - 1L);
                        break;
                    }
                    case 3: {
                        n4 = 134;
                        break;
                    }
                    case 7: {
                        if (l2 > 22L) {
                            throw new BinXMLException(this.err.getMessage0(35004));
                        }
                        n4 = (short)(96L + l2 - 1L);
                        break;
                    }
                    case 2: {
                        n4 = (short)(64L + l2 - 1L);
                        break;
                    }
                    case 6: {
                        if (n2 == 6) {
                            if (l2 != 4L) {
                                throw new BinXMLException(this.err.getMessage0(35004));
                            }
                            n4 = 125;
                            break;
                        }
                        if (n2 != 14) break;
                        if (l2 != 8L) {
                            throw new BinXMLException(this.err.getMessage0(35004));
                        }
                        n4 = 126;
                        break;
                    }
                    case 4: {
                        switch (n2) {
                            case 15: {
                                if (l2 != 1L) {
                                    throw new BinXMLException(this.err.getMessage0(35004));
                                }
                                n4 = 117;
                                break block5;
                            }
                            case 16: {
                                if (l2 != 2L) {
                                    throw new BinXMLException(this.err.getMessage0(35004));
                                }
                                n4 = 118;
                                break block5;
                            }
                            case 4: {
                                if (l2 != 1L && l2 != 2L && l2 != 4L) {
                                    throw new BinXMLException(this.err.getMessage0(35004));
                                }
                                n4 = (short)(117L + l2 / 2L);
                                break block5;
                            }
                            case 17: {
                                if (l2 != 1L && l2 != 2L && l2 != 4L && l2 != 8L) {
                                    throw new BinXMLException(this.err.getMessage0(35004));
                                }
                                if (l2 != 8L) {
                                    n4 = (short)(117L + l2 / 2L);
                                    break block5;
                                }
                                n4 = 120;
                                break block5;
                            }
                        }
                        throw new BinXMLException(this.err.getMessage0(35005));
                    }
                    case 20: {
                        switch (n2) {
                            case 18: {
                                if (l2 != 1L) {
                                    throw new BinXMLException(this.err.getMessage0(35004));
                                }
                                n4 = 121;
                                break block5;
                            }
                            case 19: {
                                if (l2 != 2L) {
                                    throw new BinXMLException(this.err.getMessage0(35004));
                                }
                                n4 = 122;
                                break block5;
                            }
                            case 20: {
                                if (l2 != 1L && l2 != 2L && l2 != 4L) {
                                    throw new BinXMLException(this.err.getMessage0(35004));
                                }
                                n4 = (short)(121L + l2 / 2L);
                                break block5;
                            }
                            case 21: {
                                if (l2 != 1L && l2 != 2L && l2 != 4L && l2 != 8L) {
                                    throw new BinXMLException(this.err.getMessage0(35004));
                                }
                                if (l2 != 8L) {
                                    n4 = (short)(121L + l2 / 2L);
                                    break block5;
                                }
                                n4 = 124;
                                break block5;
                            }
                        }
                        throw new BinXMLException(this.err.getMessage0(35005));
                    }
                    case 9: {
                        n4 = 132;
                        break;
                    }
                    case 8: {
                        n4 = 131;
                        break;
                    }
                    case 13: {
                        n4 = 135;
                        break;
                    }
                    default: {
                        throw new BinXMLException(this.err.getMessage0(35005));
                    }
                }
            }
            this.writer.writeOpcode((short)n4, false);
        } else if (l2 <= 16383L) {
            int n5 = (int)l2;
            this.writer.writeShort(n5 |= n3 == 1 ? 0 : 16384, false);
        } else {
            long l3 = l2;
            this.writer.writeLong8(l3 |= n3 == 1 ? 0L : 0x4000000000000000L, false);
        }
        switch (by) {
            case 4: {
                if (s <= 255) {
                    this.writer.writeByte(s, false);
                    break;
                }
                this.writer.writeShort(s, false);
                break;
            }
            case 1: {
                if (l <= 0xFFFFFFFFL) {
                    this.writer.writeLong4(l, false);
                    break;
                }
                this.writer.writeLong8(l, false);
                break;
            }
        }
        if (l2 > 0L) {
            this.writer.writeByteArray(byArray, false);
        }
    }

    void writeShortByteArray(int n, byte[] byArray, boolean bl) throws SAXException {
        try {
            this.writer.writeShort(n, bl);
            if (n != 0) {
                this.writer.writeByteArray(byArray, bl);
            }
        }
        catch (IOException iOException) {
            new SAXException(iOException);
        }
    }

    void writeText(String string) throws IOException {
        byte[] byArray = this.convTextToCSXString(string);
        int n = byArray.length;
        if (n <= 255) {
            this.writer.writeOpcode((short)163, false);
            this.writer.writeByte((byte)n, false);
        } else if (n <= 65535) {
            this.writer.writeOpcode((short)164, false);
            this.writer.writeShort(n, false);
        } else {
            this.writer.writeOpcode((short)165, false);
            this.writer.writeLong8(n, false);
        }
        this.writer.writeByteArray(byArray, false);
    }

    void writeCDATA(String string) throws IOException {
        byte[] byArray = this.convTextToCSXString(string);
        int n = byArray.length;
        if (n <= 255) {
            this.writer.writeOpcode((short)166, false);
            this.writer.writeByte((byte)n, false);
        } else if (n <= 65535) {
            this.writer.writeOpcode((short)167, false);
            this.writer.writeShort(n, false);
        } else {
            this.writer.writeOpcode((short)168, false);
            this.writer.writeLong8(n, false);
        }
        this.writer.writeByteArray(byArray, false);
        if (this.binXMLProcessor.getDebugMode()) {
            this.debugWriter.println("\t" + string);
            this.debugWriter.flush();
        }
    }

    void encodeSectionTokenSet(BinXMLSectionState binXMLSectionState, BinXMLStreamImpl binXMLStreamImpl) throws IOException, BinXMLException {
        BinXMLSectionState binXMLSectionState2 = new BinXMLSectionState(binXMLStreamImpl);
        byte[] byArray = binXMLStreamImpl.getWriteBuffer();
        binXMLSectionState2.encodeSectionHeader();
        Enumeration enumeration = binXMLSectionState.getNamespaceIdEnnumeration();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            this.encodeTokenSet(l, binXMLStreamImpl);
        }
        binXMLSectionState2.encodeSectionEnd();
        binXMLStreamImpl.flush();
    }

    void encodeNamespace(long l, String string) throws IOException, BinXMLException {
        byte[] byArray = this.convTextToCSXString(string);
        int n = byArray.length;
        if (n >= 65535) {
            throw new BinXMLException(this.err.getMessage0(35006));
        }
        if (n <= 255) {
            if (l < 0xFFFFFFFFL) {
                this.writer.writeOpcode((short)174, true);
                this.writer.writeByte((byte)n, true);
                this.writer.writeInt((int)l, true);
            } else {
                this.writer.writeOpcode((short)176, true);
                this.writer.writeByte((byte)n, true);
                this.writer.writeLong8(l, true);
            }
        } else if (l < 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)175, true);
            this.writer.writeShort(n, true);
            this.writer.writeInt((int)l, true);
        } else {
            this.writer.writeOpcode((short)177, true);
            this.writer.writeShort(n, true);
            this.writer.writeLong8(l, true);
        }
        this.writer.writeByteArray(byArray, true);
    }

    void encodeTokenSet(long l, BinXMLStreamImpl binXMLStreamImpl) throws IOException, BinXMLException {
        int n;
        BinXMLNamespaceToken binXMLNamespaceToken = this.tokenManager.getNamespaceToken(l);
        String string = binXMLNamespaceToken.getLocalName();
        if (string.length() <= 255) {
            this.writer.writeOpcode((short)174, true);
        } else {
            this.writer.writeOpcode((short)175, true);
        }
        BinXMLTokenList binXMLTokenList = this.tokenManager.getElementTokens(l);
        if (binXMLTokenList != null) {
            for (n = 0; n < binXMLTokenList.size(); ++n) {
                this.encodeToken((BinXMLQNameToken)binXMLTokenList.get(n), false);
            }
        }
        if ((binXMLTokenList = this.tokenManager.getAttrTokens(l)) != null) {
            for (n = 0; n < binXMLTokenList.size(); ++n) {
                this.encodeToken((BinXMLQNameToken)binXMLTokenList.get(n), true);
            }
        }
    }

    void encodeToken(BinXMLQNameToken binXMLQNameToken, boolean bl) throws IOException {
        long l = binXMLQNameToken.getTokenId();
        long l2 = binXMLQNameToken.getNamespaceId();
        String string = binXMLQNameToken.getLocalName();
        byte[] byArray = null;
        int n = 0;
        if (string != null) {
            byArray = string.getBytes("UTF-8");
            n = byArray.length;
        }
        if (n <= 255 && l <= 0xFFFFFFFFL && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)180, true);
            this.writer.writeByte((byte)n, true);
            this.writer.writeBoolean(bl, true);
            this.writer.writeLong4(l, true);
            this.writer.writeLong4(l2, true);
        } else if (l <= 0xFFFFFFFFL && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)181, true);
            this.writer.writeShort(n, true);
            this.writer.writeBoolean(bl, true);
            this.writer.writeLong4(l, true);
            this.writer.writeLong4(l2, true);
        } else if (n <= 255 && l <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)182, true);
            this.writer.writeByte((byte)n, true);
            this.writer.writeBoolean(bl, true);
            this.writer.writeLong4(l, true);
            this.writer.writeLong8(l2, true);
        } else if (l <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)183, true);
            this.writer.writeShort(n, true);
            this.writer.writeBoolean(bl, true);
            this.writer.writeLong4(l, true);
            this.writer.writeLong8(l2, true);
        } else if (n <= 255 && l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)184, true);
            this.writer.writeByte((byte)n, true);
            this.writer.writeBoolean(bl, true);
            this.writer.writeLong8(l, true);
            this.writer.writeLong4(l2, true);
        } else if (l2 <= 0xFFFFFFFFL) {
            this.writer.writeOpcode((short)185, true);
            this.writer.writeShort(n, true);
            this.writer.writeBoolean(bl, true);
            this.writer.writeLong8(l, true);
            this.writer.writeLong4(l2, true);
        } else if (n <= 255) {
            this.writer.writeOpcode((short)186, true);
            this.writer.writeByte((byte)n, true);
            this.writer.writeBoolean(bl, true);
            this.writer.writeLong8(l, true);
            this.writer.writeLong8(l2, true);
        } else {
            this.writer.writeOpcode((short)187, true);
            this.writer.writeShort(n, true);
            this.writer.writeBoolean(bl, true);
            this.writer.writeLong8(l, true);
            this.writer.writeLong8(l2, true);
        }
        if (n > 0) {
            this.writer.writeByteArray(byArray, true);
        }
    }

    private void writeSchemaScopeStart(BinXMLSchema binXMLSchema) throws IOException {
        byte[] byArray = binXMLSchema.getSchemaId().getVocabID();
        int n = binXMLSchema.getSchemaVer();
        if (n <= 255) {
            this.writer.writeOpcode((short)145, true);
            this.writer.writeByte(byArray.length, true);
            this.writer.writeByte(n, true);
            if (this.binXMLProcessor.getDebugMode()) {
                this.debugWriter.println("\tSCHSST1");
                this.debugWriter.flush();
            }
        } else {
            this.writer.writeOpcode((short)146, true);
            this.writer.writeByte(byArray.length, true);
            this.writer.writeInt(n, true);
            if (this.binXMLProcessor.getDebugMode()) {
                this.debugWriter.println("\tSCHSST4");
                this.debugWriter.flush();
            }
        }
        this.writer.writeByteArray(byArray, true);
    }

    byte[] convTextToQName(String string, BinXMLProperty binXMLProperty, BinXMLSectionState binXMLSectionState) throws BinXMLException, IOException {
        long l;
        BinXMLQNameToken binXMLQNameToken;
        String string2 = XMLUtil.getPrefix(string);
        String string3 = XMLUtil.getLocalName(string);
        String string4 = this.validator.resolve(string2);
        if (string4 != null && string4.equals("")) {
            string4 = null;
        }
        if ((binXMLQNameToken = this.tokenManager.getAttrToken(string3, l = string4 == null ? 7L : this.tokenManager.getNamespaceTokenId(string4), string4)) == null) {
            binXMLQNameToken = this.tokenManager.putAttr(string3, l);
            this.encodeToken(binXMLQNameToken, true);
        }
        long l2 = binXMLQNameToken.getTokenId();
        binXMLSectionState.addNamespaceId(new Long(l));
        int n = binXMLSectionState.getPfxId(string2, l, true);
        int n2 = 8;
        if (l >= 0xFFFFFFFFL) {
            n2 = 12;
        }
        byte[] byArray = new byte[n2];
        if (n2 == 8) {
            byArray[0] = 4;
            this.writer.copyLong4ToArray(l2, byArray, 1);
        } else {
            byArray[0] = 4;
            this.writer.copyLong8ToArray(l2, byArray, 1);
        }
        if (string2 != null && !string2.equals("")) {
            byArray[n2 - 3] = 2;
            byArray[n2 - 1] = (byte)(n & 0xFF);
            byArray[n2 - 2] = (byte)((n >>= 8) & 0xFF);
        } else {
            byArray[n2 - 3] = 0;
        }
        return byArray;
    }

    byte[] convTextToCSXString(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    byte[] convTextToCSX(String string, int n, int n2, BinXMLProperty binXMLProperty) throws BinXMLException {
        byte[] byArray = null;
        block4 : switch (n2) {
            case 12: {
                int n3 = binXMLProperty.getEnumID(string.trim());
                if (n3 < 255) {
                    byArray = new byte[]{(byte)n3};
                    break;
                }
                byArray = new byte[2];
                this.writer.copyInt2ToArray(n3, byArray, 0);
                break;
            }
            case 3: {
                byArray = new byte[1];
                boolean bl = Boolean.getBoolean(string);
                if (bl) {
                    byArray[0] = 1;
                    break;
                }
                byArray[0] = 0;
                break;
            }
            case 7: {
                int n4 = 0;
                if (string.trim().indexOf(46) >= 0) {
                    n4 = string.length() - 1 - string.indexOf(46);
                }
                try {
                    NUMBER nUMBER = new NUMBER(string, n4);
                    byArray = nUMBER.toBytes();
                }
                catch (SQLException sQLException) {
                    byArray = this.convTextToCSXString(string);
                }
                break;
            }
            case 2: {
                switch (n) {
                    case 22: {
                        byArray = BinXMLUtil.convHexStringToBytes(string);
                        break block4;
                    }
                    case 23: {
                        byArray = BinXMLUtil.convBase64StringToBytes(string);
                        break block4;
                    }
                }
                throw new BinXMLException(this.err.getMessage0(35007));
            }
            case 6: {
                switch (n) {
                    case 6: {
                        int n5 = Float.floatToRawIntBits(Float.parseFloat(string));
                        byArray = new byte[4];
                        this.writer.copyRInt4ToArray(n5, byArray, 0);
                        break block4;
                    }
                    case 14: {
                        long l = Double.doubleToRawLongBits(Double.parseDouble(string));
                        byArray = new byte[8];
                        this.writer.copyRLong8ToArray(l, byArray, 0);
                        break block4;
                    }
                }
                throw new BinXMLException(this.err.getMessage0(35007));
            }
            case 4: 
            case 20: {
                switch (n) {
                    case 4: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        try {
                            int n6 = Integer.parseInt(string);
                            if (n6 < 255) {
                                byArray = new byte[]{(byte)n6};
                                break block4;
                            }
                            if (n6 < 65535) {
                                byArray = new byte[2];
                                this.writer.copyInt2ToArray(n6, byArray, 0);
                                break block4;
                            }
                            byArray = new byte[4];
                            this.writer.copyInt4ToArray(n6, byArray, 0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                long l = Long.parseLong(string);
                                byArray = new byte[8];
                                this.writer.copyLong8ToArray(l, byArray, 0);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                BigInteger bigInteger = new BigInteger(string);
                                byArray = bigInteger.toByteArray();
                            }
                        }
                        break block4;
                    }
                }
                throw new BinXMLException(this.err.getMessage0(35007));
            }
            case 9: {
                if (this.tokenManager.metaProvider == null || !(this.tokenManager.metaProvider instanceof DBBinXMLMetadataProviderImpl)) break;
                Connection connection = ((DBBinXMLMetadataProviderImpl)this.tokenManager.metaProvider).getConnection();
                try {
                    TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ(connection, string);
                    byArray = tIMESTAMPTZ.toBytes();
                }
                catch (SQLException sQLException) {
                    byArray = this.convTextToCSXString(string);
                }
                break;
            }
            default: {
                throw new BinXMLException(this.err.getMessage0(35007));
            }
        }
        return byArray;
    }

    void setXMLVersion(String string) {
        this.xmlVersion = string;
    }

    void setXMLError(oracle.xml.util.XMLError xMLError) {
        this.err = xMLError;
    }

    void setStandalone(String string) {
        this.standalone = string;
    }

    void setEncoding(String string) {
        this.encoding = string;
    }

    private short getSpaceId(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        Integer n = (Integer)this.spcTable.get(string);
        if (n == null) {
            return -1;
        }
        return (short)n.intValue();
    }

    private void initSpaceTable() {
        int n;
        char[] cArray = new char[256];
        cArray[0] = 10;
        for (n = 1; n <= 127; ++n) {
            cArray[n] = 32;
        }
        this.spcTable = new HashMap(100);
        for (n = 1; n <= 127; ++n) {
            String string = new String(cArray, 0, n);
            this.spcTable.put(string, new Integer(n));
        }
    }

    private void writeSpace(String string, int n) {
        try {
            if (n <= 31) {
                this.writer.writeOpcode((short)234, false);
                this.writer.writeByte((byte)((n |= 0) & 0xFF), false);
            } else {
                this.writer.writeOpcode((short)235, false);
                this.writer.writeShort((short)((n |= 0) & 0xFFFF), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeCRSpace(String string, int n) {
        try {
            if (n <= 31) {
                this.writer.writeOpcode((short)234, false);
                this.writer.writeByte((byte)((n |= 0x80) & 0xFF), false);
            } else {
                this.writer.writeOpcode((short)235, false);
                this.writer.writeShort((short)((n |= 0x8000) & 0xFFFF), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String writeSpaceStrings(String string) {
        char[] cArray = string.toCharArray();
        return this.writeSpaceStrings(cArray, 0, cArray.length);
    }

    private String writeSpaceStrings(char[] cArray, int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n + n2;
        int n6 = n5 - 1;
        int n7 = 0;
        for (n3 = n; n3 < n5; ++n3) {
            if (cArray[n3] == ' ') continue;
            int n8 = n3 - n4;
            if (n8 > 0) {
                if (n7 > 0) {
                    this.writeCRSpace(new String(cArray, n4, n8), n8);
                } else if (n8 > 2 || cArray[n3] == '\n') {
                    this.writeSpace(new String(cArray, n4, n8), n8);
                } else {
                    return new String(cArray, n4, n5 - n4);
                }
                n4 = n3;
                n7 = 0;
            }
            if (cArray[n3] == '\n') {
                ++n7;
                continue;
            }
            return new String(cArray, n4, n5 - n4);
        }
        if (n4 <= n6) {
            n3 = n5 - n4;
            if (n7 > 0) {
                this.writeCRSpace(new String(cArray, n4, n3), n3);
            } else {
                this.writeSpace(new String(cArray, n4, n3), n3);
            }
        }
        return null;
    }

    private class BinXMLSectionState {
        BinXMLStreamImpl binStream;
        Vector nsTokenIds;
        HashMap elemTokenIds;
        HashMap attrTokenIds;
        Vector prefixMap;
        short nextPfxId = (short)65;

        BinXMLSectionState(BinXMLStreamImpl binXMLStreamImpl) {
            this.binStream = binXMLStreamImpl;
        }

        void encodeSectionHeader() throws IOException {
            if (!BinXMLEncoderImpl.this.inlineTokenDefs) {
                this.nsTokenIds = new Vector(5);
            }
            byte by = 0;
            BinXMLEncoderImpl.this.writer.writeOpcode((short)159, true);
            BinXMLEncoderImpl.this.writer.writeByte(1, true);
            if (!BinXMLEncoderImpl.this.inlineTokenDefs) {
                by = (byte)(by | 1);
            }
            if (!BinXMLEncoderImpl.this.schemaAware) {
                by = (byte)(by | 2);
            }
            if (BinXMLEncoderImpl.this.binXMLProcessor.getGUID() != null) {
                by = (byte)(by | 4);
            }
            if (BinXMLEncoderImpl.this.docId != null) {
                by = (byte)(by | 8);
            }
            if (BinXMLEncoderImpl.this.standalone != null) {
                by = (byte)(by | 0x40);
                if (BinXMLEncoderImpl.this.standalone.equalsIgnoreCase("yes")) {
                    by = (byte)(by | 0x80);
                }
            }
            if (BinXMLEncoderImpl.this.encoding != null) {
                by = (byte)(by | 0x100);
            }
            BinXMLEncoderImpl.this.writer.writeByte(by, true);
            if (BinXMLEncoderImpl.this.docId != null) {
                BinXMLEncoderImpl.this.writer.writeByte((byte)BinXMLEncoderImpl.this.docId.length, true);
                BinXMLEncoderImpl.this.writer.writeByteArray(BinXMLEncoderImpl.this.docId, true);
            }
            if (BinXMLEncoderImpl.this.binXMLProcessor.getGUID() != null) {
                BinXMLEncoderImpl.this.writer.writeByteArray(BinXMLEncoderImpl.this.binXMLProcessor.getGUID(), true);
            }
        }

        void encodeSectionEnd() throws IOException {
            if (BinXMLEncoderImpl.this.schemaAware) {
                BinXMLEncoderImpl.this.writer.writeOpcode((short)148, false);
            }
            BinXMLEncoderImpl.this.writer.writeOpcode((short)160, false);
            BinXMLEncoderImpl.this.writer.flushToStream();
        }

        boolean addNamespaceId(Long l) {
            if (!BinXMLEncoderImpl.this.inlineTokenDefs && !this.nsTokenIds.contains(l)) {
                this.nsTokenIds.add(l);
                return true;
            }
            return false;
        }

        Enumeration getNamespaceIdEnnumeration() {
            return this.nsTokenIds.elements();
        }

        short getReservedPrefixId(String string, long l) {
            if (l > 6L) {
                return -1;
            }
            switch ((int)l) {
                case 1: {
                    if (!string.equals("xml")) break;
                    return 1;
                }
                case 2: {
                    if (!string.equals("xmlns")) break;
                    return 2;
                }
                case 3: {
                    if (!string.equals("xsi")) break;
                    return 3;
                }
                case 4: {
                    if (string.equals("xsd")) {
                        return 4;
                    }
                    if (!string.equals("xs")) break;
                    return 5;
                }
                case 5: {
                    if (!string.equals("csx")) break;
                    return 6;
                }
            }
            return -1;
        }

        boolean addElemToken(BinXMLQNameToken binXMLQNameToken) {
            Long l = new Long(binXMLQNameToken.getTokenId());
            if (this.elemTokenIds.get(l) != null) {
                return false;
            }
            this.elemTokenIds.put(l, binXMLQNameToken);
            return true;
        }

        short insertPrefix(String string, String string2) throws IOException, BinXMLException {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            long l = string2 == null || string2.length() == 0 ? 7L : BinXMLEncoderImpl.this.tokenManager.getNamespaceTokenId(string2);
            for (n = BinXMLEncoderImpl.this.depth; n > 0; --n) {
                if (this.prefixMap != null) {
                    for (int i = this.prefixMap.size() - 1; i >= 0; --i) {
                        BinXMLPrefix binXMLPrefix = (BinXMLPrefix)this.prefixMap.elementAt(i);
                        if (binXMLPrefix.nspid != l) continue;
                        if (binXMLPrefix.pfx.equals(string)) {
                            bl = true;
                            break;
                        }
                        bl2 = true;
                        if (i != BinXMLEncoderImpl.this.depth - 1) continue;
                        binXMLPrefix.dup = true;
                    }
                    if (!bl) continue;
                    break;
                }
                this.prefixMap = new Vector();
            }
            BinXMLPrefix binXMLPrefix = new BinXMLPrefix();
            binXMLPrefix.pfx = string;
            binXMLPrefix.nsuri = string2;
            binXMLPrefix.nspid = l;
            binXMLPrefix.dup = bl2;
            binXMLPrefix.pfxid = this.getReservedPrefixId(string, l);
            if (binXMLPrefix.pfxid < 0) {
                short s = this.nextPfxId;
                this.nextPfxId = (short)(s + 1);
                binXMLPrefix.pfxid = s;
            }
            if (binXMLPrefix.pfxid < 0) {
                throw new BinXMLException("Maximum number of namespace prefix exceeded");
            }
            this.prefixMap.add(binXMLPrefix);
            binXMLPrefix.writePrefixDef();
            return binXMLPrefix.pfxid;
        }

        short getPfxId(String string, long l, boolean bl) {
            boolean bl2 = false;
            if (this.prefixMap == null) {
                return -1;
            }
            for (int i = this.prefixMap.size() - 1; i >= 0; --i) {
                BinXMLPrefix binXMLPrefix = (BinXMLPrefix)this.prefixMap.elementAt(i);
                if (binXMLPrefix.nspid != l) continue;
                if (!binXMLPrefix.dup && !bl) {
                    return -1;
                }
                if (binXMLPrefix.pfx.equals(string)) {
                    return binXMLPrefix.pfxid;
                }
                bl2 = true;
            }
            return -1;
        }
    }

    private class BinXMLPrefix {
        String pfx;
        String nsuri;
        long nspid;
        short pfxid;
        boolean dup;

        private BinXMLPrefix() {
        }

        private void writePrefixDef() throws IOException {
            boolean bl = this.nspid <= 0xFFFFFFFFL;
            byte[] byArray = null;
            int n = 0;
            if (this.pfx != null) {
                byArray = this.pfx.getBytes("UTF-8");
                n = byArray.length;
            }
            BinXMLEncoderImpl.this.writer.writeOpcode(bl ? (short)178 : 179, true);
            BinXMLEncoderImpl.this.writer.writeByte(n, true);
            if (bl) {
                BinXMLEncoderImpl.this.writer.writeLong4(this.nspid, true);
            } else {
                BinXMLEncoderImpl.this.writer.writeLong8(this.nspid, true);
            }
            BinXMLEncoderImpl.this.writer.writeShort(this.pfxid, true);
            if (n > 0) {
                BinXMLEncoderImpl.this.writer.writeByteArray(byArray, true);
            }
        }
    }

    private class BinXMLEncBuffer {
        byte state = (byte)2;
        long qnameid;
        boolean needpfxid;
        boolean arrayMode;
        short pfxid;
        byte flag;
        boolean needtypeid;
        int xsitypeid;
        String textdata;

        BinXMLEncBuffer(long l, boolean bl, boolean bl2, short s, byte by, boolean bl3, int n) {
            this.qnameid = l;
            this.flag = by;
            this.needpfxid = bl;
            this.pfxid = s;
            this.arrayMode = bl2;
            this.needtypeid = bl3;
            this.xsitypeid = n;
        }

        void flush() throws IOException, BinXMLException {
            BinXMLElement binXMLElement = (BinXMLElement)BinXMLEncoderImpl.this.elementStack.peek();
            BinXMLProperty binXMLProperty = binXMLElement.prop;
            BinXMLElement binXMLElement2 = null;
            if (BinXMLEncoderImpl.this.depth > 1) {
                binXMLElement2 = (BinXMLElement)BinXMLEncoderImpl.this.elementStack.get(BinXMLEncoderImpl.this.depth - 2);
            }
            switch (this.state) {
                case 1: {
                    return;
                }
                case 2: 
                case 3: {
                    boolean bl = false;
                    if (this.arrayMode) {
                        BinXMLEncoderImpl.this.writeELMST();
                        bl = true;
                    } else if (binXMLElement2 != null && binXMLElement2.schemaSeqMode) {
                        short s = binXMLElement2.maxKidNum;
                        if (!(binXMLElement.any || binXMLProperty == null || binXMLElement.kidNum <= binXMLElement2.kidNum || binXMLElement.kidNum > s || this.needpfxid || this.needtypeid || binXMLElement.prop.isSubstitutionGroupMember())) {
                            for (int i = 1; i < binXMLElement.kidNum - binXMLElement2.kidNum; ++i) {
                                BinXMLEncoderImpl.this.writer.writeOpcode((short)144, false);
                            }
                            BinXMLEncoderImpl.this.writeELMST();
                            bl = true;
                            binXMLElement2.kidNum = binXMLElement.kidNum;
                            break;
                        }
                        BinXMLEncoderImpl.this.writer.writeOpcode((short)218, false);
                    }
                    if (!bl) {
                        if (binXMLProperty != null && BinXMLEncoderImpl.this.depth != 1 && !binXMLElement.any && !binXMLProperty.isSubstitutionGroupMember()) {
                            BinXMLEncoderImpl.this.writeNodeStartKidnum(BinXMLEncoderImpl.this.currentElem.kidNum, this.flag, this.needpfxid, this.pfxid, this.needtypeid, this.xsitypeid);
                        } else {
                            BinXMLEncoderImpl.this.writeElementAttrStart(this.qnameid, this.needpfxid, this.flag, this.pfxid, this.needtypeid, this.xsitypeid);
                        }
                    }
                    if (this.state != 3) break;
                    if (!BinXMLEncoderImpl.this.schemaAware) {
                        char[] cArray = this.textdata.toCharArray();
                        if (BinXMLUtil.isPureWhiteSpace(cArray, 0, cArray.length)) {
                            BinXMLEncoderImpl.this.writeWhiteSpace(cArray, 0, cArray.length);
                        } else {
                            BinXMLEncoderImpl.this.writeText(this.textdata);
                        }
                    } else {
                        BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2 != null ? binXMLElement2.prop : null, binXMLProperty, BinXMLEncoderImpl.this.currentElem.kidNum, this.textdata, (byte)3);
                    }
                    this.textdata = null;
                    break;
                }
                case 4: {
                    if (this.arrayMode) {
                        BinXMLEncoderImpl.this.writeSimpleNode(0L, null, null, (short)0, this.textdata, (byte)2);
                        break;
                    }
                    if (binXMLElement2 != null && binXMLElement2.schemaSeqMode) {
                        short s = binXMLElement2.maxKidNum;
                        if (!(binXMLElement.any || binXMLElement.prop == null || binXMLElement.kidNum <= binXMLElement2.kidNum || binXMLElement.kidNum > s || this.needpfxid || this.needtypeid || binXMLElement.prop.isSubstitutionGroupMember())) {
                            for (int i = 1; i < binXMLElement.kidNum - binXMLElement2.kidNum; ++i) {
                                BinXMLEncoderImpl.this.writer.writeOpcode((short)144, false);
                            }
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2.prop, binXMLElement.prop, binXMLElement.kidNum, this.textdata, (byte)5);
                            binXMLElement2.kidNum = binXMLElement.kidNum;
                            break;
                        }
                        BinXMLEncoderImpl.this.writer.writeOpcode((short)218, false);
                        if (binXMLElement.prop != null && BinXMLEncoderImpl.this.depth != 1 && !binXMLElement.any && !binXMLElement.prop.isSubstitutionGroupMember()) {
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, binXMLElement2.prop, binXMLElement.prop, binXMLElement.kidNum, this.textdata, (byte)4);
                        } else {
                            BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, null, null, (short)0, this.textdata, (byte)1);
                        }
                        this.textdata = null;
                        break;
                    }
                    BinXMLEncoderImpl.this.writeSimpleNode(this.qnameid, null, null, (short)0, this.textdata, (byte)1);
                }
            }
            this.state = 1;
        }
    }

    private class BinXMLElement {
        long qnameId;
        BinXMLSchema binSchema;
        BinXMLProperty prop;
        int propId;
        boolean any;
        boolean arrayMode = false;
        boolean firstChild = true;
        long prevChildQnameId;
        BinXMLProperty prevChildProp;
        byte prevChildFlag;
        short prevChildPfxId;
        int prevChildTypeId;
        boolean schemaSeqMode = false;
        short kidNum = 0;
        short maxKidNum;
    }

    private class BinXMLPageWriter {
        boolean chunkmode = false;
        int chunk_size = 4096;
        private static final int DOC_PLUS_STRTSEC_SIZE = 7;
        int tokdefpos = 0;
        int noddatpos = 0;
        byte[] tokdefbuf;
        byte[] noddatbuf;
        boolean chunkrefflag = false;
        short lastopcode = (short)-1;
        int lasttokdefpos = 0;
        int lastnoddatpos = 0;
        byte[] buf;
        BinXMLStreamImpl bstream;
        int writePos;

        BinXMLPageWriter(byte[] byArray, BinXMLStreamImpl binXMLStreamImpl) {
            this.buf = byArray;
            this.bstream = binXMLStreamImpl;
            this.writePos = 0;
        }

        void chunk_init() {
            if (this.chunkmode) {
                this.tokdefbuf = new byte[this.chunk_size];
                this.noddatbuf = new byte[this.chunk_size];
                this.tokdefpos = 0;
                this.noddatpos = 0;
                this.chunkrefflag = false;
                this.lastopcode = (short)-1;
                this.lasttokdefpos = 0;
                this.lastnoddatpos = 0;
            }
        }

        void setChunkMode(boolean bl) {
            this.chunkmode = bl;
            this.chunk_init();
        }

        void setChunkBufSize(int n) {
            if (n >= 4096) {
                this.chunk_size = n;
            }
        }

        void flushToStream() throws IOException {
            if (this.chunkmode) {
                int n = this.flushInChunkMode(false);
                this.bstream.flushWriBuffer(n);
            } else {
                this.bstream.flushWriBuffer(this.writePos);
            }
        }

        void flushByte(byte by, boolean bl) throws IOException {
            if (this.chunkmode) {
                int n = !this.chunkrefflag ? this.chunk_size - 13 : this.chunk_size - 6;
                if (this.tokdefpos + this.noddatpos == n) {
                    int n2 = this.flushInChunkMode(true);
                    this.bstream.flushWriBuffer(n2);
                }
                if (bl) {
                    this.tokdefbuf[this.tokdefpos++] = by;
                } else {
                    this.noddatbuf[this.noddatpos++] = by;
                }
            } else {
                if (this.writePos == BinaryStream.BUFSIZE) {
                    this.bstream.flushWriBuffer();
                    this.writePos = 0;
                }
                this.buf[this.writePos++] = by;
            }
        }

        private int flushInChunkMode(boolean bl) throws IOException {
            int n = bl ? this.lasttokdefpos + this.lastnoddatpos : this.tokdefpos + this.noddatpos;
            this.writeChunkHeader(this.chunkrefflag, n);
            this.mergeTokDefNodDat(this.chunkrefflag, this.tokdefpos, this.noddatpos, this.lasttokdefpos, this.lastnoddatpos);
            int n2 = this.tokdefpos - this.lasttokdefpos;
            int n3 = this.noddatpos - this.lastnoddatpos;
            if (n3 == 1 && this.lastopcode == 160) {
                n3 = 0;
            }
            if (n3 > 0) {
                this.noddatbuf = this.collectRemainingData(this.lastnoddatpos, this.noddatpos, this.noddatbuf);
            }
            this.noddatpos = n3;
            if (n2 > 0) {
                this.tokdefbuf = this.collectRemainingData(this.lasttokdefpos, this.tokdefpos, this.tokdefbuf);
            }
            this.tokdefpos = n2;
            this.chunkrefflag = true;
            int n4 = this.writePos;
            this.writePos = 0;
            return n4;
        }

        private byte[] collectRemainingData(int n, int n2, byte[] byArray) {
            byte[] byArray2 = new byte[this.chunk_size];
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                byArray2[n3++] = byArray[i];
            }
            return byArray2;
        }

        private void writeChunkHeader(boolean bl, int n) throws IOException {
            if (!bl) {
                System.arraycopy(this.tokdefbuf, 0, this.buf, 0, 7);
                this.writePos = 7;
            } else {
                this.writePos = 0;
            }
            this.buf[this.writePos++] = -95;
            byte by = bl ? (byte)1 : 0;
            this.buf[this.writePos++] = by;
            byte by2 = (byte)(n >>> 24 & 0xFF);
            byte by3 = (byte)(n >>> 16 & 0xFF);
            byte by4 = (byte)(n >>> 8 & 0xFF);
            byte by5 = (byte)(n >>> 0 & 0xFF);
            this.buf[this.writePos++] = by2;
            this.buf[this.writePos++] = by3;
            this.buf[this.writePos++] = by4;
            this.buf[this.writePos++] = by5;
        }

        private void mergeTokDefNodDat(boolean bl, int n, int n2, int n3, int n4) {
            if (!bl) {
                int n5 = n3;
                int n6 = n4;
                if (this.lastopcode == 160) {
                    n5 = n;
                    n6 = n2;
                }
                System.arraycopy(this.tokdefbuf, 7, this.buf, this.writePos, n5 - 7);
                this.writePos += n5 - 7;
                System.arraycopy(this.noddatbuf, 0, this.buf, this.writePos, n6);
                this.writePos += n6;
            } else if (this.lastopcode == 160) {
                System.arraycopy(this.tokdefbuf, 0, this.buf, this.writePos, n);
                this.writePos += n;
                System.arraycopy(this.noddatbuf, 0, this.buf, this.writePos, n2);
                this.writePos += n2;
            } else {
                System.arraycopy(this.tokdefbuf, 0, this.buf, this.writePos, n3);
                this.writePos += n3;
                System.arraycopy(this.noddatbuf, 0, this.buf, this.writePos, n4);
                this.writePos += n4;
            }
        }

        void writeByte(int n, boolean bl) throws IOException {
            this.flushByte((byte)(n & 0xFF), bl);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeBoolean(boolean bl, boolean bl2) throws IOException {
            this.flushByte((byte)(bl ? 1 : 0), bl2);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + bl);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeShort(int n, boolean bl) throws IOException {
            this.flushByte((byte)(n >>> 8 & 0xFF), bl);
            this.flushByte((byte)(n >>> 0 & 0xFF), bl);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeOpcode(short s, boolean bl) throws IOException {
            this.lastopcode = s;
            this.lasttokdefpos = this.tokdefpos;
            this.lastnoddatpos = this.noddatpos;
            if (s < 255) {
                this.flushByte((byte)s, bl);
            } else {
                this.flushByte((byte)(s >>> 8 & 0xFF), bl);
                this.flushByte((byte)(s >>> 0 & 0xFF), bl);
            }
            BinXMLOpcode binXMLOpcode = BinXMLFormat.opcodes[s];
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.print(bl);
                BinXMLEncoderImpl.this.debugWriter.print(' ');
                BinXMLEncoderImpl.this.debugWriter.println(binXMLOpcode.name);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeByteArray(byte[] byArray, boolean bl) throws IOException {
            if (byArray == null) {
                return;
            }
            for (int i = 0; i < byArray.length; ++i) {
                this.flushByte(byArray[i], bl);
            }
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + new String(byArray));
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeInt(int n, boolean bl) throws IOException {
            this.flushByte((byte)(n >>> 24 & 0xFF), bl);
            this.flushByte((byte)(n >>> 16 & 0xFF), bl);
            this.flushByte((byte)(n >>> 8 & 0xFF), bl);
            this.flushByte((byte)(n >>> 0 & 0xFF), bl);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + n);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeLong4(long l, boolean bl) throws IOException {
            byte[] byArray = new byte[4];
            this.copyLong4ToArray(l, byArray, 0);
            this.writeByteArray(byArray, bl);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + l);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void writeLong8(long l, boolean bl) throws IOException {
            byte[] byArray = new byte[8];
            this.copyLong8ToArray(l, byArray, 0);
            this.writeByteArray(byArray, bl);
            if (BinXMLEncoderImpl.this.binXMLProcessor.getDebugMode()) {
                BinXMLEncoderImpl.this.debugWriter.println("\t" + l);
                BinXMLEncoderImpl.this.debugWriter.flush();
            }
        }

        void copyByteArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
            while (n2 > 0) {
                byArray2[n3++] = byArray[n++];
                --n2;
            }
        }

        void copyInt2ToArray(int n, byte[] byArray, int n2) {
            byArray[n2 + 1] = (byte)(n & 0xFF);
            byArray[n2] = (byte)((n >>= 8) & 0xFF);
        }

        void copyRInt4ToArray(int n, byte[] byArray, int n2) {
            byArray[n2++] = (byte)(n & 0xFF);
            byArray[n2++] = (byte)((n >>= 8) & 0xFF);
            byArray[n2++] = (byte)((n >>= 8) & 0xFF);
            byArray[n2] = (byte)((n >>= 8) & 0xFF);
        }

        void copyInt4ToArray(int n, byte[] byArray, int n2) {
            n2 += 3;
            byArray[n2--] = (byte)(n & 0xFF);
            byArray[n2--] = (byte)((n >>= 8) & 0xFF);
            byArray[n2--] = (byte)((n >>= 8) & 0xFF);
            byArray[n2] = (byte)((n >>= 8) & 0xFF);
        }

        void copyLong4ToArray(long l, byte[] byArray, int n) {
            n += 3;
            byArray[n--] = (byte)(l & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n] = (byte)((l >>= 8) & 0xFFL);
        }

        void copyRLong8ToArray(long l, byte[] byArray, int n) {
            byArray[n++] = (byte)(l & 0xFFL);
            byArray[n++] = (byte)((l >>= 8) & 0xFFL);
            byArray[n++] = (byte)((l >>= 8) & 0xFFL);
            byArray[n++] = (byte)((l >>= 8) & 0xFFL);
            byArray[n++] = (byte)((l >>= 8) & 0xFFL);
            byArray[n++] = (byte)((l >>= 8) & 0xFFL);
            byArray[n++] = (byte)((l >>= 8) & 0xFFL);
            byArray[n] = (byte)((l >>= 8) & 0xFFL);
        }

        void copyLong8ToArray(long l, byte[] byArray, int n) {
            n += 7;
            byArray[n--] = (byte)(l & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n--] = (byte)((l >>= 8) & 0xFFL);
            byArray[n] = (byte)((l >>= 8) & 0xFFL);
        }
    }
}

