/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLSchemaAnnotator;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.util.XMLError;
import org.w3c.dom.NodeList;

public class BinXMLSchema
implements BinXMLConstants,
XSDConstantValues {
    boolean debug = false;
    BinXMLSchemaAnnotator annotator;
    Vector properties = new Vector(100, 50);
    HashMap idprops = new HashMap(100, 0.5f);
    HashMap idtypes = new HashMap(100, 0.5f);
    BinXMLProperty rootprop;
    BinXMLVocabId sVocabID;
    XSDValidator validator;
    XMLSchema xmlschema;
    XMLError err;
    BinXMLMetadataProvider metaProvider;

    BinXMLSchema() {
        this.init();
    }

    BinXMLSchema(URL uRL) {
        this.init();
        this.annotator.setSchemaURL(uRL);
    }

    BinXMLSchema(URL uRL, Reader reader) {
        this.init();
        this.annotator.setSchemaURL(uRL);
        this.annotator.setSchemaReader(reader);
    }

    BinXMLSchema(Reader[] readerArray) {
        this.init();
        this.annotator.setSchemaReaders(readerArray);
    }

    void setMetadataProvider(BinXMLMetadataProvider binXMLMetadataProvider) {
        this.metaProvider = binXMLMetadataProvider;
        if (this.annotator != null) {
            this.annotator.setMetadataProvider(binXMLMetadataProvider);
        }
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
        if (this.annotator != null) {
            this.annotator.setXMLError(xMLError);
        }
    }

    void setXMLSchema(XMLSchema xMLSchema) {
        this.xmlschema = xMLSchema;
    }

    void setDebugMode(boolean bl) {
        this.debug = bl;
        this.annotator.setDebugMode(bl);
    }

    boolean getDebugMode() {
        return this.debug;
    }

    BinXMLSchemaAnnotator getSchemaAnnotator() {
        return this.annotator;
    }

    public void setValidator(XSDValidator xSDValidator) {
        this.validator = xSDValidator;
    }

    XSDValidator getValidator() {
        return this.validator;
    }

    BinXMLProperty getAttrProperty(String string, String string2) throws BinXMLException {
        XSDNode xSDNode = this.validator.getTypeDefinition();
        if (xSDNode == null || xSDNode instanceof XSDSimpleType) {
            return null;
        }
        XSDAttribute xSDAttribute = ((XSDComplexType)xSDNode).getAttributeDeclaration(string, string2);
        if (xSDAttribute == null) {
            return null;
        }
        return this.locateProperty(xSDAttribute);
    }

    public BinXMLProperty getCurrentProperty() {
        XSDElement xSDElement = this.validator.getElementDeclaration();
        if (xSDElement == null) {
            return null;
        }
        BinXMLProperty binXMLProperty = this.locateProperty(xSDElement);
        if (binXMLProperty != null) {
            return binXMLProperty;
        }
        binXMLProperty = this.getRefProperty(xSDElement);
        binXMLProperty.setBinXMLSchema(this);
        return binXMLProperty;
    }

    public BinXMLProperty getCurrentTypeProperty() {
        XSDNode xSDNode = this.validator.getTypeDefinition();
        if (xSDNode == null) {
            return null;
        }
        return this.locateProperty(xSDNode);
    }

    private BinXMLProperty getRefProperty(XSDElement xSDElement) {
        String string = xSDElement.getRefLocalname();
        String string2 = xSDElement.getRefNamespace();
        XSDNode xSDNode = xSDElement.getType();
        for (int i = 0; i < this.properties.size(); ++i) {
            BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
            XSDNode xSDNode2 = binXMLProperty.getXSDNode();
            if (!(xSDNode2 instanceof XSDElement) || !binXMLProperty.getQName().getLocalPart().equals(string) || !binXMLProperty.getQName().getNamespaceURI().equals(string2) || ((XSDElement)xSDNode2).getType() != xSDNode) continue;
            return binXMLProperty;
        }
        return null;
    }

    public XMLSchema getXMLSchema() {
        return this.xmlschema;
    }

    private void init() {
        this.annotator = new BinXMLSchemaAnnotator();
        this.annotator.setBinXMLSchema(this);
        this.annotator.setXMLError(this.err);
    }

    Vector getBinXMLProperties() {
        return this.properties;
    }

    void annotate(String[] stringArray) {
        XMLDocument xMLDocument;
        try {
            xMLDocument = this.annotator.processBinXMLSchemaAnnotations(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            xMLDocument = null;
        }
        if (this.debug) {
            try {
                if (xMLDocument != null) {
                    xMLDocument.print(System.out);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    BinXMLVocabId getSchemaId() {
        return this.sVocabID;
    }

    void setSchemaId(BinXMLVocabId binXMLVocabId) {
        this.sVocabID = binXMLVocabId;
    }

    int getSchemaVer() {
        return 0;
    }

    public BinXMLProperty getRootElemProperty() {
        return this.rootprop;
    }

    void setRootElemProperty(BinXMLProperty binXMLProperty) {
        this.rootprop = binXMLProperty;
    }

    BinXMLProperty getProperty(int n) {
        return (BinXMLProperty)this.idprops.get(n);
    }

    BinXMLProperty getTypeProperty(int n) {
        return (BinXMLProperty)this.idtypes.get(n);
    }

    BinXMLProperty getProperty(BinXMLProperty binXMLProperty, short s) {
        Vector vector = binXMLProperty.getKidProperties();
        if (vector != null && vector.size() > 0) {
            if (this.debug) {
                for (int i = 0; i < vector.size(); ++i) {
                    BinXMLProperty binXMLProperty2 = (BinXMLProperty)vector.get(i);
                    QName qName = binXMLProperty2.getQName();
                    if (qName != null) {
                        System.out.println(qName.getLocalPart());
                        continue;
                    }
                    System.out.println("Any");
                }
            }
            return (BinXMLProperty)vector.get(s - 1);
        }
        return null;
    }

    BinXMLProperty locate2Property(int n) {
        return (BinXMLProperty)this.idprops.get(n);
    }

    BinXMLProperty locateProperty(XSDNode xSDNode) {
        XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
        if (xSDAnnotation == null) {
            return null;
        }
        return (BinXMLProperty)xSDAnnotation.getObject();
    }

    void putProperty(BinXMLProperty binXMLProperty, XSDNode xSDNode) {
        if (binXMLProperty == null) {
            return;
        }
        if (this.getProperty(binXMLProperty.getPropId()) != null) {
            return;
        }
        if (this.getTypeProperty(binXMLProperty.getTypeId()) != null) {
            return;
        }
        XSDAnnotation xSDAnnotation = new XSDAnnotation();
        xSDAnnotation.setObject(binXMLProperty);
        xSDNode.setAnnotation(xSDAnnotation);
        this.properties.add(binXMLProperty);
        if (binXMLProperty.getPropId() != -1) {
            this.idprops.put(binXMLProperty.getPropId(), binXMLProperty);
        }
        if (binXMLProperty.getTypeId() != -1) {
            this.idtypes.put(binXMLProperty.getTypeId(), binXMLProperty);
        }
        if (this.getDebugMode()) {
            for (int i = 0; i < this.properties.size(); ++i) {
                BinXMLProperty binXMLProperty2 = (BinXMLProperty)this.properties.get(i);
                System.out.println(binXMLProperty2.getQName().getLocalPart() + " & " + binXMLProperty2.getPropId() + " & " + binXMLProperty2.getTypeId());
            }
        }
    }

    boolean isWithKidList(XSDNode xSDNode) {
        XSDAnnotation xSDAnnotation;
        if (xSDNode instanceof XSDComplexType) {
            xSDAnnotation = xSDNode.getAnnotation();
        } else if (xSDNode instanceof XSDElement) {
            xSDAnnotation = ((XSDElement)xSDNode).getType().getAnnotation();
        } else {
            return false;
        }
        if (xSDAnnotation == null) {
            return false;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null || vector.size() == 0) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            NodeList nodeList = xMLElement.getElementsByTagNameNS("http://xmlns.oracle.com/2004/CSX", "kidList");
            if (nodeList == null || nodeList.getLength() < 1) continue;
            return true;
        }
        return false;
    }
}

