/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.parser.v2.XMLSAXSerializer;

public class BinXMLSerializer {
    BinXMLDecoder decoder;
    String encoding;
    Boolean indent;
    Boolean omit_decl;
    public static final String ENCODING = "oracle.xml.parser.v2.XMLSAXSerializer.encoding";
    public static final String INDENT = "oracle.xml.parser.v2.XMLSAXSerializer.indent";
    public static final String OMIT_XML_DECL = "oracle.xml.parser.v2.XMLSAXSerializer.omit-xml-decl";

    BinXMLSerializer(BinXMLDecoder binXMLDecoder) {
        this.decoder = binXMLDecoder;
    }

    public InputStream getInputStream() throws IOException, BinXMLException {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        XMLSAXSerializer xMLSAXSerializer = new XMLSAXSerializer(pipedOutputStream);
        this.setProperty(xMLSAXSerializer);
        DecodeThread decodeThread = new DecodeThread(this.decoder, xMLSAXSerializer);
        decodeThread.setOutputStream(pipedOutputStream);
        decodeThread.setDaemon(true);
        decodeThread.start();
        return pipedInputStream;
    }

    public Reader getReader() throws IOException, BinXMLException {
        PipedWriter pipedWriter = new PipedWriter();
        PipedReader pipedReader = new PipedReader(pipedWriter);
        XMLSAXSerializer xMLSAXSerializer = new XMLSAXSerializer(new PrintWriter(pipedWriter));
        this.setProperty(xMLSAXSerializer);
        DecodeThread decodeThread = new DecodeThread(this.decoder, xMLSAXSerializer);
        decodeThread.setWriter(pipedWriter);
        decodeThread.setDaemon(true);
        decodeThread.start();
        return pipedReader;
    }

    public void setProperty(String string, Object object) {
        block5: {
            try {
                if (ENCODING.equals(string)) {
                    this.encoding = (String)object;
                    break block5;
                }
                if (INDENT.equals(string)) {
                    this.indent = (Boolean)object;
                    break block5;
                }
                if (OMIT_XML_DECL.equals(string)) {
                    this.omit_decl = (Boolean)object;
                    break block5;
                }
                throw new IllegalArgumentException();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
        }
    }

    void setProperty(XMLSAXSerializer xMLSAXSerializer) {
        if (this.encoding != null) {
            xMLSAXSerializer.setProperty(ENCODING, this.encoding);
        }
        if (this.indent != null) {
            xMLSAXSerializer.setProperty(INDENT, this.indent);
        }
        if (this.omit_decl != null) {
            xMLSAXSerializer.setProperty(OMIT_XML_DECL, this.omit_decl);
        }
    }

    static class DecodeThread
    extends Thread {
        BinXMLDecoder decoder;
        XMLSAXSerializer serializer;
        OutputStream stream;
        Writer writer;

        DecodeThread(BinXMLDecoder binXMLDecoder, XMLSAXSerializer xMLSAXSerializer) {
            this.decoder = binXMLDecoder;
            this.serializer = xMLSAXSerializer;
        }

        void setOutputStream(OutputStream outputStream) {
            this.stream = outputStream;
        }

        void setWriter(Writer writer) {
            this.writer = writer;
        }

        public void run() {
            try {
                this.decoder.decode(this.serializer, this.serializer);
                if (this.stream != null) {
                    this.stream.flush();
                    this.stream.close();
                } else if (this.writer != null) {
                    this.writer.flush();
                    this.writer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

