/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.BitSet;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDComponent;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxNameHash;

public class XSDNode
implements XSDComponent,
XSDConstantValues {
    String name;
    String targetNS;
    String id;
    int nodeType;
    XSDNode parent;
    XSDAnnotation annotation;
    boolean isClean;
    XMLElement domNode;
    boolean parsed;
    private static final String _indent = "                                                                     ";

    XSDNode() {
        this.init();
    }

    XSDNode(String string, String string2) {
        this.init();
        this.targetNS = string;
        this.name = string2;
    }

    private void init() {
        this.nodeType = 0;
        this.targetNS = "";
        this.name = null;
        this.id = null;
        this.isClean = true;
    }

    public XMLElement getDomNode() {
        return this.domNode;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public boolean isNodeType(int n) {
        return this.nodeType == n;
    }

    boolean isTopLevel() {
        return this.parent instanceof XMLSchemaNode;
    }

    void setName(String string) throws XSDException {
        this.name = string.intern();
        if (!XSDSimpleType.isNCName(string)) {
            throw new XSDException(24507, string, "name");
        }
    }

    public String getName() {
        return this.name;
    }

    public QName getQName() {
        this.targetNS = this.getTargetNS();
        if (this.name != null) {
            return QxNameHash.create(this.targetNS, this.name, "", this.name);
        }
        if (this == XSDComplexType.urType) {
            return QxNameHash.create("http://www.w3.org/2001/XMLSchema", "anyType", "", "anyType");
        }
        return null;
    }

    public XSDNode getNamedBaseType() {
        return null;
    }

    public String getRefLocalname() {
        return null;
    }

    String getContainerName() {
        if (this.parent == null) {
            return "schema";
        }
        if (this.parent.getName() != null) {
            return this.parent.getName();
        }
        return this.parent.getContainerName();
    }

    void setNSName(String string, String string2) {
        this.targetNS = string;
        this.name = string2;
    }

    public String getTargetNS() {
        if (this.parent != null) {
            return this.parent.getTargetNS();
        }
        return null;
    }

    public XMLSchema getOwnerSchema() {
        if (this instanceof XMLSchema) {
            return (XMLSchema)this;
        }
        if (this.parent != null) {
            return this.parent.getOwnerSchema();
        }
        return null;
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation xSDAnnotation) {
        this.annotation = xSDAnnotation;
    }

    void printAnnotation() {
    }

    public XSDAnnotation getRefAnnotation() {
        return null;
    }

    public XSDNode getParent() {
        return this.parent;
    }

    XSDNode getMatchingNode(XMLSchema xMLSchema, String string, String string2) {
        return this;
    }

    int getWidth() {
        return 1;
    }

    void setID(String string) throws XSDException {
        if (!XSDSimpleType.isNCName(string)) {
            throw new XSDException(24507, string, "id");
        }
        this.id = string.intern();
    }

    void addAnnotationAttr(XMLAttr xMLAttr) {
        String string = xMLAttr.getPrefix();
        if (string != null && string.equals("xmlns") || xMLAttr.getNamespace().equals("") && xMLAttr.getName().equals("xmlns")) {
            return;
        }
        if (this.annotation == null) {
            this.annotation = new XSDAnnotation();
        }
        this.annotation.addAttribute(xMLAttr);
    }

    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n) throws Exception {
        this.isClean = true;
        return true;
    }

    void buildPaths(Hashtable hashtable, int n) {
    }

    int postProcess(FastVector fastVector, Hashtable hashtable) throws Exception {
        this.isClean = false;
        return 0;
    }

    boolean isParsed() {
        return false;
    }

    boolean isDerivedFrom(XSDNode xSDNode, BitSet bitSet) {
        return false;
    }

    public boolean isDerivedFrom(XSDNode xSDNode) {
        return this.isDerivedFrom(xSDNode, XSDComplexType.BFNONE);
    }

    public boolean isBuiltInDataType() {
        return false;
    }

    boolean isSubstitutableFor(XSDNode xSDNode, boolean bl, boolean bl2) {
        return false;
    }

    BitSet getProperties() {
        return null;
    }

    void print() {
        switch (this.nodeType) {
            case 1: {
                System.out.print("complexType");
                break;
            }
            case 2: {
                System.out.print("simpleType");
                break;
            }
            case 3: {
                System.out.print("element");
                break;
            }
            case 4: {
                System.out.print("attribute");
                break;
            }
            case 5: {
                System.out.print("group");
                break;
            }
            case 6: {
                System.out.print("attributeGroup");
                break;
            }
            case 0: {
                System.out.print("any");
                break;
            }
            case 22: {
                System.out.print("unique");
                break;
            }
            case 23: {
                System.out.print("key");
                break;
            }
            case 24: {
                System.out.print("keyref");
                break;
            }
        }
    }

    void printSTag(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.print("<");
        this.print();
        System.out.println();
        if (this.name != null) {
            System.out.println(XSDNode.indent(n) + "name = " + this.name);
        }
        if (this.id != null) {
            System.out.println(XSDNode.indent(n) + "id = " + this.id);
        }
    }

    void printEmptySTag(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.println("/>");
    }

    void printSTagEnd(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.println(">");
    }

    void printETag(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.print("</");
        this.print();
        System.out.println(">");
    }

    void print(int n) {
        this.printSTag(n);
    }

    static String indent(int n) {
        return _indent.substring(0, n);
    }
}

