/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDOMMutationEvent;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLRangeEvent;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.validation.CharacterDataEditVAL;

class CharData
extends XMLNode
implements CharacterData,
CharacterDataEditVAL {
    CharData() {
    }

    CharData(XMLDocument xMLDocument) {
        super(xMLDocument);
    }

    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    public void setData(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public String getNodeValue() throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetNodeValue();
            }
            case 2: {
                return this.xdbGetNodeValue(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                this.checkReadOnly();
                if (this.getValidChecking() && this.canSetData(string) == 6) {
                    throw new XMLDOMException(16);
                }
                if (this.isDocumentFlag(65536)) {
                    if (this.isDocumentFlag(131072)) {
                        XMLDocument xMLDocument = this.getDocument();
                        XMLRangeEvent xMLRangeEvent = (XMLRangeEvent)xMLDocument.createRangeEvent("RANGE_SETTEXT_EVENT");
                        xMLRangeEvent.initRangeEvent("RANGE_SETTEXT_EVENT", false, false, this, null, this.xdkGetNodeValue(), string, null);
                        xMLRangeEvent.setTarget(xMLDocument);
                        xMLDocument.dispatchEvent(xMLRangeEvent);
                    }
                    this.fireCharDataModified(string, this.xdkGetNodeValue());
                }
                this.xdkSetNodeValue(string);
                if (!this.isScalable()) break;
                this.xdkKeepNode();
                break;
            }
            case 2: {
                this.xdbSetNodeValue(this.xdbGetCtx(), this.nodeId, string);
            }
        }
    }

    public int getLength() {
        return this.getNodeValue().length();
    }

    public String substringData(int n, int n2) throws DOMException {
        if (n2 < 0) {
            throw new XMLDOMException(1, 21000, this.getXMLError(), String.valueOf(n2));
        }
        switch (this.flags & 3) {
            case 1: {
                String string = this.xdkGetNodeValue();
                if (n < 0 || n > string.length()) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string.length()));
                }
                if (this.isScalable()) {
                    this.xdkKeepNode();
                }
                if (n2 > string.length() - n) {
                    return string.substring(n);
                }
                return string.substring(n, n + n2);
            }
            case 2: {
                if (n < 0) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n));
                }
                String string = this.xdbSubstringData(this.xdbGetCtx(), this.nodeId, n, n2);
                return string;
            }
        }
        return null;
    }

    public void appendData(String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                this.checkReadOnly();
                if (this.getValidChecking() && this.canAppendData(string) == 6) {
                    throw new XMLDOMException(16);
                }
                String string2 = this.xdkGetNodeValue();
                String string3 = string2.concat(string);
                if (this.isDocumentFlag(65536)) {
                    this.fireCharDataModified(string3, string2);
                }
                this.xdkSetNodeValue(string3);
                if (this.isScalable()) {
                    this.xdkKeepNode();
                }
                return;
            }
            case 2: {
                this.xdbAppendData(this.xdbGetCtx(), this.nodeId, string);
                return;
            }
        }
    }

    public void insertData(int n, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                this.checkReadOnly();
                if (this.getValidChecking() && this.canInsertData(n, string) == 6) {
                    throw new XMLDOMException(16);
                }
                String string2 = this.xdkGetNodeValue();
                if (n < 0 || n > string2.length()) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string2.length()));
                }
                if (this.isScalable()) {
                    this.xdkKeepNode();
                }
                String string3 = string2.substring(0, n) + string + string2.substring(n);
                if (this.isDocumentFlag(65536)) {
                    if (this.isDocumentFlag(131072)) {
                        XMLDocument xMLDocument = this.getDocument();
                        XMLRangeEvent xMLRangeEvent = (XMLRangeEvent)xMLDocument.createRangeEvent("RANGE_INSERTTEXT_EVENT");
                        xMLRangeEvent.initRangeEvent("RANGE_INSERTTEXT_EVENT", false, false, this, null, string2, string3, null);
                        xMLRangeEvent.setTarget(xMLDocument);
                        xMLRangeEvent.setOffset(n);
                        xMLRangeEvent.setLength(string.length());
                        xMLDocument.dispatchEvent(xMLRangeEvent);
                    }
                    this.fireCharDataModified(string3, string2);
                }
                this.xdkSetNodeValue(string3);
                return;
            }
            case 2: {
                if (n < 0) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n));
                }
                this.xdbInsertData(this.xdbGetCtx(), this.nodeId, n, string);
                return;
            }
        }
    }

    public void deleteData(int n, int n2) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                this.checkReadOnly();
                if (this.getValidChecking() && this.canDeleteData(n, n2) == 6) {
                    throw new XMLDOMException(16);
                }
                if (this.isScalable()) {
                    this.xdkKeepNode();
                }
                String string = this.xdkGetNodeValue();
                if (n2 < 0 || n < 0 || n > string.length()) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string.length()));
                }
                String string2 = n2 > string.length() - n ? string.substring(0, n) : string.substring(0, n) + string.substring(n + n2);
                if (this.isDocumentFlag(65536)) {
                    if (this.isDocumentFlag(131072)) {
                        XMLDocument xMLDocument = this.getDocument();
                        XMLRangeEvent xMLRangeEvent = (XMLRangeEvent)xMLDocument.createRangeEvent("RANGE_DELETETEXT_EVENT");
                        xMLRangeEvent.initRangeEvent("RANGE_DELETETEXT_EVENT", false, false, this, null, string, string2, null);
                        xMLRangeEvent.setTarget(xMLDocument);
                        xMLRangeEvent.setOffset(n);
                        xMLRangeEvent.setLength(n2);
                        xMLDocument.dispatchEvent(xMLRangeEvent);
                    }
                    this.fireCharDataModified(string2, string);
                }
                this.xdkSetNodeValue(string2);
                return;
            }
            case 2: {
                if (n2 < 0 || n < 0) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n));
                }
                this.xdbDeleteData(this.xdbGetCtx(), this.nodeId, n, n2);
                return;
            }
        }
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                this.checkReadOnly();
                if (this.isScalable()) {
                    this.xdkKeepNode();
                }
                if (this.getValidChecking() && this.canReplaceData(n, n2, string) == 6) {
                    throw new XMLDOMException(16);
                }
                String string2 = this.xdkGetNodeValue();
                if (n2 < 0 || n < 0 || n > string2.length()) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string2.length()));
                }
                String string3 = string2.substring(0, n) + string;
                if (n2 + n <= string2.length()) {
                    string3 = string3 + string2.substring(n + n2);
                }
                if (this.isDocumentFlag(65536)) {
                    this.fireCharDataModified(string3, string2);
                }
                this.xdkSetNodeValue(string3);
                return;
            }
            case 2: {
                if (n2 < 0 || n < 0) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n));
                }
                this.xdbReplaceData(this.xdbGetCtx(), this.nodeId, n, n2, string);
                return;
            }
        }
    }

    public short isWhitespaceOnly() {
        switch (this.flags & 3) {
            case 1: {
                return 7;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canSetData(String string) {
        switch (this.flags & 3) {
            case 1: {
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canAppendData(String string) {
        switch (this.flags & 3) {
            case 1: {
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canReplaceData(int n, int n2, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                String string2 = this.xdkGetNodeValue();
                if (n2 < 0 || n < 0 || n > string2.length()) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string2.length()));
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canInsertData(int n, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                String string2 = this.xdkGetNodeValue();
                if (n < 0 || n > string2.length()) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string2.length()));
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canDeleteData(int n, int n2) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                String string = this.xdkGetNodeValue();
                if (n2 < 0 || n < 0 || n > string.length()) {
                    throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string.length()));
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short nodeValidity(boolean bl, short s) {
        if (this.isWellForm(bl, true)) {
            return 5;
        }
        return 6;
    }

    boolean isWellForm(boolean bl, boolean bl2) {
        return this.getNodeValue().indexOf(60) < 0;
    }

    private void fireCharDataModified(String string, String string2) {
        MutationEvent mutationEvent = this.getDocument().createMutationEvent("");
        mutationEvent.initMutationEvent("DOMCharacterDataModified", true, false, null, string2, string, null, (short)0);
        ((XMLDOMMutationEvent)mutationEvent).setTarget(this);
        this.dispatchEvent(mutationEvent);
        XMLNode xMLNode = (XMLNode)this.getParentNode();
        if (xMLNode != null) {
            this.fireDOMMutationEvent("DOMSubtreeModified", xMLNode, null, null, null, null, true, false, (short)0);
        }
    }

    native String xdbSubstringData(long var1, long var3, int var5, int var6);

    native void xdbAppendData(long var1, long var3, String var5);

    native void xdbInsertData(long var1, long var3, int var5, String var6);

    native void xdbDeleteData(long var1, long var3, int var5, int var6);

    native void xdbReplaceData(long var1, long var3, int var5, int var6, String var7);
}

