/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.Hashtable;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLUtil;
import oracle.xml.xpath.JXPathContext;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLFunction;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;

public class XSLParseString
implements XSLExprConstants {
    private char[] expr;
    private int pos;
    private int end;
    private int prevpos;
    private int curToken;
    private int subToken;
    private String namespace;
    private String name;
    private String value;
    private boolean peeked;
    private int state;
    private String exprString;
    private boolean pattern;
    private boolean varRestricted;
    private FastVector stateStack;
    int version;
    boolean bkwdCompFlag;
    boolean fwdCompFlag;
    XSLStylesheet xss;
    NSResolver nsr;
    static final int DEFAULT = 1;
    static final int OPERATOR = 2;
    static final int QNAME = 3;
    static final int SEQTYPE = 4;
    static final int VARNAME = 5;
    static final int KINDTEST = 6;
    static final int KINDTESTPI = 7;
    static Hashtable axisnames = new Hashtable(20);
    static Hashtable functionnames = new Hashtable(20);
    static Hashtable kindtests = new Hashtable(20);
    static Hashtable itemtypes = new Hashtable(20);
    static Hashtable operators = new Hashtable(20);
    static Hashtable opcategory = new Hashtable(20);

    XSLParseString(String string, NSResolver nSResolver, XSLStylesheet xSLStylesheet) {
        this(string.toCharArray(), 0, nSResolver, xSLStylesheet);
    }

    public XSLParseString(char[] cArray, int n, NSResolver nSResolver, XSLStylesheet xSLStylesheet) {
        this.expr = cArray;
        this.pos = n;
        this.prevpos = n;
        this.end = cArray.length;
        this.nsr = nSResolver;
        this.xss = xSLStylesheet;
        this.state = 1;
        this.pattern = false;
        this.varRestricted = false;
        this.exprString = new String(this.expr, n, this.end - n);
        this.stateStack = new FastVector();
    }

    void setPattern(boolean bl) {
        this.pattern = bl;
    }

    boolean isPattern() {
        return this.pattern;
    }

    void setVarRestricted(boolean bl) {
        this.varRestricted = bl;
    }

    boolean isVarRestricted() {
        return this.varRestricted;
    }

    boolean isCachingExpr() {
        return false;
    }

    XSLStylesheet getStylesheet() {
        return this.xss;
    }

    OXMLFunction getFunction(String string, String string2, int n) {
        if (this.nsr instanceof JXPathContext) {
            return ((JXPathContext)this.nsr).getFunction(string, string2, n);
        }
        return null;
    }

    boolean peekToken(int n) throws XPathException {
        if (!this.peeked) {
            this.curToken = this.nextToken();
        }
        this.peeked = n != this.curToken;
        return !this.peeked;
    }

    int peekToken() throws XPathException {
        if (!this.peeked) {
            this.curToken = this.nextToken();
            this.peeked = true;
        }
        return this.curToken;
    }

    public int nextToken() throws XPathException {
        if (this.peeked) {
            this.peeked = false;
            return this.curToken;
        }
        this.prevpos = this.pos;
        this.skipWhitespaceAndComment();
        if (this.pos >= this.end) {
            return -1;
        }
        this.name = null;
        this.namespace = null;
        this.value = null;
        this.subToken = -2;
        this.curToken = -2;
        switch (this.state) {
            case 1: {
                this.state = this.parseDefaultState();
                break;
            }
            case 2: {
                this.state = this.parseOperatorState();
                break;
            }
            case 3: {
                this.state = this.parseQNameState();
                break;
            }
            case 4: {
                this.state = this.parseSeqTypeState();
                break;
            }
            case 5: {
                this.state = this.parseVarNameState();
                break;
            }
            case 6: {
                this.state = this.parseKindTestState();
                break;
            }
            case 7: {
                this.state = this.parseKindTestForPIState();
            }
        }
        return this.curToken;
    }

    String getNamespace() {
        if (this.curToken == 113 || this.curToken == 110 || this.curToken == 112 || this.curToken == 114 || this.curToken == 120) {
            return this.namespace;
        }
        return null;
    }

    String getLocalName() {
        if (this.curToken == 113 || this.curToken == 110 || this.curToken == 112 || this.curToken == 114 || this.curToken == 120) {
            return this.name;
        }
        return null;
    }

    String getNCName() {
        if (this.curToken == 118) {
            return this.name;
        }
        return null;
    }

    int getFunctionType() {
        if (this.curToken == 113) {
            return this.subToken;
        }
        return -2;
    }

    int getOperator() {
        if (this.curToken == 100 || this.curToken == 101 || this.curToken == 103 || this.curToken == 104 || this.curToken == 105) {
            return this.subToken;
        }
        return -2;
    }

    int getLiteralType() {
        if (this.curToken == 109) {
            return this.subToken;
        }
        return -2;
    }

    String getLiteralValue() {
        if (this.curToken == 109) {
            return this.value;
        }
        return null;
    }

    int getNodeTest() {
        if (this.curToken == 110) {
            return this.subToken;
        }
        return -2;
    }

    int getKindTest() {
        if (this.curToken == 117) {
            return this.subToken;
        }
        return -2;
    }

    int getAxisType() {
        if (this.curToken == 111) {
            return this.subToken;
        }
        return -2;
    }

    int getItemType() {
        if (this.curToken == 114) {
            return this.subToken;
        }
        return -2;
    }

    int getOccurIndicator() {
        if (this.curToken == 115) {
            return this.subToken;
        }
        return -2;
    }

    int lookUp(String string, Hashtable hashtable) {
        Integer n = (Integer)hashtable.get(string);
        if (n != null) {
            return n;
        }
        return -2;
    }

    String getCurrentToken() throws XPathException {
        return new String(this.expr, this.prevpos, this.pos - this.prevpos);
    }

    public int getCurrentPosition() {
        return this.pos;
    }

    String getExprString() {
        return this.exprString;
    }

    public void setCompatibilityFlags(int n, boolean bl, boolean bl2) {
        this.version = n;
        this.bkwdCompFlag = bl;
        this.fwdCompFlag = bl2;
    }

    int getXSLTVersion() {
        return this.version;
    }

    boolean isBackwardCompatibilityMode() {
        return this.bkwdCompFlag;
    }

    boolean isForwardCompatibilityMode() {
        return this.fwdCompFlag;
    }

    private int parseDefaultState() throws XPathException {
        switch (this.expr[this.pos]) {
            case '+': {
                ++this.pos;
                this.curToken = 104;
                this.subToken = 200;
                return 1;
            }
            case '-': {
                ++this.pos;
                this.curToken = 104;
                this.subToken = 201;
                return 1;
            }
            case '(': {
                ++this.pos;
                this.curToken = 25;
                return 1;
            }
            case '*': {
                ++this.pos;
                this.namespace = "*";
                this.name = "*";
                this.curToken = 110;
                this.subToken = 450;
                if (this.isChar(':')) {
                    this.name = this.scanNCName();
                    this.subToken = 452;
                }
                return 2;
            }
            case '.': {
                if (this.scanNumericLiteral()) {
                    return 2;
                }
                ++this.pos;
                this.curToken = 3;
                if (this.isChar('.')) {
                    this.curToken = 4;
                }
                return 2;
            }
            case '/': {
                ++this.pos;
                this.curToken = 5;
                if (this.isChar('/')) {
                    this.curToken = 6;
                }
                return 1;
            }
            case '@': {
                ++this.pos;
                this.curToken = 111;
                this.subToken = 503;
                return 1;
            }
            case '$': {
                ++this.pos;
                this.curToken = 7;
                return 5;
            }
            case ')': {
                ++this.pos;
                this.curToken = 26;
                return 2;
            }
            case ']': {
                ++this.pos;
                this.curToken = 28;
                return 2;
            }
            case '\'': {
                ++this.pos;
                this.curToken = 109;
                this.subToken = 303;
                this.scanLiteral('\'');
                return 2;
            }
            case '\"': {
                ++this.pos;
                this.curToken = 109;
                this.subToken = 303;
                this.scanLiteral('\"');
                return 2;
            }
            case '}': {
                ++this.pos;
                this.curToken = 30;
                return 1;
            }
            case '?': {
                ++this.pos;
                this.curToken = 115;
                this.subToken = 722;
                return 1;
            }
        }
        if (this.scanNumericLiteral()) {
            return 2;
        }
        String string = this.scanNCName();
        this.skipWhitespaceAndComment();
        if (this.isChar(':')) {
            if (this.isChar(':')) {
                this.curToken = 111;
                this.subToken = this.lookUp(string, axisnames);
                return 1;
            }
            this.skipWhitespaceAndComment();
            this.namespace = this.nsr.resolveNamespacePrefix(string);
            if (this.namespace == "" || this.namespace == null) {
                throw new XPathException(1008, string);
            }
            if (this.isChar('*')) {
                this.name = "*";
                this.curToken = 110;
                this.subToken = 453;
                return 2;
            }
            this.name = this.scanNCName();
            this.skipWhitespaceAndComment();
            if (this.isChar('(')) {
                XSLFunction xSLFunction = null;
                if (this.xss != null) {
                    try {
                        xSLFunction = this.xss.getUserDefinedFunctionFromPool(this.namespace, this.name);
                    }
                    catch (XSLException xSLException) {
                        throw new XPathException(xSLException.getMessage());
                    }
                }
                this.subToken = this.xss != null && this.version >= 20 && xSLFunction != null ? (this.name.equals("node-set") && this.namespace.startsWith("http://www.oracle.com/XSL/Transform/java") ? (xSLFunction.getOverride() ? 602 : 601) : 602) : (this.namespace.equals("http://www.w3.org/2005/xpath-functions") || this.namespace.equals("http://www.w3.org/2001/XMLSchema") ? 600 : 601);
                this.curToken = 113;
                this.namespace = this.namespace.intern();
                return 1;
            }
            this.curToken = 110;
            this.subToken = 451;
            return 2;
        }
        if (this.isChar('(')) {
            if (string.equals("if")) {
                this.curToken = 10;
            } else {
                this.subToken = this.lookUp(string, kindtests);
                if (this.subToken != -2) {
                    this.curToken = 110;
                    this.pushState(2);
                    if (this.subToken == 400) {
                        return 7;
                    }
                    return 6;
                }
                this.name = string;
                if (this.nsr instanceof XSLNode) {
                    this.namespace = this.nsr.resolveNamespacePrefix("#xpath-default-namespace");
                    if (this.namespace == null) {
                        this.namespace = "";
                    }
                } else {
                    this.namespace = "";
                }
                this.curToken = 113;
                this.subToken = 600;
            }
            return 1;
        }
        if (this.isChar('$')) {
            if (string.equals("for")) {
                this.curToken = 13;
            } else if (string.equals("some")) {
                this.curToken = 14;
            } else if (string.equals("every")) {
                this.curToken = 15;
            }
            return 5;
        }
        if (string.equals("of") && this.isNCName()) {
            string = this.scanNCName();
            if (!string.equals("type")) {
                throw new XPathException(1900);
            }
            this.curToken = 17;
            return 3;
        }
        this.name = string;
        if (this.nsr instanceof XSLNode) {
            this.namespace = this.nsr.resolveNamespacePrefix("#xpath-default-namespace");
            if (this.namespace == null) {
                this.namespace = "";
            }
        } else {
            this.namespace = "";
        }
        this.curToken = 110;
        this.subToken = 451;
        return 2;
    }

    private int parseOperatorState() throws XPathException {
        switch (this.expr[this.pos]) {
            case '/': {
                ++this.pos;
                this.curToken = 5;
                if (this.isChar('/')) {
                    this.curToken = 6;
                }
                return 1;
            }
            case '\'': {
                ++this.pos;
                this.curToken = 109;
                this.subToken = 303;
                this.scanLiteral('\'');
                return 2;
            }
            case '\"': {
                ++this.pos;
                this.curToken = 109;
                this.subToken = 303;
                this.scanLiteral('\"');
                return 2;
            }
            case '.': {
                ++this.pos;
                this.curToken = 3;
                if (this.isChar('.')) {
                    this.curToken = 4;
                }
                return 2;
            }
            case ',': {
                ++this.pos;
                this.curToken = 1;
                return 1;
            }
            case '|': {
                ++this.pos;
                this.curToken = 102;
                return 1;
            }
            case '=': {
                ++this.pos;
                this.curToken = 105;
                this.subToken = 216;
                return 1;
            }
            case '!': {
                ++this.pos;
                if (this.isChar('=')) {
                    this.curToken = 105;
                    this.subToken = 217;
                }
                return 1;
            }
            case '<': {
                ++this.pos;
                this.curToken = 105;
                this.subToken = 218;
                if (this.isChar('=')) {
                    this.subToken = 219;
                } else if (this.isChar('<')) {
                    this.subToken = 222;
                }
                return 1;
            }
            case '>': {
                ++this.pos;
                this.curToken = 105;
                this.subToken = 220;
                if (this.isChar('=')) {
                    this.subToken = 221;
                } else if (this.isChar('>')) {
                    this.subToken = 223;
                }
                return 1;
            }
            case '+': {
                ++this.pos;
                this.curToken = 100;
                this.subToken = 200;
                return 1;
            }
            case '-': {
                ++this.pos;
                this.curToken = 100;
                this.subToken = 201;
                return 1;
            }
            case '*': {
                ++this.pos;
                if (this.isChar(':')) {
                    this.name = this.scanNCName();
                    this.curToken = 110;
                    this.subToken = 452;
                    return 2;
                }
                this.curToken = 101;
                this.subToken = 202;
                return 1;
            }
            case '[': {
                ++this.pos;
                this.curToken = 27;
                return 1;
            }
            case '(': {
                ++this.pos;
                this.curToken = 25;
                return 1;
            }
            case ')': {
                ++this.pos;
                this.curToken = 26;
                return 2;
            }
            case ']': {
                ++this.pos;
                this.curToken = 28;
                return 2;
            }
            case '}': {
                ++this.pos;
                this.curToken = 30;
                return 1;
            }
            case '$': {
                ++this.pos;
                this.curToken = 7;
                return 5;
            }
            case '?': {
                ++this.pos;
                this.curToken = 115;
                this.subToken = 722;
                return 1;
            }
        }
        if (this.scanNumericLiteral()) {
            return 2;
        }
        String string = this.scanNCName();
        if (this.isChar(':') && this.isChar('*')) {
            this.name = "*";
            this.curToken = 110;
            this.subToken = 453;
            return 2;
        }
        this.skipWhitespaceAndComment();
        if (string.equals("to")) {
            this.curToken = 106;
            return 1;
        }
        if (string.equals("then")) {
            this.curToken = 11;
            return 1;
        }
        if (string.equals("else")) {
            this.curToken = 12;
            return 1;
        }
        if (string.equals("in")) {
            this.curToken = 19;
            return 1;
        }
        if (string.equals("satisfies")) {
            this.curToken = 16;
            return 1;
        }
        if (string.equals("return")) {
            this.curToken = 24;
            return 1;
        }
        if (string.equals("instance") && this.isNCName()) {
            string = this.scanNCName();
            if (!string.equals("of")) {
                throw new XPathException(1900);
            }
            this.curToken = 20;
            return 4;
        }
        if (string.equals("castable") && this.isNCName()) {
            string = this.scanNCName();
            if (!string.equals("as")) {
                throw new XPathException(1900);
            }
            this.curToken = 22;
            return 4;
        }
        if (this.pos < this.end && this.expr[this.pos] == '$') {
            if (string.equals("for")) {
                ++this.pos;
                this.curToken = 13;
                return 5;
            }
            if (string.equals("some")) {
                ++this.pos;
                this.curToken = 14;
                return 5;
            }
            if (string.equals("every")) {
                ++this.pos;
                this.curToken = 15;
                return 5;
            }
        }
        if (string.equals("of") && this.isNCName()) {
            string = this.scanNCName();
            if (!string.equals("type")) {
                throw new XPathException(1900);
            }
            this.curToken = 17;
            return 3;
        }
        if (string.equals("cast") && this.isNCName()) {
            string = this.scanNCName();
            if (!string.equals("as")) {
                throw new XPathException(1900);
            }
            this.curToken = 21;
            return 4;
        }
        if (string.equals("treat") && this.isNCName()) {
            string = this.scanNCName();
            if (!string.equals("as")) {
                throw new XPathException(1900);
            }
            this.curToken = 23;
            return 4;
        }
        this.curToken = this.lookUp(string, opcategory);
        this.subToken = this.lookUp(string, operators);
        return 1;
    }

    private int parseVarNameState() throws XPathException {
        this.curToken = 112;
        String string = this.scanNCName();
        if (this.isChar(':')) {
            this.namespace = this.nsr.resolveNamespacePrefix(string);
            if (this.namespace == "" || this.namespace == null) {
                throw new XPathException(1008, string);
            }
            this.name = this.scanNCName();
        } else {
            this.namespace = "";
            this.name = string;
        }
        return 2;
    }

    private int parseQNameState() throws XPathException {
        switch (this.expr[this.pos]) {
            case '.': {
                ++this.pos;
                this.curToken = 3;
                if (this.isChar('.')) {
                    this.curToken = 4;
                }
                return 2;
            }
            case '*': {
                ++this.pos;
                this.namespace = "*";
                this.name = "*";
                this.curToken = 110;
                this.subToken = 450;
                if (this.isChar(':')) {
                    this.name = this.scanNCName();
                    this.subToken = 452;
                }
                return 2;
            }
        }
        String string = this.scanNCName();
        if (this.isChar(':')) {
            this.namespace = this.nsr.resolveNamespacePrefix(string);
            if (this.namespace == "" || this.namespace == null) {
                throw new XPathException(1008, string);
            }
            if (this.isChar('*')) {
                this.name = "*";
                this.curToken = 110;
                this.subToken = 453;
            }
        }
        return 2;
    }

    private int parseSeqTypeState() throws XPathException {
        if (this.isChar('*')) {
            this.curToken = 115;
            this.subToken = 720;
            return 2;
        }
        if (this.isChar('+')) {
            this.curToken = 115;
            this.subToken = 721;
            return 2;
        }
        if (this.isChar('?')) {
            this.curToken = 115;
            this.subToken = 722;
            return 2;
        }
        String string = this.scanNCName();
        this.skipWhitespaceAndComment();
        if (string.equals("void")) {
            if (this.isChar('(')) {
                this.skipWhitespaceAndComment();
            }
            if (this.isChar(')')) {
                this.curToken = 116;
                return 2;
            }
        }
        if (string.equals("item")) {
            if (this.isChar('(')) {
                this.skipWhitespaceAndComment();
            }
            if (this.isChar(')')) {
                this.curToken = 114;
                this.subToken = 710;
                this.skipWhitespaceAndComment();
                if (this.pos < this.end && (this.expr[this.pos] == '*' || this.expr[this.pos] == '+' || this.expr[this.pos] == '?')) {
                    return 4;
                }
                return 2;
            }
        } else if (this.isChar('(')) {
            this.subToken = this.lookUp(string, kindtests);
            if (this.subToken != -2) {
                this.pushState(4);
                this.curToken = 117;
                if (this.subToken == 400) {
                    return 7;
                }
                return 6;
            }
        }
        if (this.isChar(':')) {
            this.namespace = this.nsr.resolveNamespacePrefix(string);
            if (this.namespace == "" || this.namespace == null) {
                throw new XPathException(1008, string);
            }
            if (this.namespace.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                this.namespace = "http://www.w3.org/2001/XMLSchema";
            }
            this.name = this.scanNCName();
            this.curToken = 114;
            this.subToken = 711;
            this.skipWhitespaceAndComment();
            if (this.pos < this.end && (this.expr[this.pos] == '*' || this.expr[this.pos] == '+' || this.expr[this.pos] == '?')) {
                return 4;
            }
            return 2;
        }
        if (this.nsr instanceof XSLNode) {
            this.namespace = this.nsr.resolveNamespacePrefix("#xpath-default-namespace");
            if (this.namespace == null) {
                this.namespace = "";
            }
        } else {
            this.namespace = "";
        }
        this.name = string;
        return 2;
    }

    private int parseKindTestState() throws XPathException {
        String string = null;
        if (this.isChar(')')) {
            this.curToken = 26;
            this.skipWhitespaceAndComment();
            if (this.pos < this.end && (this.expr[this.pos] == '*' || this.expr[this.pos] == '+' || this.expr[this.pos] == '?')) {
                return this.popState();
            }
            this.popState();
            return 2;
        }
        if (this.isChar('*')) {
            this.curToken = 119;
            return 6;
        }
        if (this.isChar(',')) {
            this.curToken = 1;
            return 6;
        }
        if (this.isChar('?')) {
            this.curToken = 115;
            this.subToken = 722;
            return 6;
        }
        string = this.scanNCName();
        this.skipWhitespaceAndComment();
        if (this.isChar(':')) {
            this.namespace = this.nsr.resolveNamespacePrefix(string);
            if (this.namespace == "" || this.namespace == null) {
                throw new XPathException(1008, string);
            }
            if (this.namespace.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                this.namespace = "http://www.w3.org/2001/XMLSchema";
            }
            this.name = this.scanNCName();
            this.skipWhitespaceAndComment();
        } else {
            if (this.nsr instanceof XSLNode) {
                this.namespace = this.nsr.resolveNamespacePrefix("#xpath-default-namespace");
                if (this.namespace == null) {
                    this.namespace = "";
                }
            } else {
                this.namespace = "";
            }
            this.name = string;
        }
        if (string.equals("element") && this.isChar('(')) {
            this.curToken = 117;
            this.subToken = 405;
            this.pushState(6);
            return 6;
        }
        if (string.equals("schema-element") && this.isChar('(')) {
            this.curToken = 117;
            this.subToken = 407;
            this.pushState(6);
            return 6;
        }
        this.curToken = 120;
        return 6;
    }

    private int parseKindTestForPIState() throws XPathException {
        if (this.isChar(')')) {
            this.curToken = 26;
            this.skipWhitespaceAndComment();
            if (this.pos < this.end && (this.expr[this.pos] == '*' || this.expr[this.pos] == '+' || this.expr[this.pos] == '?')) {
                return this.popState();
            }
            this.popState();
            return 2;
        }
        if (this.expr[this.pos] == '\"' || this.expr[this.pos] == '\'') {
            this.curToken = 109;
            this.subToken = 303;
            ++this.pos;
            if (this.expr[this.pos - 1] == '\"') {
                this.scanLiteral('\"');
            } else {
                this.scanLiteral('\'');
            }
            return 7;
        }
        this.name = this.scanNCName();
        this.curToken = 118;
        return 7;
    }

    private boolean isChar(char c) throws XPathException {
        if (this.pos >= this.end) {
            return false;
        }
        if (this.expr[this.pos] == c) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private void skipWhitespaceAndComment() throws XPathException {
        int n;
        do {
            n = this.pos;
            while (this.pos < this.end && this.expr[this.pos] == ' ') {
                ++this.pos;
            }
            if (this.pos + 1 >= this.end || this.expr[this.pos] != '(' || this.expr[this.pos + 1] != ':') continue;
            this.pos += 2;
            while (this.pos + 1 < this.end && (this.expr[this.pos] != ':' || this.expr[this.pos + 1] != ')')) {
                ++this.pos;
            }
            if (this.pos + 1 < this.end) {
                this.pos += 2;
                continue;
            }
            throw new XPathException(1013, this.getExprString());
        } while (n != this.pos);
    }

    private boolean isNCName() {
        return XMLUtil.isFirstNameChar(this.expr[this.pos]);
    }

    private String scanNCName() throws XPathException {
        int n = this.pos;
        if (XMLUtil.isFirstNameChar(this.expr[this.pos])) {
            ++this.pos;
            while (this.pos < this.end && XMLUtil.isNameChar(this.expr[this.pos])) {
                ++this.pos;
            }
            return new String(this.expr, n, this.pos - n).intern();
        }
        throw new XPathException(1013, this.exprString);
    }

    private boolean scanNumericLiteral() throws XPathException {
        int n = this.pos;
        this.subToken = 300;
        if (Character.isDigit(this.expr[this.pos])) {
            ++this.pos;
            while (this.pos < this.end && Character.isDigit(this.expr[this.pos])) {
                ++this.pos;
            }
        }
        if (this.pos < this.end && this.expr[this.pos] == '.') {
            this.subToken = 302;
            ++this.pos;
            while (this.pos < this.end && Character.isDigit(this.expr[this.pos])) {
                ++this.pos;
            }
            if (n == this.pos - 1) {
                --this.pos;
                return false;
            }
        }
        if (n == this.pos) {
            return false;
        }
        if (this.pos < this.end && (this.expr[this.pos] == 'e' || this.expr[this.pos] == 'E')) {
            this.subToken = 301;
            ++this.pos;
            if (this.pos < this.end && (this.expr[this.pos] == '+' || this.expr[this.pos] == '-')) {
                ++this.pos;
            }
            int n2 = this.pos;
            while (this.pos < this.end && Character.isDigit(this.expr[this.pos])) {
                ++this.pos;
            }
            if (n2 == this.pos) {
                throw new XPathException(1013, this.getExprString());
            }
        }
        this.curToken = 109;
        this.value = new String(this.expr, n, this.pos - n);
        return true;
    }

    private void scanLiteral(char c) throws XPathException {
        int n = this.pos;
        while (this.pos < this.end && this.expr[this.pos] != c) {
            ++this.pos;
        }
        if (this.pos >= this.end || this.expr[this.pos] != c) {
            throw new XPathException(1023);
        }
        this.value = new String(this.expr, n, this.pos - n);
        this.value = this.replaceEntityRefs(this.value);
        ++this.pos;
    }

    private String replaceEntityRef(String string, String string2, String string3) {
        int n = -1;
        String string4 = null;
        String string5 = null;
        n = string.indexOf(string2);
        while (n != -1) {
            int n2 = n;
            int n3 = n2 + string2.length();
            string4 = string.substring(0, n2);
            string5 = string.substring(n3);
            string = string4 + string3 + string5;
            n = string.indexOf(string2);
        }
        return string;
    }

    private String replaceEntityRefs(String string) {
        string = this.replaceEntityRef(string, "&apos;", "'");
        string = this.replaceEntityRef(string, "&quot;", "\"");
        string = this.replaceEntityRef(string, "&lt;", "<");
        string = this.replaceEntityRef(string, "&gt;", ">");
        string = this.replaceEntityRef(string, "&amp;", "&");
        return string;
    }

    private int popState() {
        return (Integer)this.stateStack.popElement();
    }

    private void pushState(int n) {
        this.stateStack.addElement(new Integer(n));
    }

    static {
        axisnames.put("ancestor", new Integer(508));
        axisnames.put("ancestor-or-self", new Integer(513));
        axisnames.put("attribute", new Integer(503));
        axisnames.put("child", new Integer(501));
        axisnames.put("descendant", new Integer(502));
        axisnames.put("descendant-or-self", new Integer(510));
        axisnames.put("following", new Integer(505));
        axisnames.put("following-sibling", new Integer(511));
        axisnames.put("parent", new Integer(507));
        axisnames.put("preceding", new Integer(509));
        axisnames.put("preceding-sibling", new Integer(512));
        axisnames.put("self", new Integer(504));
        axisnames.put("namespace", new Integer(506));
        functionnames.put("count", new Integer(-23));
        functionnames.put("position", new Integer(-24));
        functionnames.put("id", new Integer(-26));
        functionnames.put("key", new Integer(-28));
        functionnames.put("document", new Integer(-30));
        functionnames.put("generate-id", new Integer(-35));
        functionnames.put("current", new Integer(-156));
        functionnames.put("current-group", new Integer(-203));
        functionnames.put("current-grouping-key", new Integer(-204));
        functionnames.put("format-number", new Integer(-99));
        functionnames.put("system-property", new Integer(-110));
        functionnames.put("function-available", new Integer(-111));
        functionnames.put("element-available", new Integer(-112));
        functionnames.put("unparsed-entity-uri", new Integer(-113));
        functionnames.put("sort", new Integer(-202));
        functionnames.put("unparsed-entity-public-id", new Integer(-114));
        functionnames.put("unparsed-text", new Integer(-201));
        functionnames.put("QName", new Integer(-157));
        functionnames.put("not", new Integer(-158));
        functionnames.put("boolean", new Integer(-159));
        kindtests.put("document-node", new Integer(404));
        kindtests.put("element", new Integer(405));
        kindtests.put("attribute", new Integer(406));
        kindtests.put("schema-element", new Integer(407));
        kindtests.put("schema-attribute", new Integer(408));
        kindtests.put("processing-instruction", new Integer(400));
        kindtests.put("comment", new Integer(401));
        kindtests.put("text", new Integer(402));
        kindtests.put("node", new Integer(403));
        operators.put("and", new Integer(107));
        operators.put("or", new Integer(108));
        operators.put("eq", new Integer(210));
        operators.put("ne", new Integer(211));
        operators.put("lt", new Integer(212));
        operators.put("le", new Integer(213));
        operators.put("gt", new Integer(214));
        operators.put("ge", new Integer(215));
        operators.put("is", new Integer(208));
        operators.put("isnot", new Integer(209));
        operators.put("div", new Integer(203));
        operators.put("idiv", new Integer(204));
        operators.put("mod", new Integer(205));
        operators.put("union", new Integer(102));
        operators.put("intersect", new Integer(206));
        operators.put("except", new Integer(207));
        opcategory.put("and", new Integer(107));
        opcategory.put("or", new Integer(108));
        opcategory.put("eq", new Integer(105));
        opcategory.put("ne", new Integer(105));
        opcategory.put("lt", new Integer(105));
        opcategory.put("le", new Integer(105));
        opcategory.put("gt", new Integer(105));
        opcategory.put("ge", new Integer(105));
        opcategory.put("is", new Integer(105));
        opcategory.put("isnot", new Integer(105));
        opcategory.put("div", new Integer(101));
        opcategory.put("idiv", new Integer(101));
        opcategory.put("mod", new Integer(101));
        opcategory.put("union", new Integer(102));
        opcategory.put("intersect", new Integer(103));
        opcategory.put("except", new Integer(103));
    }
}

