/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Random;

public final class LfuPolicy {
    private static final int DEFAULT_SAMPLE_SIZE = 30;
    private static final Random RANDOM = new Random();

    private LfuPolicy() {
    }

    private static int calculateSampleSize(int populationSize) {
        if (populationSize < 30) {
            return populationSize;
        }
        return 30;
    }

    public static Metadata leastHit(Metadata[] sampledElements, Metadata justAdded) {
        if (sampledElements.length == 1) {
            return justAdded;
        }
        Metadata lowestElement = null;
        for (int i = 0; i < sampledElements.length; ++i) {
            Metadata element = sampledElements[i];
            if (lowestElement == null) {
                if (element.equals(justAdded)) continue;
                lowestElement = element;
                continue;
            }
            if (element.getHitCount() >= lowestElement.getHitCount() || element.equals(justAdded)) continue;
            lowestElement = element;
        }
        return lowestElement;
    }

    public static int[] generateRandomSample(int populationSize) {
        int sampleSize = LfuPolicy.calculateSampleSize(populationSize);
        int[] offsets = new int[sampleSize];
        int maxOffset = populationSize / sampleSize;
        for (int i = 0; i < sampleSize; ++i) {
            offsets[i] = RANDOM.nextInt(maxOffset);
        }
        return offsets;
    }

    public static interface Metadata {
        public Object getKey();

        public long getHitCount();
    }
}

