/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.bind.ScheduleUnmarshaller;
import com.tandbergtv.watchpoint.pmm.title.bind.TitleUnmarshaller;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IngestScheduleProgramListMessageHandler
implements MessageHandler {
    private static final String FILE_PATH = "filePath";
    private static final String FILE_TYPE = "fileType";
    private static final String FILE_TYPE_PROGRAMLIST = "Program List";
    private static final String FILE_TYPE_PLANNER = "Planner";
    private static final String XPATH_PLANNER = "/planners/planner";
    private static final String XPATH_TITLE = "/titles/title";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, FILE_PATH, FILE_TYPE);
        String fileType = Util.getStringValueTrimmed(message, FILE_TYPE);
        String filePath = Util.getStringValueTrimmed(message, FILE_PATH);
        IPMMService pmmService = (IPMMService)ServiceRegistry.getDefault().lookup(IPMMService.class);
        if (fileType.equals(FILE_TYPE_PROGRAMLIST)) {
            Collection<Title> titles = this.parseTitles(filePath);
            pmmService.programListArrived(titles);
        } else if (fileType.equals(FILE_TYPE_PLANNER)) {
            List<Planner> planners = this.parsePlanners(filePath);
            pmmService.plannersArrived(planners);
        }
        return new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
    }

    private Collection<Title> parseTitles(String filePath) throws Exception {
        ArrayList<Title> titles = new ArrayList<Title>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(filePath));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeSet = (NodeList)xPath.evaluate(XPATH_TITLE, doc, XPathConstants.NODESET);
        if (nodeSet != null) {
            for (int i = 0; i < nodeSet.getLength(); ++i) {
                Node node = nodeSet.item(i);
                titles.add(TitleUnmarshaller.newInstance().unmarshal(node));
            }
        }
        return titles;
    }

    private List<Planner> parsePlanners(String filePath) throws Exception {
        ArrayList<Planner> planners = new ArrayList<Planner>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(filePath));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeSet = (NodeList)xPath.evaluate(XPATH_PLANNER, doc, XPathConstants.NODESET);
        if (nodeSet != null) {
            for (int i = 0; i < nodeSet.getLength(); ++i) {
                Node node = nodeSet.item(i);
                Planner planner = (Planner)ScheduleUnmarshaller.newInstance().unmarshal(node);
                planners.add(planner);
            }
        }
        return planners;
    }
}

