/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.watchpoint.pmm.core.AssetMapInfo;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.MetadataMapInfo;
import com.tandbergtv.watchpoint.pmm.core.NoTitleForAnAssetException;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.ProgressManager;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.watchpoint.pmm.util.lock.LockService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class PMMService
implements IPMMService {
    private static final Logger logger = Logger.getLogger(PMMService.class);
    private static final long LOCK_WAIT_TIME = 1000L;
    private ITitleService titleService;
    private ProgressManager progressManager;

    public String getServiceName() {
        return "PMM Service";
    }

    public void start() {
        ServiceRegistry defaultServiceRegistry = ServiceRegistry.getDefault();
        this.titleService = (ITitleService)defaultServiceRegistry.lookup(ITitleService.class);
        this.progressManager = ProgressManager.newInstance();
    }

    public void stop() {
    }

    @Override
    @Transactional
    public AssetMapInfo assetArrived(String filePath, String sourceComponentName, String sourceEntityName, String sourceId) {
        String string = filePath;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        return (AssetMapInfo)PMMService.assetArrived_aroundBody1$advice(this, string, string2, string3, string4, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("assetArrived", String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public MetadataMapInfo metadataArrived(String spec, String filePath, boolean createIfNotExist, String sourceComponentName, String sourceEntityName, String sourceId) throws PMMException {
        String string = spec;
        String string2 = filePath;
        boolean bl = createIfNotExist;
        String string3 = sourceComponentName;
        String string4 = sourceEntityName;
        String string5 = sourceId;
        return (MetadataMapInfo)PMMService.metadataArrived_aroundBody3$advice(this, string, string2, bl, string3, string4, string5, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("metadataArrived", String.class, String.class, Boolean.TYPE, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public List<Asset> mapFiles(Asset rootAsset) {
        Asset asset = rootAsset;
        return (List)PMMService.mapFiles_aroundBody5$advice(this, asset, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("mapFiles", Asset.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void programListArrived(Collection<Title> titles) throws PMMException {
        Collection<Title> collection = titles;
        PMMService.programListArrived_aroundBody7$advice(this, collection, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("programListArrived", Collection.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void plannersArrived(Collection<Planner> planners) throws PMMException, IllegalArgumentException {
        Collection<Planner> collection = planners;
        PMMService.plannersArrived_aroundBody9$advice(this, collection, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("plannersArrived", Collection.class).getAnnotation(Transactional.class), null);
    }

    protected void plannerArrived(Planner planner) throws PMMException {
    }

    @Override
    @Transactional
    public void sendAssetReceivedStatus(Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        String string = titleName;
        String string2 = sourceComponentName;
        String string3 = sourceEntityName;
        String string4 = sourceId;
        PMMService.sendAssetReceivedStatus_aroundBody11$advice(this, title, string, string2, string3, string4, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("sendAssetReceivedStatus", Title.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void sendMetadataReceivedStatus(Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title = rootTitle;
        String string = sourceComponentName;
        String string2 = sourceEntityName;
        String string3 = sourceId;
        PMMService.sendMetadataReceivedStatus_aroundBody13$advice(this, title, string, string2, string3, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("sendMetadataReceivedStatus", Title.class, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void sendStatus(Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        Title title2 = title;
        String string = statusName;
        String string2 = statusValue;
        boolean bl = success;
        String string3 = sourceComponentName;
        String string4 = sourceEntityName;
        String string5 = sourceId;
        PMMService.sendStatus_aroundBody15$advice(this, title2, string, string2, bl, string3, string4, string5, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("sendStatus", Title.class, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void updateTitleStatus(Title rootTitle) {
        Title title = rootTitle;
        PMMService.updateTitleStatus_aroundBody17$advice(this, title, TransactionEnforcer.aspectOf(), PMMService.class.getDeclaredMethod("updateTitleStatus", Title.class).getAnnotation(Transactional.class), null);
    }

    protected ISpecHandler getSpecHandler(String spec) {
        return SpecHandlerFactory.getInstance((Spec)Spec.valueOf((String)spec.toUpperCase()));
    }

    protected void mapFile(String filePath, Asset asset) {
        List files = asset.getChildrenOfType(com.tandbergtv.metadatamanager.model.File.class);
        if (files != null) {
            for (com.tandbergtv.metadatamanager.model.File file : files) {
                file.setOriginal(false);
            }
        }
        com.tandbergtv.metadatamanager.model.File newFile = new com.tandbergtv.metadatamanager.model.File();
        newFile.setOriginal(true);
        newFile.setType(Item.ItemType.FILE);
        newFile.addField(new Field(FieldName.FILE_URL.toString(), filePath));
        String size = new File(filePath).length() + "";
        newFile.addField(new Field(FieldName.FILE_SIZE.toString(), size));
        asset.addChild((Asset)newFile);
    }

    protected String getFileName(Item item) {
        String fileName;
        Field fileNameField = item.getFirstField(FieldName.URL.toString());
        String string = fileName = fileNameField != null ? fileNameField.getValue() : null;
        if (fileName != null && (fileName = fileName.trim()).length() == 0) {
            fileName = null;
        }
        return fileName;
    }

    protected boolean hasOriginalFile(Asset asset) {
        List files = asset.getChildrenOfType(com.tandbergtv.metadatamanager.model.File.class);
        if (files != null) {
            for (com.tandbergtv.metadatamanager.model.File file : files) {
                if (!file.isOriginal()) continue;
                return true;
            }
        }
        return false;
    }

    protected void sendAssetReceivedStatus(Title rootTitle, String titleName, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String statusName = ProgressStatusHelper.getAssetReceivedStatusName(titleName);
        String statusValue = ProgressStatusHelper.getAssetReceivedStatusValue(titleName);
        if (statusName != null) {
            this.progressManager.updateStatus(rootTitle.getId(), plannerId, statusName, statusValue, true, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    protected void sendMetadataReceivedStatus(Title rootTitle, Long plannerId, String sourceComponentName, String sourceEntityName, String sourceId) {
        String statusName = ProgressStatusHelper.getMetadataReceivedStatusName();
        String statusValue = ProgressStatusHelper.getMetadataReceivedValue();
        if (statusName != null) {
            this.progressManager.updateStatus(rootTitle.getId(), plannerId, statusName, statusValue, true, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    protected Long findEarliestUpcomingPlannerId(Title title) {
        ArrayList<Schedule> upcomingPlanners = new ArrayList<Schedule>();
        Date now = this.getToday();
        Collection<IAssetList> associatedAssetLists = title.getTitlelists();
        if (associatedAssetLists != null) {
            for (IAssetList associatedAssetList : associatedAssetLists) {
                Schedule associatedPlanner;
                if (associatedAssetList.getType() != TitleListType.PLANNER || (associatedPlanner = (Schedule)associatedAssetList).getDate().compareTo(now) < 0) continue;
                upcomingPlanners.add(associatedPlanner);
            }
        }
        if (upcomingPlanners.isEmpty()) {
            return null;
        }
        Collections.sort(upcomingPlanners, new Comparator<Schedule>(){

            @Override
            public int compare(Schedule o1, Schedule o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        return ((Schedule)upcomingPlanners.get(0)).getId();
    }

    protected List<Title> createOrUpdate(Collection<Title> titles) {
        ArrayList<Title> dbTitles = new ArrayList<Title>();
        if (titles != null) {
            for (Title title : titles) {
                Title dbTitle = this.createOrUpdate(title);
                dbTitles.add(dbTitle);
            }
        }
        return dbTitles;
    }

    protected Title createOrUpdate(Title title) {
        return null;
    }

    protected void fillRequiredData(Title rootTitle) {
        rootTitle.setIsActive(true);
        rootTitle.setStatus(TitleStatus.NEW);
    }

    protected Date getToday() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    protected boolean containsValue(String s) {
        return s != null && s.trim().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ AssetMapInfo assetArrived_aroundBody0(PMMService this_, String filePath, String sourceComponentName, String sourceEntityName, String sourceId) {
        String fileName = new File(filePath).getName();
        Asset foundAsset = null;
        Title rootTitle = null;
        boolean validationSuccess = true;
        while (true) {
            Collection<Asset> foundAssets;
            if ((foundAssets = this_.titleService.findAssetsWithFileName(fileName)) == null || foundAssets.isEmpty()) {
                return new AssetMapInfo(AssetMapInfo.Status.NO_MATCH);
            }
            if (foundAssets.size() > 1) {
                return new AssetMapInfo(AssetMapInfo.Status.MULTIPLE_MATCHES);
            }
            foundAsset = foundAssets.iterator().next();
            rootTitle = this_.titleService.getTitle(foundAsset.getRoot());
            if (LockService.getInstance().lock(rootTitle)) {
                try {
                    for (Relation r : rootTitle.getAsset().getRelations()) {
                        if (r.getTargetAsset().getId() != foundAsset.getId()) continue;
                        this_.mapFile(filePath, r.getTargetAsset());
                        break;
                    }
                    try {
                        this_.titleService.update(rootTitle, sourceComponentName, sourceEntityName, sourceId);
                    }
                    catch (TitleValidationException e) {
                        this_.titleService.saveAsDraft(rootTitle);
                        this_.sendStatus(rootTitle, ProgressStatusHelper.VALIDATION_FAILURE, e.getValidationMessagesAsString(), false, sourceComponentName, sourceEntityName, sourceId);
                        validationSuccess = false;
                    }
                    break;
                }
                finally {
                    LockService.getInstance().unlock(rootTitle);
                }
            }
            logger.debug((Object)"Unable to acquire lock. Sleeping.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        Long plannerId = this_.findEarliestUpcomingPlannerId(rootTitle);
        this_.sendAssetReceivedStatus(rootTitle, ((Item)foundAsset).getType(), plannerId, sourceComponentName, sourceEntityName, sourceId);
        AssetMapInfo mapInfo = new AssetMapInfo(AssetMapInfo.Status.MATCHED_TITLE_UPDATED);
        mapInfo.addMappedTitle(rootTitle.getId(), validationSuccess, ((Item)foundAsset).getType());
        return mapInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object assetArrived_aroundBody1$advice(PMMService this_, String transactional, String ajc_aroundClosure, String string, String string2, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            return PMMService.assetArrived_aroundBody0(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            AssetMapInfo assetMapInfo = PMMService.assetArrived_aroundBody0(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            transactionManager2.commit();
            return assetMapInfo;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ MetadataMapInfo metadataArrived_aroundBody2(PMMService this_, String spec, String filePath, boolean createIfNotExist, String sourceComponentName, String sourceEntityName, String sourceId) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            document = docBuilder.parse(new File(filePath));
        }
        catch (Exception e) {
            throw new PMMException("Unable to parse the metadata file: " + filePath, e);
        }
        ISpecHandler specHandler = this_.getSpecHandler(spec);
        if (!createIfNotExist) {
            List identifiers = null;
            try {
                identifiers = specHandler.getIdentifiers(document);
            }
            catch (Exception e) {
                throw new PMMException("Failed to get asset identifiers from the metadata document.", e);
            }
            for (IIdentifier identifier : identifiers) {
                try {
                    identifier.getAsset();
                }
                catch (SearchException e) {
                    return new MetadataMapInfo(MetadataMapInfo.Status.TITLES_NOT_FOUND);
                }
            }
        }
        MetadataMapInfo mapInfo = new MetadataMapInfo(MetadataMapInfo.Status.TITLES_MERGED);
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean saveSuccessful = false;
        try {
            List mergedAssets = null;
            try {
                mergedAssets = specHandler.mergeWithoutSave(document);
            }
            catch (Exception e) {
                throw new PMMException("Failed to save the metadata document.", e);
            }
            if (mergedAssets != null) {
                for (Asset mergedAsset : mergedAssets) {
                    boolean created;
                    boolean validationSuccess = true;
                    this_.mapFile(filePath, mergedAsset);
                    List<Asset> mappedAssets = this_.mapFiles(mergedAsset);
                    Title assetTitle = null;
                    try {
                        assetTitle = this_.titleService.getTitle(mergedAsset);
                        created = false;
                    }
                    catch (NoTitleForAnAssetException e) {
                        assetTitle = new Title();
                        created = true;
                    }
                    assetTitle.setAsset(mergedAsset);
                    try {
                        if (created) {
                            this_.titleService.create(assetTitle, sourceComponentName, sourceEntityName, sourceId);
                            RulesEngineFacade.sendIngestedCreatedEvent(assetTitle.getId());
                        } else {
                            this_.titleService.update(assetTitle, sourceComponentName, sourceEntityName, sourceId);
                            RulesEngineFacade.sendIngestedUpdatedEvent(assetTitle.getId());
                        }
                    }
                    catch (TitleValidationException e) {
                        this_.titleService.saveAsDraft(assetTitle);
                        this_.sendStatus(assetTitle, ProgressStatusHelper.VALIDATION_FAILURE, e.getValidationMessagesAsString(), false, sourceComponentName, sourceEntityName, sourceId);
                        validationSuccess = false;
                    }
                    Long plannerId = this_.findEarliestUpcomingPlannerId(assetTitle);
                    this_.sendMetadataReceivedStatus(assetTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
                    for (Asset asset : mappedAssets) {
                        this_.sendAssetReceivedStatus(assetTitle, ((Item)asset).getType(), plannerId, sourceComponentName, sourceEntityName, sourceId);
                    }
                    ArrayList<String> titleNames = new ArrayList<String>();
                    for (Asset asset : mappedAssets) {
                        titleNames.add(((Item)asset).getType());
                    }
                    mapInfo.addMappedTitle(assetTitle.getId(), validationSuccess, titleNames);
                }
            }
            saveSuccessful = true;
        }
        finally {
            if (saveSuccessful) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                try {
                    AssetsManager.getThreadLocalInstance().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.error((Object)("Rolling back failed. | " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return mapInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object metadataArrived_aroundBody3$advice(PMMService this_, String transactional, String ajc_aroundClosure, boolean bl, String string, String string2, String string3, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl2 = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl2 = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl2) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            return PMMService.metadataArrived_aroundBody2(this_, transactional, ajc_aroundClosure, (boolean)transactionManager, (String)isTransactionOwner, (String)e, string3);
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            MetadataMapInfo metadataMapInfo = PMMService.metadataArrived_aroundBody2(this_, transactional, ajc_aroundClosure, (boolean)transactionManager, (String)isTransactionOwner, (String)e, string3);
            transactionManager2.commit();
            return metadataMapInfo;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ List mapFiles_aroundBody4(PMMService this_, Asset rootAsset) {
        ArrayList<Item> mappedAssets = new ArrayList<Item>();
        for (Asset asset : rootAsset.getAllDescendantItems(false)) {
            Item item = (Item)asset;
            String fileName = this_.getFileName(item);
            if (fileName == null) continue;
            File matchingUnmappedFile = null;
            try {
                matchingUnmappedFile = AssetsManager.getThreadLocalInstance().getUnmappedFile(fileName);
            }
            catch (Exception e) {
                logger.error((Object)("Exception when trying to get unmapped file with name: " + fileName), (Throwable)e);
            }
            if (matchingUnmappedFile == null) continue;
            File movedFile = null;
            try {
                movedFile = AssetsManager.getThreadLocalInstance().moveToMappedFilesDirectory(matchingUnmappedFile);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to move unmapped asset to mapped assets directory. Mapping ignored. Unmapped asset path: " + matchingUnmappedFile.getAbsolutePath()), (Throwable)e);
            }
            if (movedFile == null) continue;
            this_.mapFile(movedFile.getAbsolutePath(), (Asset)item);
            mappedAssets.add(item);
            logger.debug((Object)("Mapped file: " + movedFile.getAbsolutePath() + " to item: " + item));
        }
        return mappedAssets;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object mapFiles_aroundBody5$advice(PMMService this_, Asset transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return PMMService.mapFiles_aroundBody4(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            List list = PMMService.mapFiles_aroundBody4(this_, transactional);
            object.commit();
            return list;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ void programListArrived_aroundBody6(PMMService this_, Collection titles) {
        if (titles == null || titles.isEmpty()) {
            throw new IllegalArgumentException("Titles collection is null or empty");
        }
        HibernateContext.getContext().beginTransaction();
        boolean success = false;
        try {
            for (Title title : titles) {
                this_.fillRequiredData(title);
                this_.createOrUpdate(title);
            }
            HibernateContext.getContext().commitTransaction();
            success = true;
        }
        finally {
            if (!success) {
                try {
                    HibernateContext.getContext().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.warn((Object)"Exception in rolling back the transaction.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object programListArrived_aroundBody7$advice(PMMService this_, Collection transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            PMMService.programListArrived_aroundBody6(this_, transactional);
            return null;
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            PMMService.programListArrived_aroundBody6(this_, transactional);
            Object var7_8 = null;
            object.commit();
            return var7_8;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ void plannersArrived_aroundBody8(PMMService this_, Collection planners) {
        if (planners == null || planners.isEmpty()) {
            throw new IllegalArgumentException("Planners collection is null or empty");
        }
        HibernateContext.getContext().beginTransaction();
        boolean success = false;
        try {
            for (Planner planner : planners) {
                try {
                    this_.plannerArrived(planner);
                }
                catch (PMMException e) {
                    throw new PMMException("Ingesting planner [Provider ID: " + planner.getProviderID() + " | Arrival Date: " + planner.getArrivalDate() + "] failed | Reason: " + e.getMessage(), e);
                }
                catch (RuntimeException e) {
                    throw new PMMException("Ingesting planner [Provider ID: " + planner.getProviderID() + " | Arrival Date: " + planner.getArrivalDate() + "] failed | Reason: " + e.getMessage(), e);
                }
            }
            HibernateContext.getContext().commitTransaction();
            success = true;
        }
        finally {
            if (!success) {
                try {
                    HibernateContext.getContext().rollbackTransaction();
                }
                catch (Exception e) {
                    logger.warn((Object)"Exception in rolling back the transaction.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object plannersArrived_aroundBody9$advice(PMMService this_, Collection transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            PMMService.plannersArrived_aroundBody8(this_, transactional);
            return null;
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            PMMService.plannersArrived_aroundBody8(this_, transactional);
            Object var7_8 = null;
            object.commit();
            return var7_8;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void sendAssetReceivedStatus_aroundBody10(PMMService this_, Title rootTitle, String titleName, String sourceComponentName, String sourceEntityName, String sourceId) {
        Long plannerId = this_.findEarliestUpcomingPlannerId(rootTitle);
        this_.sendAssetReceivedStatus(rootTitle, titleName, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object sendAssetReceivedStatus_aroundBody11$advice(PMMService this_, Title transactional, String ajc_aroundClosure, String string, String string2, String string3, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            PMMService.sendAssetReceivedStatus_aroundBody10(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner, (String)e);
            return null;
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            PMMService.sendAssetReceivedStatus_aroundBody10(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner, (String)e);
            Object var11_12 = null;
            transactionManager2.commit();
            return var11_12;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void sendMetadataReceivedStatus_aroundBody12(PMMService this_, Title rootTitle, String sourceComponentName, String sourceEntityName, String sourceId) {
        Long plannerId = this_.findEarliestUpcomingPlannerId(rootTitle);
        this_.sendMetadataReceivedStatus(rootTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object sendMetadataReceivedStatus_aroundBody13$advice(PMMService this_, Title transactional, String ajc_aroundClosure, String string, String string2, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            PMMService.sendMetadataReceivedStatus_aroundBody12(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            return null;
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            PMMService.sendMetadataReceivedStatus_aroundBody12(this_, transactional, ajc_aroundClosure, (String)transactionManager, (String)isTransactionOwner);
            Object var10_11 = null;
            transactionManager2.commit();
            return var10_11;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void sendStatus_aroundBody14(PMMService this_, Title title, String statusName, String statusValue, boolean success, String sourceComponentName, String sourceEntityName, String sourceId) {
        Long plannerId = this_.findEarliestUpcomingPlannerId(title);
        this_.progressManager.updateStatus(title.getId(), plannerId, statusName, statusValue, success, sourceComponentName, sourceEntityName, sourceId);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object sendStatus_aroundBody15$advice(PMMService this_, Title transactional, String ajc_aroundClosure, String string, boolean bl, String string2, String string3, String string4, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void isTransactionOwner;
        void transactionManager;
        TransactionManager transactionManager2 = null;
        boolean bl2 = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl2 = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl2) {
            AroundClosure aroundClosure2 = aroundClosure;
            Transactional transactional3 = transactional2;
            PMMService.sendStatus_aroundBody14(this_, transactional, ajc_aroundClosure, (String)transactionManager, (boolean)isTransactionOwner, (String)e, string3, string4);
            return null;
        }
        try {
            transactionManager2.begin();
            AroundClosure aroundClosure3 = aroundClosure;
            Transactional transactional4 = transactional2;
            PMMService.sendStatus_aroundBody14(this_, transactional, ajc_aroundClosure, (String)transactionManager, (boolean)isTransactionOwner, (String)e, string3, string4);
            Object var13_14 = null;
            transactionManager2.commit();
            return var13_14;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager2.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void updateTitleStatus_aroundBody16(PMMService this_, Title rootTitle) {
        Asset rootAsset = rootTitle.getAsset();
        if (rootTitle.getStatus() == TitleStatus.APPROVED) {
            return;
        }
        if (this_.containsValue(rootTitle.getExternalLocation())) {
            rootTitle.setStatus(TitleStatus.READY);
            return;
        }
        rootTitle.setStatus(TitleStatus.READY);
        if (!this_.hasOriginalFile(rootAsset)) {
            rootTitle.setStatus(TitleStatus.NEW);
            return;
        }
        for (Asset sectionAsset : rootAsset.getAllDescendantItems(false)) {
            Item sectionItem = (Item)sectionAsset;
            if (this_.getFileName(sectionItem) == null || this_.hasOriginalFile((Asset)sectionItem)) continue;
            rootTitle.setStatus(TitleStatus.NEW);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object updateTitleStatus_aroundBody17$advice(PMMService this_, Title transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            PMMService.updateTitleStatus_aroundBody16(this_, transactional);
            return null;
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            PMMService.updateTitleStatus_aroundBody16(this_, transactional);
            Object var7_8 = null;
            object.commit();
            return var7_8;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

