/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.AssetListEventType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class Planner
extends Schedule {
    public Planner() {
    }

    public Planner(Long sourcePartnerID, Date date) {
        super(sourcePartnerID, date);
    }

    public Date getArrivalDate() {
        return this.date;
    }

    public void setArrivalDate(Date date) {
        this.setDate(date);
    }

    @Override
    public TitleListType getType() {
        return TitleListType.PLANNER;
    }

    @Override
    protected void addTitleInternal(Title title) {
        super.addTitleInternal(title);
        if (title.getProgressItems() != null) {
            for (ProgressItem pi : title.getProgressItems()) {
                if (pi.getAssetListId() != null) continue;
                this.addProgressItem(pi);
            }
        }
    }

    @Override
    public void setTitles(Collection<Title> titles) {
        boolean titlesAdded = false;
        boolean titlesRemoved = false;
        for (Title newTitle : titles) {
            Title matchingExistingTitle = null;
            for (Title existingTitle : this.titles) {
                if (!existingTitle.equals(newTitle)) continue;
                matchingExistingTitle = existingTitle;
                break;
            }
            if (matchingExistingTitle != null) {
                this.titles.remove(matchingExistingTitle);
                this.titles.add(newTitle);
                continue;
            }
            this.addTitleInternal(newTitle);
            titlesAdded = true;
        }
        ArrayList<Title> titlesToBeRemoved = new ArrayList<Title>();
        for (Title existingTitle : this.titles) {
            if (titles.contains(existingTitle)) continue;
            titlesToBeRemoved.add(existingTitle);
        }
        if (!titlesToBeRemoved.isEmpty()) {
            titlesRemoved = true;
            for (Title t : titlesToBeRemoved) {
                this.removeTitleInternal(t);
            }
        }
        if (titlesAdded) {
            this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_ADDED));
        }
        if (titlesRemoved) {
            this.fireEvent(new AssetListEvent(this, this, AssetListEventType.TITLES_REMOVED));
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", arrival date " + this.getArrivalDate();
    }
}

