/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.referenceEvaluator;

import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.util.ParameterReferenceHelper;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.MenuOption;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import java.util.Map;
import org.apache.log4j.Logger;

public class TitleReferenceEvaluator
extends ReferenceEvaluator {
    private Logger logger = Logger.getLogger(TitleReferenceEvaluator.class);
    private static String TITLE_PARAMETER_REFERENCE_GROUP = "Title";
    private static String TITLE_ID = "Id";
    private static String TITLE_NAME = "Name";
    private static String TITLE_SOURCE_PATH = "External Source Path";
    private ITitleService titleService;
    private ISpecificationManager specMgr;

    public ITitleService getTitleService() {
        return this.titleService;
    }

    public void setTitleService(ITitleService titleService) {
        this.titleService = titleService;
    }

    public ISpecificationManager getSpecMgr() {
        return this.specMgr;
    }

    public void setSpecMgr(ISpecificationManager specMgr) {
        this.specMgr = specMgr;
    }

    public TitleReferenceEvaluator(ITitleService titleService, ISpecificationManager specMgr) {
        this.titleService = titleService;
        this.specMgr = specMgr;
    }

    @Override
    @Deprecated
    public void evaluate(Object entity, Map<String, Object> info) {
    }

    @Override
    public ParameterReferencePath getPath(String property) {
        try {
            String groupName;
            if (ParameterReferenceHelper.isParameterReference(property) && (groupName = ParameterReferenceHelper.getGroupName(property)).startsWith(TITLE_PARAMETER_REFERENCE_GROUP)) {
                String specName = ParameterReferenceHelper.getLeafGroup(groupName);
                String propertyName = ParameterReferenceHelper.getPropertyName(property);
                Specification spec = this.specMgr.getSpecificationByName(specName);
                if (spec == null) {
                    throw new RuntimeException("Specification: " + specName + " not found for property: " + propertyName);
                }
                MenuOption option = spec.getJobRuleMenuOption(propertyName);
                boolean isMetadata = option.isMetadata();
                String optionPropertyName = isMetadata ? option.getMetadataProperty() : option.getProperty();
                ParameterReferencePath path = new ParameterReferencePath();
                path.setName(option.getTitleName());
                path.setParameterReference(property);
                path.setPropertyName(optionPropertyName);
                path.setMetadata(isMetadata);
                return path;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting path for: " + property, e);
        }
        if (this.successor != null) {
            return this.successor.getPath(property);
        }
        return null;
    }
}

