/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.timers;

import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.timers.ITimeRepresentation;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerHelper;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerResult;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class EveryNWeeks
implements ITimeRepresentation {
    private static int DAYS_IN_WEEK = 7;
    private static long MSEC_IN_ONE_DAY = 86400000L;
    private static final Logger logger = Logger.getLogger(EveryNWeeks.class);

    @Override
    public Object getTime(List<RuleTypeParameter> ruleTypeParams, List<RuleParameter> params, Date startDate) {
        String numberOfWeeks = TimerHelper.getParameter(ruleTypeParams, params, RuleParameterDataType.INTEGER);
        if (numberOfWeeks == null) {
            logger.error((Object)"NumberOfWeeks is not specified.");
            return null;
        }
        if (Integer.parseInt(numberOfWeeks) == 0) {
            logger.error((Object)"NumberOfWeeks cannot be 0.");
            return null;
        }
        String jobTime = TimerHelper.getParameter(ruleTypeParams, params, RuleParameterDataType.TIME);
        Date jobStartDate = TimerHelper.getStartDateTime(startDate, jobTime);
        int numberOfDays = Integer.parseInt(numberOfWeeks) * DAYS_IN_WEEK;
        long periodicity = (long)numberOfDays * MSEC_IN_ONE_DAY;
        TimerResult result = new TimerResult(true, periodicity, jobStartDate);
        return result;
    }
}

