/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.timers;

import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.timers.EveryNWeeks;
import com.tandbergtv.watchpoint.pmm.job.timers.ITimeRepresentation;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerHelper;
import com.tandbergtv.watchpoint.pmm.job.util.Day;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class OnDayEveryNWeeks
implements ITimeRepresentation {
    private static final Logger logger = Logger.getLogger(OnDayEveryNWeeks.class);
    public static String DATE_FORMAT = "EEE MMM dd HH:mm:ss z yyyy";

    @Override
    public Object getTime(List<RuleTypeParameter> ruleTypeParams, List<RuleParameter> params, Date startDate) {
        String day = TimerHelper.getParameter(ruleTypeParams, params, RuleParameterDataType.DAY);
        logger.debug((Object)("Initial job start date: " + startDate));
        Date jobStartDate = this.getClosestDay(startDate, day);
        logger.debug((Object)("Setting job start date to: " + jobStartDate.toString()));
        EveryNWeeks weeklyTimer = new EveryNWeeks();
        return weeklyTimer.getTime(ruleTypeParams, params, jobStartDate);
    }

    private Date getClosestDay(Date startDate, String day) {
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        int startDay = c.get(7);
        int d = Day.valueOf(day).ordinal() + 1;
        if (startDay == d) {
            return startDate;
        }
        int daysLeftInWeek = 7 - startDay;
        int daysToAdd = daysLeftInWeek + d;
        c.add(5, daysToAdd);
        return c.getTime();
    }
}

