/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContext;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Service;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.dao.PartnerHDAO;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.pmm.util.DataOperationException;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Session;

public class PartnerManager
implements IPartnerManagement {
    private static PartnerManager uniqueInstance = new PartnerManager();
    private static final Logger logger = Logger.getLogger(PartnerManager.class);
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";

    public static IPartnerManagement getInstance() {
        return uniqueInstance;
    }

    @Override
    @Transactional
    public synchronized List<Partner> getPartnersBySearchCriteria(SearchCriteria searchCriteria) {
        SearchCriteria searchCriteria2 = searchCriteria;
        return (List)PartnerManager.getPartnersBySearchCriteria_aroundBody1$advice(this, searchCriteria2, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getPartnersBySearchCriteria", SearchCriteria.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Partner createPartner(Partner partner) {
        Partner partner2 = partner;
        return (Partner)PartnerManager.createPartner_aroundBody3$advice(this, partner2, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("createPartner", Partner.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized boolean deletePartner(long partnerId) throws DataOperationException {
        long l = partnerId;
        return Conversions.booleanValue((Object)PartnerManager.deletePartner_aroundBody5$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("deletePartner", Long.TYPE).getAnnotation(Transactional.class), null));
    }

    private int countPitchSchedules(Long contextId) {
        int result = 0;
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("pitch", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        criteria.addParameter((SearchParameterBase)e);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        result = searchService.count(criteria);
        return result;
    }

    private int countPlanners(long partnerId) {
        int result = 0;
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter("sourcePartnerID", SearchType.NUMERIC, (Object)partnerId));
        criteria.addParameter((SearchParameterBase)e);
        IScheduleSearchService searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        result = searchService.count(criteria);
        return result;
    }

    @Override
    @Transactional
    public synchronized Partner getPartner(long partnerId) {
        long l = partnerId;
        return (Partner)PartnerManager.getPartner_aroundBody7$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getPartner", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized List<Partner> getAllActivePartners() {
        return (List)PartnerManager.getAllActivePartners_aroundBody9$advice(this, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getAllActivePartners", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized Partner updatePartner(Partner partner) {
        Partner partner2 = partner;
        return (Partner)PartnerManager.updatePartner_aroundBody11$advice(this, partner2, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("updatePartner", Partner.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Partner getSourcePartner(String providerId) {
        String string = providerId;
        return (Partner)PartnerManager.getSourcePartner_aroundBody13$advice(this, string, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getSourcePartner", String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Set<Partner> getAllPartnersAssociatedWithService(long contextId) {
        long l = contextId;
        return (Set)PartnerManager.getAllPartnersAssociatedWithService_aroundBody15$advice(this, l, TransactionEnforcer.aspectOf(), PartnerManager.class.getDeclaredMethod("getAllPartnersAssociatedWithService", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Override
    public int getTotalActivePartnerCount() {
        return this.getAllActivePartners().size();
    }

    private static final /* synthetic */ List getPartnersBySearchCriteria_aroundBody0(PartnerManager this_, SearchCriteria searchCriteria) {
        List<Partner> partnerList = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findActiveBySearchCriteria(searchCriteria);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return partnerList;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getPartnersBySearchCriteria_aroundBody1$advice(PartnerManager this_, SearchCriteria transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return PartnerManager.getPartnersBySearchCriteria_aroundBody0(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            List list = PartnerManager.getPartnersBySearchCriteria_aroundBody0(this_, transactional);
            object.commit();
            return list;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Partner createPartner_aroundBody2(PartnerManager this_, Partner partner) {
        PartnerContext context = new PartnerContext();
        context.setPartnerContainer(partner);
        partner.setContext(context);
        partner.setIsActive(true);
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerDAO.create(partner);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating a partner: ", e);
        }
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        containerCache.add((Serializable)Long.valueOf(partner.getContainerContextId()), (Object)partner);
        return partner;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object createPartner_aroundBody3$advice(PartnerManager this_, Partner transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return PartnerManager.createPartner_aroundBody2(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            Partner partner = PartnerManager.createPartner_aroundBody2(this_, transactional);
            object.commit();
            return partner;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ boolean deletePartner_aroundBody4(PartnerManager this_, long partnerId) {
        Partner partner = this_.getPartner(partnerId);
        long contextId = partner.getContainerContextId();
        int schedulesCount = 0;
        PartnerType partnerType = partner.getType();
        schedulesCount = partnerType == PartnerType.SOURCE ? this_.countPlanners(partnerId) : (partnerType == PartnerType.DISTRIBUTION ? this_.countPitchSchedules(new Long(contextId)) : 0);
        if (schedulesCount > 0) {
            logger.error((Object)("Cannot delete the partner with partnerId=" + partnerId + " since there are " + schedulesCount + " schedules associated with the partner"));
            throw new DataOperationException("Partner [" + partnerId + "] cannot be deleted since there are schedules associated with it.");
        }
        if (partner.getServices() != null && partner.getServices().size() > 0) {
            logger.error((Object)("Cannot delete the partner with partnerId=" + partnerId + " since there are services associated with the partner"));
            throw new DataOperationException("Partner [" + partnerId + "] cannot be deleted since there are services associated with it.");
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partner.setIsActive(false);
            partnerDAO.update(partner);
        }
        catch (Exception e) {
            logger.error((Object)("Error while deleting partner (id: " + partnerId + "): "), (Throwable)e);
            return false;
        }
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        containerCache.remove((Serializable)Long.valueOf(contextId));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object deletePartner_aroundBody5$advice(PartnerManager this_, long transactional, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_10 = e;
            void var11_11 = isTransactionOwner;
            return Conversions.booleanObject((boolean)PartnerManager.deletePartner_aroundBody4(this_, transactional));
        }
        try {
            transactionManager.begin();
            void var12_12 = e;
            void var13_13 = isTransactionOwner;
            Object object = Conversions.booleanObject((boolean)PartnerManager.deletePartner_aroundBody4(this_, transactional));
            transactionManager.commit();
            return object;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Partner getPartner_aroundBody6(PartnerManager this_, long partnerId) {
        Partner result = null;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            result = (Partner)partnerDAO.findByKey(partnerId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting a partner: ", e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getPartner_aroundBody7$advice(PartnerManager this_, long transactional, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_10 = e;
            void var11_11 = isTransactionOwner;
            return PartnerManager.getPartner_aroundBody6(this_, transactional);
        }
        try {
            transactionManager.begin();
            void var12_12 = e;
            void var13_13 = isTransactionOwner;
            Partner partner = PartnerManager.getPartner_aroundBody6(this_, transactional);
            transactionManager.commit();
            return partner;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ List getAllActivePartners_aroundBody8(PartnerManager this_) {
        Session session = null;
        List<Partner> partnerList = null;
        try {
            session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findByActive(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving partners: ", e);
        }
        return partnerList;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getAllActivePartners_aroundBody9$advice(PartnerManager this_, TransactionEnforcer transactional, Transactional ajc_aroundClosure, AroundClosure aroundClosure) {
        void transactionManager;
        void e;
        TransactionManager isTransactionOwner;
        Object var4_4 = null;
        boolean bl = false;
        try {
            isTransactionOwner = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = isTransactionOwner.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (e == false) {
            void var8_9 = transactionManager;
            Transactional transactional2 = ajc_aroundClosure;
            return PartnerManager.getAllActivePartners_aroundBody8(this_);
        }
        try {
            isTransactionOwner.begin();
            void var10_11 = transactionManager;
            Transactional transactional3 = ajc_aroundClosure;
            List list = PartnerManager.getAllActivePartners_aroundBody8(this_);
            isTransactionOwner.commit();
            return list;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                isTransactionOwner.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Partner updatePartner_aroundBody10(PartnerManager this_, Partner partner) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerDAO.update(partner);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating a partner: ", e);
        }
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        containerCache.add((Serializable)Long.valueOf(partner.getContainerContextId()), (Object)partner);
        return partner;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object updatePartner_aroundBody11$advice(PartnerManager this_, Partner transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return PartnerManager.updatePartner_aroundBody10(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            Partner partner = PartnerManager.updatePartner_aroundBody10(this_, transactional);
            object.commit();
            return partner;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Partner getSourcePartner_aroundBody12(PartnerManager this_, String providerId) {
        Partner result = null;
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        for (Serializable key : containerCache.getKeys()) {
            Partner partner;
            IContainer container = (IContainer)containerCache.get(key);
            if (container.getContainerType() != ContainerType.PARTNER || !(partner = (Partner)container).getProviderId().equals(providerId) || partner.getType() != PartnerType.SOURCE) continue;
            result = partner;
            break;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getSourcePartner_aroundBody13$advice(PartnerManager this_, String transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return PartnerManager.getSourcePartner_aroundBody12(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            Partner partner = PartnerManager.getSourcePartner_aroundBody12(this_, transactional);
            object.commit();
            return partner;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ Set getAllPartnersAssociatedWithService_aroundBody14(PartnerManager this_, long contextId) {
        Set<Object> partners = new HashSet();
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)Long.valueOf(contextId));
        if (container.getContainerType() == ContainerType.SERVICE) {
            Service service = (Service)container;
            partners = service.getPartners();
        }
        return partners;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getAllPartnersAssociatedWithService_aroundBody15$advice(PartnerManager this_, long transactional, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_10 = e;
            void var11_11 = isTransactionOwner;
            return PartnerManager.getAllPartnersAssociatedWithService_aroundBody14(this_, transactional);
        }
        try {
            transactionManager.begin();
            void var12_12 = e;
            void var13_13 = isTransactionOwner;
            Set set = PartnerManager.getAllPartnersAssociatedWithService_aroundBody14(this_, transactional);
            transactionManager.commit();
            return set;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

