/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner.dao;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateDAO;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class PartnerHDAO
extends HibernateDAO<Partner, Long> {
    private static final Logger log = Logger.getLogger(PartnerHDAO.class);

    public PartnerHDAO(Class<Partner> persistentClass, Session session) {
        super(persistentClass, session);
    }

    public PartnerHDAO(Session session) {
        super(Partner.class, session);
    }

    public List<Partner> findActiveBySearchCriteria(SearchCriteria searchCriteria) {
        String logString = "Finding all active Partners by Search Criteria using Ordering: ";
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            logString = logString + param.getSortingOrder() + " for property: ";
            logString = logString + param.getFieldName() + " ";
        }
        log.debug((Object)logString);
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"isActive", (Object)true)});
        criteria.setFirstResult(searchCriteria.getStartingRecordNumber());
        if (searchCriteria.getRecordsCount() > 0) {
            criteria.setMaxResults(searchCriteria.getRecordsCount());
        }
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            String orderProperty = param.getFieldName();
            switch (param.getSortingOrder()) {
                case ASCENDING: {
                    criteria.addOrder(Order.asc((String)orderProperty));
                    break;
                }
                case DESCENDING: {
                    criteria.addOrder(Order.desc((String)orderProperty));
                }
            }
        }
        List<Partner> activeList = this.findByCriteria(criteria);
        log.debug((Object)("Found the Partners (" + activeList.size() + ") for the given Search Criteria."));
        return activeList;
    }

    public List<Partner> findByActive(boolean isActive) {
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"isActive", (Object)isActive)});
        List<Partner> activeList = this.findByCriteria(criteria);
        return activeList;
    }
}

