/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.specimpl.SpecHandlerBase;
import com.tandbergtv.watchpoint.pmm.title.conf.IMetadataConverter;
import com.tandbergtv.watchpoint.pmm.title.conf.MenuOption;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class Specification {
    private String name;
    private String converterClass;
    private List<MenuOption> jobRuleMenuOptions = new ArrayList<MenuOption>();
    private List<MenuOption> jobParameterMenuOptions = new ArrayList<MenuOption>();
    private List<TitleConf> rootTitleConfs = new ArrayList<TitleConf>();
    private ClassLoader classLoader = null;
    private String tableConfigurationPath;
    private String definitionPath;
    private ISpecHandler specHandler;
    private ITranslator translator;
    private ResourceBundle bundle;

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getConverterClass() {
        return this.converterClass;
    }

    public void setConverterClass(String converterClass) {
        this.converterClass = converterClass;
    }

    public List<MenuOption> getJobRuleMenuOptions() {
        return this.jobRuleMenuOptions;
    }

    void setJobRuleMenuOptions(List<MenuOption> jobRuleMenuOptions) {
        this.jobRuleMenuOptions = jobRuleMenuOptions;
    }

    public List<MenuOption> getJobParameterMenuOptions() {
        return this.jobParameterMenuOptions;
    }

    void setJobParameterMenuOptions(List<MenuOption> jobParameterMenuOptions) {
        this.jobParameterMenuOptions = jobParameterMenuOptions;
    }

    public TitleConf getRootTitleConf() {
        return this.rootTitleConfs.size() > 0 ? this.rootTitleConfs.get(0) : null;
    }

    public List<TitleConf> getRootTitleConfs() {
        return this.rootTitleConfs;
    }

    void setRootTitleConfs(List<TitleConf> rootTitleConfs) {
        this.rootTitleConfs = rootTitleConfs != null ? rootTitleConfs : new ArrayList();
    }

    void addRootTitleConf(TitleConf rootTitleConf) {
        this.rootTitleConfs.add(rootTitleConf);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getTableConfigurationPath() {
        return this.tableConfigurationPath;
    }

    public void setTableConfigurationPath(String tableConfigurationPath) {
        this.tableConfigurationPath = tableConfigurationPath;
    }

    public String getDefinitionPath() {
        return this.definitionPath;
    }

    public void setDefinitionPath(String definitionPath) {
        this.definitionPath = definitionPath;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    void addJobRuleMenuOption(String name, String value) {
        if (this.jobRuleMenuOptions == null) {
            this.jobRuleMenuOptions = new ArrayList<MenuOption>();
        }
        this.jobRuleMenuOptions.add(new MenuOption(name, value));
    }

    public MenuOption getJobRuleMenuOption(String optionName) {
        if (this.jobRuleMenuOptions != null) {
            for (MenuOption jrmo : this.jobRuleMenuOptions) {
                if (!jrmo.getName().equals(optionName)) continue;
                return jrmo;
            }
        }
        return null;
    }

    public MenuOption getJobParameterMenuOption(String optionName) {
        if (this.jobParameterMenuOptions != null) {
            for (MenuOption jpmo : this.jobParameterMenuOptions) {
                if (!jpmo.getName().equals(optionName)) continue;
                return jpmo;
            }
        }
        return null;
    }

    void addJobParameterMenuOption(String name, String value) {
        if (this.jobParameterMenuOptions == null) {
            this.jobParameterMenuOptions = new ArrayList<MenuOption>();
        }
        this.jobParameterMenuOptions.add(new MenuOption(name, value));
    }

    public List<TitleConf> getAllTitleConf() {
        ArrayList<TitleConf> allTitleConf = new ArrayList<TitleConf>();
        for (TitleConf titleConf : this.rootTitleConfs) {
            allTitleConf.add(titleConf);
            allTitleConf.addAll(titleConf.getAllDescendants());
        }
        return allTitleConf;
    }

    public TitleConf getTitleConfByName(String name) {
        for (TitleConf tc : this.getAllTitleConf()) {
            if (!tc.getName().equals(name)) continue;
            return tc;
        }
        return null;
    }

    public List<Variable> getMetadata() {
        ArrayList<Variable> allVariables = new ArrayList<Variable>();
        for (TitleConf tc : this.getAllTitleConf()) {
            allVariables.addAll(tc.getMetadata());
        }
        return allVariables;
    }

    public IMetadataConverter getMetadataConverter() {
        try {
            Class<?> clazz = this.classLoader.loadClass(this.converterClass);
            return (IMetadataConverter)IMetadataConverter.class.cast(clazz.newInstance());
        }
        catch (Exception e) {
            String msg = "Failed to create an instance of " + IMetadataConverter.class.getSimpleName() + " implementation: " + this.converterClass;
            throw new RuntimeException(msg, e);
        }
    }

    public ISpecHandler getSpecHandler() {
        return this.specHandler;
    }

    public void setSpecHandler(ISpecHandler specHandler) {
        this.specHandler = specHandler;
    }

    public ITranslator getTranslator() {
        if (this.specHandler instanceof SpecHandlerBase) {
            return ((SpecHandlerBase)SpecHandlerBase.class.cast(this.specHandler)).getFromTTV();
        }
        return this.translator;
    }

    public void setTranslator(ITranslator translator) {
        this.translator = translator;
    }

    public InputStream getTableExtensionConfiguration() {
        return this.classLoader.getResourceAsStream(this.tableConfigurationPath);
    }

    public String toString() {
        return "Specification: " + this.name;
    }
}

