/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.MenuOption;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SpecificationManager
implements ISpecificationManager {
    private static final Logger logger = Logger.getLogger(SpecificationManager.class);
    private static final String SERVICE_NAME = "Specification Manager";
    private boolean started = false;
    private Collection<Specification> specs = new ArrayList<Specification>();

    private SpecificationManager() {
    }

    public static SpecificationManager newInstance() {
        return new SpecificationManager();
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        logger.info((Object)"Successfully started the Specification Manager.");
    }

    public synchronized void stop() {
        this.specs = new HashSet<Specification>();
        this.started = false;
    }

    @Override
    public Collection<Specification> getAllSpecifications() {
        return this.specs;
    }

    @Override
    public Specification getSpecificationByName(String name) {
        for (Specification s : this.specs) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @Override
    public void addSpecification(Specification specification) {
        this.specs.add(specification);
    }

    @Override
    public Map<String, Set<String>> getJobRuleMenuOptions() {
        HashMap<String, Set<String>> allJobRuleMenuOptions = new HashMap<String, Set<String>>();
        for (Specification s : this.specs) {
            allJobRuleMenuOptions.put(s.getName(), this.getMenuOptionNames(s.getJobRuleMenuOptions()));
        }
        return allJobRuleMenuOptions;
    }

    @Override
    public Map<String, Set<String>> getJobParameterMenuOptions() {
        HashMap<String, Set<String>> allJobParameterMenuOptions = new HashMap<String, Set<String>>();
        for (Specification s : this.specs) {
            allJobParameterMenuOptions.put(s.getName(), this.getMenuOptionNames(s.getJobParameterMenuOptions()));
        }
        return allJobParameterMenuOptions;
    }

    private Set<String> getMenuOptionNames(List<MenuOption> menuOptions) {
        HashSet<String> menuOptionNames = new HashSet<String>();
        if (menuOptions != null) {
            for (MenuOption mo : menuOptions) {
                menuOptionNames.add(mo.getName());
            }
        }
        return menuOptionNames;
    }
}

